/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.rtf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import javax.swing.text.rtf.AbstractFilter;

abstract class RTFParser
extends AbstractFilter {
    public int level = 0;
    private int state = 0;
    private StringBuffer currentCharacters;
    private String pendingKeyword = null;
    private int pendingCharacter;
    private long binaryBytesLeft;
    ByteArrayOutputStream binaryBuf;
    private boolean[] savedSpecials;
    protected PrintStream warnings;
    private final int S_text = 0;
    private final int S_backslashed = 1;
    private final int S_token = 2;
    private final int S_parameter = 3;
    private final int S_aftertick = 4;
    private final int S_aftertickc = 5;
    private final int S_inblob = 6;
    protected CharsetDecoder decoder = null;
    private byte[] ba = new byte[2];
    protected ByteBuffer decoderBB = ByteBuffer.wrap(this.ba);
    static final boolean[] rtfSpecialsTable = (boolean[])noSpecialsTable.clone();
    private char[] ca = new char[1];
    private CharBuffer decoderCB = CharBuffer.wrap(this.ca);

    public abstract boolean handleKeyword(String var1);

    public abstract boolean handleKeyword(String var1, int var2);

    public abstract void handleText(String var1);

    public void handleText(char c) {
        this.handleText(String.valueOf(c));
    }

    public abstract void handleBinaryBlob(byte[] var1);

    public abstract void begingroup();

    public abstract void endgroup();

    public RTFParser() {
        this.currentCharacters = new StringBuffer();
        this.specialsTable = rtfSpecialsTable;
        this.decoderBB.limit(1);
    }

    @Override
    public void writeSpecial(int n) throws IOException {
        this.write((char)n);
    }

    protected void warning(String string) {
        if (this.warnings != null) {
            this.warnings.println(string);
        }
    }

    @Override
    public void write(String string) throws IOException {
        if (this.state != 0) {
            int n;
            int n2 = string.length();
            for (n = 0; n < n2 && this.state != 0; ++n) {
                this.write(string.charAt(n));
            }
            if (n >= n2) {
                return;
            }
            string = string.substring(n);
        }
        if (this.currentCharacters.length() > 0) {
            this.currentCharacters.append(string);
        } else {
            this.handleText(string);
        }
    }

    @Override
    public void write(char c) throws IOException {
        switch (this.state) {
            case 0: {
                if (c == '\n' || c == '\r') break;
                if (c == '{') {
                    if (this.currentCharacters.length() > 0) {
                        this.handleText(this.currentCharacters.toString());
                        this.currentCharacters = new StringBuffer();
                    }
                    ++this.level;
                    this.begingroup();
                    break;
                }
                if (c == '}') {
                    if (this.currentCharacters.length() > 0) {
                        this.handleText(this.currentCharacters.toString());
                        this.currentCharacters = new StringBuffer();
                    }
                    if (this.level == 0) {
                        throw new IOException("Too many close-groups in RTF text");
                    }
                    this.endgroup();
                    --this.level;
                    break;
                }
                if (c == '\\') {
                    if (this.currentCharacters.length() > 0) {
                        this.handleText(this.currentCharacters.toString());
                        this.currentCharacters = new StringBuffer();
                    }
                    this.state = 1;
                    break;
                }
                c = this.decode(c);
                this.currentCharacters.append(c);
                break;
            }
            case 1: {
                if (c == '\'') {
                    this.state = 4;
                    break;
                }
                if (!Character.isLetter(c)) {
                    char[] cArray = new char[]{c};
                    if (!this.handleKeyword(new String(cArray))) {
                        this.warning("Unknown keyword: " + cArray + " (" + (byte)c + ")");
                    }
                    this.state = 0;
                    this.pendingKeyword = null;
                    break;
                }
                this.state = 2;
            }
            case 2: {
                if (Character.isLetter(c)) {
                    this.currentCharacters.append(c);
                    break;
                }
                this.pendingKeyword = this.currentCharacters.toString();
                this.currentCharacters = new StringBuffer();
                if (Character.isDigit(c) || c == '-') {
                    this.state = 3;
                    this.currentCharacters.append(c);
                    break;
                }
                boolean bl = this.handleKeyword(this.pendingKeyword);
                if (!bl) {
                    this.warning("Unknown keyword: " + this.pendingKeyword);
                }
                this.pendingKeyword = null;
                this.state = 0;
                if (Character.isWhitespace(c)) break;
                this.write(c);
                break;
            }
            case 3: {
                if (Character.isDigit(c)) {
                    this.currentCharacters.append(c);
                    break;
                }
                if (this.pendingKeyword.equals("bin")) {
                    long l = 0L;
                    try {
                        l = Long.parseLong(this.currentCharacters.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.warning("Illegal number format " + this.currentCharacters.toString() + " in \bin tag");
                        this.pendingKeyword = null;
                        this.currentCharacters = new StringBuffer();
                        this.state = 0;
                        if (Character.isWhitespace(c)) break;
                        this.write(c);
                        break;
                    }
                    this.pendingKeyword = null;
                    this.state = 6;
                    int n = 0x400000;
                    this.binaryBytesLeft = l;
                    if (this.binaryBytesLeft > (long)n) {
                        this.binaryBuf = new ByteArrayOutputStream(n);
                    } else if (this.binaryBytesLeft < 0L) {
                        this.binaryBytesLeft = 0L;
                        this.binaryBuf = new ByteArrayOutputStream((int)this.binaryBytesLeft);
                    } else {
                        this.binaryBuf = new ByteArrayOutputStream((int)this.binaryBytesLeft);
                    }
                    this.savedSpecials = this.specialsTable;
                    this.specialsTable = allSpecialsTable;
                    break;
                }
                int n = 0;
                try {
                    n = Integer.parseInt(this.currentCharacters.toString());
                    boolean bl = this.handleKeyword(this.pendingKeyword, n);
                    if (!bl) {
                        this.warning("Unknown keyword: " + this.pendingKeyword + " (param " + this.currentCharacters + ")");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.warning("Illegal number format " + this.currentCharacters.toString() + " in " + this.pendingKeyword + " tag");
                }
                this.pendingKeyword = null;
                this.currentCharacters = new StringBuffer();
                this.state = 0;
                if (Character.isWhitespace(c)) break;
                this.write(c);
                break;
            }
            case 4: {
                if (Character.digit(c, 16) == -1) {
                    this.state = 0;
                    break;
                }
                this.pendingCharacter = Character.digit(c, 16);
                this.state = 5;
                break;
            }
            case 5: {
                this.state = 0;
                if (Character.digit(c, 16) == -1) break;
                this.pendingCharacter = this.pendingCharacter * 16 + Character.digit(c, 16);
                char c2 = c = this.decoder == null ? this.translationTable[this.pendingCharacter] : this.decode((char)this.pendingCharacter);
                if (c == '\u0000') break;
                this.handleText(c);
                break;
            }
            case 6: {
                if (this.binaryBytesLeft > 0L) {
                    this.binaryBuf.write(c);
                    --this.binaryBytesLeft;
                    break;
                }
                this.state = 0;
                this.specialsTable = this.savedSpecials;
                this.savedSpecials = null;
                this.handleBinaryBlob(this.binaryBuf.toByteArray());
                this.binaryBuf = null;
            }
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        if (this.state == 0 && this.currentCharacters.length() > 0) {
            this.handleText(this.currentCharacters.toString());
            this.currentCharacters = new StringBuffer();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.state != 0 || this.level > 0) {
            this.warning("Truncated RTF file.");
            while (this.level > 0) {
                this.endgroup();
                --this.level;
            }
        }
        super.close();
    }

    private char decode(char c) {
        if (this.decoder == null) {
            return c;
        }
        this.decoderBB.put((byte)c);
        this.decoderBB.rewind();
        this.decoderCB.clear();
        CoderResult coderResult = this.decoder.decode(this.decoderBB, this.decoderCB, false);
        if (coderResult.isUnderflow()) {
            if (this.decoderCB.position() == 1) {
                char c2 = this.decoderCB.get(0);
                this.decoder.reset();
                this.decoderBB.clear();
                this.decoderBB.limit(1);
                return c2;
            }
            this.decoder.reset();
            this.decoderBB.limit(2);
            this.decoderBB.position(1);
            return '\u0000';
        }
        this.decoder.reset();
        this.decoderBB.clear();
        this.decoderBB.limit(1);
        return '\ufffd';
    }

    static {
        RTFParser.rtfSpecialsTable[10] = true;
        RTFParser.rtfSpecialsTable[13] = true;
        RTFParser.rtfSpecialsTable[123] = true;
        RTFParser.rtfSpecialsTable[125] = true;
        RTFParser.rtfSpecialsTable[92] = true;
    }
}

