/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.parser;

import com.sun.org.apache.xml.internal.security.parser.XMLParser;
import com.sun.org.apache.xml.internal.security.parser.XMLParserException;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.ArrayBlockingQueue;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLParserImpl
implements XMLParser {
    private static int parserPoolSize = AccessController.doPrivileged(() -> Integer.getInteger("com.sun.org.apache.xml.internal.security.parser.pool-size", 20));
    private static final Map<ClassLoader, Queue<DocumentBuilder>> DOCUMENT_BUILDERS = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<ClassLoader, Queue<DocumentBuilder>> DOCUMENT_BUILDERS_DISALLOW_DOCTYPE = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public Document parse(InputStream inputStream, boolean bl) throws XMLParserException {
        try {
            ClassLoader classLoader = XMLParserImpl.getContextClassLoader();
            if (classLoader == null) {
                classLoader = XMLParserImpl.getClassLoader(XMLUtils.class);
            }
            if (classLoader == null) {
                DocumentBuilder documentBuilder = XMLParserImpl.createDocumentBuilder(bl);
                return documentBuilder.parse(inputStream);
            }
            Queue<DocumentBuilder> queue = XMLParserImpl.getDocumentBuilderQueue(bl, classLoader);
            DocumentBuilder documentBuilder = XMLParserImpl.getDocumentBuilder(bl, queue);
            Document document = documentBuilder.parse(inputStream);
            XMLParserImpl.repoolDocumentBuilder(documentBuilder, queue);
            return document;
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new XMLParserException(exception, "empty", new Object[]{"Error parsing the inputstream"});
        }
    }

    private static Queue<DocumentBuilder> getDocumentBuilderQueue(boolean bl, ClassLoader classLoader) throws ParserConfigurationException {
        Map<ClassLoader, Queue<DocumentBuilder>> map = bl ? DOCUMENT_BUILDERS_DISALLOW_DOCTYPE : DOCUMENT_BUILDERS;
        Queue<DocumentBuilder> queue = map.get(classLoader);
        if (queue == null) {
            queue = new ArrayBlockingQueue<DocumentBuilder>(parserPoolSize);
            map.put(classLoader, queue);
        }
        return queue;
    }

    private static DocumentBuilder getDocumentBuilder(boolean bl, Queue<DocumentBuilder> queue) throws ParserConfigurationException {
        DocumentBuilder documentBuilder = queue.poll();
        if (documentBuilder == null) {
            documentBuilder = XMLParserImpl.createDocumentBuilder(bl);
        }
        return documentBuilder;
    }

    private static DocumentBuilder createDocumentBuilder(boolean bl) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", bl);
        return documentBuilderFactory.newDocumentBuilder();
    }

    private static void repoolDocumentBuilder(DocumentBuilder documentBuilder, Queue<DocumentBuilder> queue) {
        if (queue != null) {
            documentBuilder.reset();
            queue.offer(documentBuilder);
        }
    }

    private static ClassLoader getContextClassLoader() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        return Thread.currentThread().getContextClassLoader();
    }

    private static ClassLoader getClassLoader(final Class<?> clazz) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return clazz.getClassLoader();
                }
            });
        }
        return clazz.getClassLoader();
    }
}

