/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import com.sun.org.apache.xml.internal.security.keys.content.KeyInfoReference;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverContext;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class KeyInfoReferenceResolver
extends KeyResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(KeyInfoReferenceResolver.class);

    @Override
    protected boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        return XMLUtils.elementIsInSignature11Space(element, "KeyInfoReference");
    }

    @Override
    protected PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        try {
            KeyInfo keyInfo = this.resolveReferentKeyInfo(element, string, storageResolver, bl);
            if (keyInfo != null) {
                return keyInfo.getPublicKey();
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.debug("XMLSecurityException", xMLSecurityException);
        }
        return null;
    }

    @Override
    protected X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        try {
            KeyInfo keyInfo = this.resolveReferentKeyInfo(element, string, storageResolver, bl);
            if (keyInfo != null) {
                return keyInfo.getX509Certificate();
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.debug("XMLSecurityException", xMLSecurityException);
        }
        return null;
    }

    @Override
    protected SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        try {
            KeyInfo keyInfo = this.resolveReferentKeyInfo(element, string, storageResolver, bl);
            if (keyInfo != null) {
                return keyInfo.getSecretKey();
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.debug("XMLSecurityException", xMLSecurityException);
        }
        return null;
    }

    @Override
    public PrivateKey engineResolvePrivateKey(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        try {
            KeyInfo keyInfo = this.resolveReferentKeyInfo(element, string, storageResolver, bl);
            if (keyInfo != null) {
                return keyInfo.getPrivateKey();
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.debug("XMLSecurityException", xMLSecurityException);
        }
        return null;
    }

    private KeyInfo resolveReferentKeyInfo(Element element, String string, StorageResolver storageResolver, boolean bl) throws XMLSecurityException {
        KeyInfoReference keyInfoReference = new KeyInfoReference(element, string);
        Attr attr = keyInfoReference.getURIAttr();
        XMLSignatureInput xMLSignatureInput = this.resolveInput(attr, string, bl);
        Element element2 = null;
        try {
            element2 = this.obtainReferenceElement(xMLSignatureInput, bl);
        }
        catch (Exception exception) {
            LOG.debug("XMLSecurityException", exception);
            return null;
        }
        if (element2 == null) {
            LOG.debug("De-reference of KeyInfoReference URI returned null: {}", attr.getValue());
            return null;
        }
        this.validateReference(element2, bl);
        KeyInfo keyInfo = new KeyInfo(element2, string);
        keyInfo.setSecureValidation(bl);
        keyInfo.addStorageResolver(storageResolver);
        return keyInfo;
    }

    private void validateReference(Element element, boolean bl) throws XMLSecurityException {
        if (!XMLUtils.elementIsInSignatureSpace(element, "KeyInfo")) {
            Object[] objectArray = new Object[]{new QName(element.getNamespaceURI(), element.getLocalName())};
            throw new XMLSecurityException("KeyInfoReferenceResolver.InvalidReferentElement.WrongType", objectArray);
        }
        KeyInfo keyInfo = new KeyInfo(element, "");
        if (keyInfo.containsKeyInfoReference() || keyInfo.containsRetrievalMethod()) {
            if (bl) {
                throw new XMLSecurityException("KeyInfoReferenceResolver.InvalidReferentElement.ReferenceWithSecure");
            }
            throw new XMLSecurityException("KeyInfoReferenceResolver.InvalidReferentElement.ReferenceWithoutSecure");
        }
    }

    private XMLSignatureInput resolveInput(Attr attr, String string, boolean bl) throws XMLSecurityException {
        ResourceResolverContext resourceResolverContext = new ResourceResolverContext(attr, string, bl);
        return ResourceResolver.resolve(resourceResolverContext);
    }

    private Element obtainReferenceElement(XMLSignatureInput xMLSignatureInput, boolean bl) throws CanonicalizationException, ParserConfigurationException, IOException, SAXException, KeyResolverException {
        Element element;
        if (xMLSignatureInput.isElement()) {
            element = (Element)xMLSignatureInput.getSubNode();
        } else {
            if (xMLSignatureInput.isNodeSet()) {
                LOG.debug("De-reference of KeyInfoReference returned an unsupported NodeSet");
                return null;
            }
            byte[] byArray = xMLSignatureInput.getBytes();
            element = KeyInfoReferenceResolver.getDocFromBytes(byArray, bl);
        }
        return element;
    }
}

