/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.misc;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.misc.Version;

public class JarVersion {
    static final String JAR_EXTENSION = ".jar";
    static final String BUILD_LEVEL = "Build-Level";

    public static void print() {
        JarVersion.print(System.err);
    }

    public static void print(PrintStream printStream) {
        JarVersion.showJars(printStream, "sun.boot.class.path");
        JarVersion.showJars(printStream, "java.class.path");
        JarVersion.showDirJars(printStream, "java.ext.dirs");
    }

    private static void showJars(PrintStream printStream, String string) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!string3.endsWith(JAR_EXTENSION)) continue;
                JarVersion.showJarVersion(printStream, string3);
            }
        }
    }

    private static void showDirJars(PrintStream printStream, String string) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                JarVersion.showDirJarVersion(printStream, string3);
            }
        }
    }

    private static void showDirJarVersion(PrintStream printStream, String string) {
        File file = new File(string);
        if (!file.isDirectory()) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].endsWith(JAR_EXTENSION)) continue;
                JarVersion.showJarVersion(printStream, string + File.separator + stringArray[i]);
            }
        }
    }

    private static void showJarVersion(PrintStream printStream, String string) {
        Object object;
        Manifest manifest = null;
        printStream.print(string);
        try {
            object = new JarFile(string);
            manifest = ((JarFile)object).getManifest();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (manifest != null) {
            String string2;
            object = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            if (object != null) {
                printStream.print("  VERSION: " + (String)object);
            }
            if ((string2 = manifest.getMainAttributes().getValue(BUILD_LEVEL)) != null) {
                printStream.print("  LEVEL: " + string2);
            }
        }
        printStream.println("");
    }

    public static void main(String[] stringArray) {
        Version version = new Version();
        version.print();
        JarVersion jarVersion = new JarVersion();
        jarVersion.print();
    }
}

