/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dataaccess;

public class ByteArrayMarshaller {
    private ByteArrayMarshaller() {
    }

    public static void writeShort(short value, byte[] byteArray, int offset, boolean bigEndian) {
        if (offset + 2 > byteArray.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. writeShort is trying to access byteArray[" + offset + "] and byteArray[" + (offset + 1) + "],  but valid indices are from 0 to " + (byteArray.length - 1) + ".");
        }
        if (bigEndian) {
            ByteArrayMarshaller.writeShort_(value, byteArray, offset, true);
        } else {
            ByteArrayMarshaller.writeShort_(value, byteArray, offset, false);
        }
    }

    private static void writeShort_(short value, byte[] byteArray, int offset, boolean bigEndian) {
        if (bigEndian) {
            byteArray[offset] = (byte)(value >> 8);
            byteArray[offset + 1] = (byte)value;
        } else {
            byteArray[offset + 1] = (byte)(value >> 8);
            byteArray[offset] = (byte)value;
        }
    }

    public static void writeShort(short value, byte[] byteArray, int offset, boolean bigEndian, int numBytes) {
        if (offset + numBytes > byteArray.length && numBytes > 0 && numBytes <= 2) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. writeShort is trying to access byteArray[" + offset + "] to byteArray[" + (offset + numBytes - 1) + "] but valid indices are from 0 to " + (byteArray.length - 1) + ".");
        }
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Access index must be positive or zero.");
        }
        if (numBytes < 0 || numBytes > 2) {
            throw new IllegalArgumentException("numBytes == " + numBytes);
        }
        if (bigEndian) {
            ByteArrayMarshaller.writeShort_(value, byteArray, offset, true, numBytes);
        } else {
            ByteArrayMarshaller.writeShort_(value, byteArray, offset, false, numBytes);
        }
    }

    private static void writeShort_(short value, byte[] byteArray, int offset, boolean bigEndian, int numBytes) {
        int i = offset;
        switch (numBytes) {
            case 0: {
                break;
            }
            case 1: {
                byteArray[i] = (byte)value;
                break;
            }
            case 2: {
                if (bigEndian) {
                    byteArray[i] = (byte)(value >> 8);
                    byteArray[i + 1] = (byte)value;
                    break;
                }
                byteArray[i + 1] = (byte)(value >> 8);
                byteArray[i] = (byte)value;
            }
        }
    }

    public static void writeInt(int value, byte[] byteArray, int offset, boolean bigEndian) {
        if (offset + 4 > byteArray.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. writeInt is trying to access byteArray[" + offset + "] to byteArray[" + (offset + 3) + "],  but valid indices are from 0 to " + (byteArray.length - 1) + ".");
        }
        if (bigEndian) {
            ByteArrayMarshaller.writeInt_(value, byteArray, offset, true);
        } else {
            ByteArrayMarshaller.writeInt_(value, byteArray, offset, false);
        }
    }

    private static void writeInt_(int value, byte[] byteArray, int offset, boolean bigEndian) {
        if (bigEndian) {
            byteArray[offset] = (byte)(value >> 24);
            byteArray[offset + 1] = (byte)(value >> 16);
            byteArray[offset + 2] = (byte)(value >> 8);
            byteArray[offset + 3] = (byte)value;
        } else {
            byteArray[offset + 3] = (byte)(value >> 24);
            byteArray[offset + 2] = (byte)(value >> 16);
            byteArray[offset + 1] = (byte)(value >> 8);
            byteArray[offset] = (byte)value;
        }
    }

    public static void writeInt(int value, byte[] byteArray, int offset, boolean bigEndian, int numBytes) {
        if (offset + numBytes > byteArray.length && numBytes <= 4 && numBytes > 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. writeInt is trying to access byteArray[" + offset + "] to byteArray[" + (offset + numBytes - 1) + "] but valid indices are from 0 to " + (byteArray.length - 1) + ".");
        }
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Access index must be positive or zero.");
        }
        if (numBytes < 0 || numBytes > 4) {
            throw new IllegalArgumentException("numBytes == " + numBytes);
        }
        if (bigEndian) {
            ByteArrayMarshaller.writeInt_(value, byteArray, offset, true, numBytes);
        } else {
            ByteArrayMarshaller.writeInt_(value, byteArray, offset, false, numBytes);
        }
    }

    private static void writeInt_(int value, byte[] byteArray, int offset, boolean bigEndian, int numBytes) {
        int i = offset;
        switch (numBytes) {
            case 0: {
                break;
            }
            case 1: {
                byteArray[i] = (byte)value;
                break;
            }
            case 2: {
                if (bigEndian) {
                    byteArray[i] = (byte)(value >> 8);
                    byteArray[i + 1] = (byte)value;
                    break;
                }
                byteArray[i + 1] = (byte)(value >> 8);
                byteArray[i] = (byte)value;
                break;
            }
            case 3: {
                if (bigEndian) {
                    byteArray[i] = (byte)(value >> 16);
                    byteArray[i + 1] = (byte)(value >> 8);
                    byteArray[i + 2] = (byte)value;
                    break;
                }
                byteArray[i + 2] = (byte)(value >> 16);
                byteArray[i + 1] = (byte)(value >> 8);
                byteArray[i] = (byte)value;
                break;
            }
            case 4: {
                if (bigEndian) {
                    byteArray[i] = (byte)(value >> 24);
                    byteArray[i + 1] = (byte)(value >> 16);
                    byteArray[i + 2] = (byte)(value >> 8);
                    byteArray[i + 3] = (byte)value;
                    break;
                }
                byteArray[i + 3] = (byte)(value >> 24);
                byteArray[i + 2] = (byte)(value >> 16);
                byteArray[i + 1] = (byte)(value >> 8);
                byteArray[i] = (byte)value;
            }
        }
    }

    public static void writeLong(long value, byte[] byteArray, int offset, boolean bigEndian) {
        if (offset + 8 > byteArray.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. writeLong is trying to access byteArray[" + offset + "] to byteArray[" + (offset + 7) + "],  but valid indices are from 0 to " + (byteArray.length - 1) + ".");
        }
        if (bigEndian) {
            ByteArrayMarshaller.writeLong_(value, byteArray, offset, true);
        } else {
            ByteArrayMarshaller.writeLong_(value, byteArray, offset, false);
        }
    }

    private static void writeLong_(long value, byte[] byteArray, int offset, boolean bigEndian) {
        if (bigEndian) {
            byteArray[offset] = (byte)(value >> 56);
            byteArray[offset + 1] = (byte)(value >> 48);
            byteArray[offset + 2] = (byte)(value >> 40);
            byteArray[offset + 3] = (byte)(value >> 32);
            byteArray[offset + 4] = (byte)(value >> 24);
            byteArray[offset + 5] = (byte)(value >> 16);
            byteArray[offset + 6] = (byte)(value >> 8);
            byteArray[offset + 7] = (byte)value;
        } else {
            byteArray[offset + 7] = (byte)(value >> 56);
            byteArray[offset + 6] = (byte)(value >> 48);
            byteArray[offset + 5] = (byte)(value >> 40);
            byteArray[offset + 4] = (byte)(value >> 32);
            byteArray[offset + 3] = (byte)(value >> 24);
            byteArray[offset + 2] = (byte)(value >> 16);
            byteArray[offset + 1] = (byte)(value >> 8);
            byteArray[offset] = (byte)value;
        }
    }

    public static void writeLong(long value, byte[] byteArray, int offset, boolean bigEndian, int numBytes) {
        if (offset + numBytes > byteArray.length && numBytes > 0 && numBytes <= 8) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. writeLong is trying to access byteArray[" + offset + "] to byteArray[" + (offset + numBytes - 1) + "] but valid indices are from 0 to " + (byteArray.length - 1) + ".");
        }
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Access index must be positive or zero.");
        }
        if (numBytes < 0 || numBytes > 8) {
            throw new IllegalArgumentException("numBytes == " + numBytes);
        }
        if (bigEndian) {
            ByteArrayMarshaller.writeLong_(value, byteArray, offset, true, numBytes);
        } else {
            ByteArrayMarshaller.writeLong_(value, byteArray, offset, false, numBytes);
        }
    }

    private static void writeLong_(long value, byte[] byteArray, int offset, boolean bigEndian, int numBytes) {
        int i = offset;
        switch (numBytes) {
            case 0: {
                break;
            }
            case 1: {
                byteArray[i] = (byte)value;
                break;
            }
            case 2: {
                if (bigEndian) {
                    byteArray[i] = (byte)(value >> 8);
                    byteArray[i + 1] = (byte)value;
                    break;
                }
                byteArray[i + 1] = (byte)(value >> 8);
                byteArray[i] = (byte)value;
                break;
            }
            case 3: {
                if (bigEndian) {
                    byteArray[i] = (byte)(value >> 16);
                    byteArray[i + 1] = (byte)(value >> 8);
                    byteArray[i + 2] = (byte)value;
                    break;
                }
                byteArray[i + 2] = (byte)(value >> 16);
                byteArray[i + 1] = (byte)(value >> 8);
                byteArray[i] = (byte)value;
                break;
            }
            case 4: {
                if (bigEndian) {
                    byteArray[i] = (byte)(value >> 24);
                    byteArray[i + 1] = (byte)(value >> 16);
                    byteArray[i + 2] = (byte)(value >> 8);
                    byteArray[i + 3] = (byte)value;
                    break;
                }
                byteArray[i + 3] = (byte)(value >> 24);
                byteArray[i + 2] = (byte)(value >> 16);
                byteArray[i + 1] = (byte)(value >> 8);
                byteArray[i] = (byte)value;
                break;
            }
            case 5: {
                if (bigEndian) {
                    byteArray[i] = (byte)(value >> 32);
                    byteArray[i + 1] = (byte)(value >> 24);
                    byteArray[i + 2] = (byte)(value >> 16);
                    byteArray[i + 3] = (byte)(value >> 8);
                    byteArray[i + 4] = (byte)value;
                    break;
                }
                byteArray[i + 4] = (byte)(value >> 32);
                byteArray[i + 3] = (byte)(value >> 24);
                byteArray[i + 2] = (byte)(value >> 16);
                byteArray[i + 1] = (byte)(value >> 8);
                byteArray[i] = (byte)value;
                break;
            }
            case 6: {
                if (bigEndian) {
                    byteArray[i] = (byte)(value >> 40);
                    byteArray[i + 1] = (byte)(value >> 32);
                    byteArray[i + 2] = (byte)(value >> 24);
                    byteArray[i + 3] = (byte)(value >> 16);
                    byteArray[i + 4] = (byte)(value >> 8);
                    byteArray[i + 5] = (byte)value;
                    break;
                }
                byteArray[i + 5] = (byte)(value >> 40);
                byteArray[i + 4] = (byte)(value >> 32);
                byteArray[i + 3] = (byte)(value >> 24);
                byteArray[i + 2] = (byte)(value >> 16);
                byteArray[i + 1] = (byte)(value >> 8);
                byteArray[i] = (byte)value;
                break;
            }
            case 7: {
                if (bigEndian) {
                    byteArray[i] = (byte)(value >> 48);
                    byteArray[i + 1] = (byte)(value >> 40);
                    byteArray[i + 2] = (byte)(value >> 32);
                    byteArray[i + 3] = (byte)(value >> 24);
                    byteArray[i + 4] = (byte)(value >> 16);
                    byteArray[i + 5] = (byte)(value >> 8);
                    byteArray[i + 6] = (byte)value;
                    break;
                }
                byteArray[i + 6] = (byte)(value >> 48);
                byteArray[i + 5] = (byte)(value >> 40);
                byteArray[i + 4] = (byte)(value >> 32);
                byteArray[i + 3] = (byte)(value >> 24);
                byteArray[i + 2] = (byte)(value >> 16);
                byteArray[i + 1] = (byte)(value >> 8);
                byteArray[i] = (byte)value;
                break;
            }
            case 8: {
                if (bigEndian) {
                    byteArray[i] = (byte)(value >> 56);
                    byteArray[i + 1] = (byte)(value >> 48);
                    byteArray[i + 2] = (byte)(value >> 40);
                    byteArray[i + 3] = (byte)(value >> 32);
                    byteArray[i + 4] = (byte)(value >> 24);
                    byteArray[i + 5] = (byte)(value >> 16);
                    byteArray[i + 6] = (byte)(value >> 8);
                    byteArray[i + 7] = (byte)value;
                    break;
                }
                byteArray[i + 7] = (byte)(value >> 56);
                byteArray[i + 6] = (byte)(value >> 48);
                byteArray[i + 5] = (byte)(value >> 40);
                byteArray[i + 4] = (byte)(value >> 32);
                byteArray[i + 3] = (byte)(value >> 24);
                byteArray[i + 2] = (byte)(value >> 16);
                byteArray[i + 1] = (byte)(value >> 8);
                byteArray[i] = (byte)value;
            }
        }
    }

    public static void writeFloat(float value, byte[] byteArray, int offset, boolean bigEndian) {
        if (offset + 4 > byteArray.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. writeFloat is trying to access byteArray[" + offset + "] to byteArray[" + (offset + 3) + "],  but valid indices are from 0 to " + (byteArray.length - 1) + ".");
        }
        if (bigEndian) {
            ByteArrayMarshaller.writeFloat_(value, byteArray, offset, true);
        } else {
            ByteArrayMarshaller.writeFloat_(value, byteArray, offset, false);
        }
    }

    private static void writeFloat_(float value, byte[] byteArray, int offset, boolean bigEndian) {
        ByteArrayMarshaller.writeInt(Float.floatToIntBits(value), byteArray, offset, bigEndian);
    }

    public static void writeDouble(double value, byte[] byteArray, int offset, boolean bigEndian) {
        if (offset + 8 > byteArray.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. writeDouble is trying to access byteArray[" + offset + "] to byteArray[" + (offset + 7) + "],  but valid indices are from 0 to " + (byteArray.length - 1) + ".");
        }
        if (bigEndian) {
            ByteArrayMarshaller.writeDouble_(value, byteArray, offset, true);
        } else {
            ByteArrayMarshaller.writeDouble_(value, byteArray, offset, false);
        }
    }

    private static void writeDouble_(double value, byte[] byteArray, int offset, boolean bigEndian) {
        ByteArrayMarshaller.writeLong(Double.doubleToLongBits(value), byteArray, offset, bigEndian);
    }
}

