/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.crmf;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.POPOPrivKey;
import com.ibm.security.crmf.POPOSigningKey;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;

public final class ProofOfPossession
extends CMPDerObject {
    private Object pop;
    private int choice;
    private static final byte TAG_RA_VERIFIED = 0;
    private static final byte TAG_SIGNATURE = 1;
    private static final byte TAG_KEY_ENCIPHERMENT = 2;
    private static final byte TAG_KEY_AGREEMENT = 3;
    public static final int RA_VERIFIED = 0;
    public static final int SIGNATURE = 1;
    public static final int KEY_ENCIPHERMENT = 2;
    public static final int KEY_AGREEMENT = 3;

    public ProofOfPossession(int n, Object object) {
        switch (n) {
            case 0: {
                this.choice = 0;
                this.pop = null;
                break;
            }
            case 1: {
                this.choice = 1;
                if (object == null) {
                    throw new IllegalArgumentException("ProofOfPossession error, object not specified");
                }
                if (object instanceof POPOSigningKey) {
                    this.pop = object;
                    break;
                }
                throw new IllegalArgumentException("ProofOfPossession error, invalid signature object");
            }
            case 2: {
                this.choice = 2;
                if (object == null) {
                    throw new IllegalArgumentException("ProofOfPossession error, object not specified");
                }
                if (object instanceof POPOPrivKey) {
                    this.pop = object;
                    break;
                }
                throw new IllegalArgumentException("ProofOfPossession error, invalid encipherment object");
            }
            case 3: {
                throw new IllegalArgumentException("ProofOfPossesion type not supported for this version");
            }
            default: {
                throw new IllegalArgumentException("Invalid type");
            }
        }
    }

    public ProofOfPossession(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            return new ProofOfPossession(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        this.pop = null;
        DerValue derValue2 = null;
        if (derValue.isContextSpecific((byte)0) && !derValue.isConstructed()) {
            derValue.resetTag((byte)5);
            try {
                DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
                derInputStream.getNull();
            }
            catch (IOException iOException) {
                throw new IOException("ProofOfPossession parsing error, not a null value " + iOException);
            }
            this.choice = 0;
            this.pop = null;
        } else if (derValue.isContextSpecific((byte)1) && derValue.isConstructed()) {
            derValue.resetTag((byte)48);
            this.choice = 1;
            this.pop = new POPOSigningKey(derValue.toByteArray());
        } else if (derValue.isContextSpecific((byte)2) && derValue.isConstructed()) {
            derValue2 = derValue.getData().getDerValue();
            this.choice = 2;
            this.pop = new POPOPrivKey(derValue2.toByteArray());
        } else if (derValue.isContextSpecific((byte)3) && derValue.isConstructed()) {
            derValue2 = derValue.getData().getDerValue();
            this.choice = 3;
            this.pop = new POPOPrivKey(derValue2.toByteArray());
        } else {
            throw new IOException("ProofOfPossession parsing error, invalid tag");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        switch (this.choice) {
            case 0: {
                derOutputStream.putNull();
                derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, (boolean)false, (byte)0), derOutputStream);
                break;
            }
            case 1: {
                if (this.pop == null) {
                    throw new IOException("ProofOfPossession encoding error, signature object not specified");
                }
                ((POPOSigningKey)this.pop).encode((OutputStream)derOutputStream);
                derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream);
                break;
            }
            case 2: {
                if (this.pop == null) {
                    throw new IOException("ProofOfPossession encoding error, key encipherment object not specified");
                }
                ((POPOPrivKey)this.pop).encode((OutputStream)derOutputStream);
                derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), derOutputStream);
                break;
            }
            case 3: {
                if (this.pop == null) {
                    throw new IOException("ProofOfPossession encoding error, key agreement object not specified");
                }
                ((POPOPrivKey)this.pop).encode((OutputStream)derOutputStream);
                derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), derOutputStream);
                break;
            }
            default: {
                throw new IOException("ProofOfPossession encoding error, invalid type");
            }
        }
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(ProofOfPossession proofOfPossession) {
        DerValue derValue;
        DerValue derValue2;
        if (proofOfPossession == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            proofOfPossession.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof ProofOfPossession) {
            return this.equals((ProofOfPossession)object);
        }
        return false;
    }

    public Object getPOP() throws IOException {
        DerOutputStream derOutputStream = null;
        switch (this.choice) {
            case 0: {
                return null;
            }
            case 1: {
                derOutputStream = new DerOutputStream();
                ((POPOSigningKey)this.pop).encode((OutputStream)derOutputStream);
                return new POPOSigningKey(derOutputStream.toByteArray());
            }
            case 2: {
                derOutputStream = new DerOutputStream();
                ((POPOPrivKey)this.pop).encode((OutputStream)derOutputStream);
                return new POPOPrivKey(derOutputStream.toByteArray());
            }
            case 3: {
                return (POPOPrivKey)((POPOPrivKey)this.pop).clone();
            }
        }
        return null;
    }

    public int getPOPType() {
        return this.choice;
    }

    public String toString() {
        String string = "ProofOfPossession:";
        if (this.choice == 0) {
            string = String.valueOf(string) + "\r\n\tRA verified";
        } else if (this.choice == 1) {
            string = String.valueOf(string) + "\r\n\tsignature: " + this.pop;
        } else if (this.choice == 2) {
            string = String.valueOf(string) + "\r\n\tkey encipherment " + this.pop;
        } else if (this.choice == 3) {
            string = String.valueOf(string) + "\r\n\tkey agreement " + this.pop;
        }
        return string;
    }
}

