/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.JCAUtil;
import com.ibm.crypto.provider.PSSParameters;
import com.ibm.crypto.provider.RSACore;
import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.crypto.provider.RSAPadding;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Arrays;
import java.util.Hashtable;
import javax.crypto.BadPaddingException;

public class RSAPSSSignature
extends SignatureSpi {
    protected SecureRandom a;
    private static final Hashtable<String, Integer> b;
    double c = 0.0;
    private int d;
    private double e;
    private MessageDigest f;
    private MessageDigest g;
    private boolean h = true;
    private RSAPadding i;
    private RSAPrivateKey j;
    private RSAPublicKey k;
    PSSParameterSpec l = null;
    private static final String[] z;

    RSAPSSSignature(PSSParameterSpec pSSParameterSpec) {
        try {
            this.engineSetParameter(pSSParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new ProviderException(invalidAlgorithmParameterException);
        }
    }

    public RSAPSSSignature() {
        this(new PSSParameterSpec(z[2], z[3], MGF1ParameterSpec.SHA1, 20, 1));
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        RSAPublicKey rSAPublicKey = (RSAPublicKey)RSAKeyFactory.toRSAKey(publicKey);
        this.j = null;
        this.b(rSAPublicKey);
        this.k = rSAPublicKey;
        this.a = JCAUtil.getSecureRandom();
        this.c = rSAPublicKey.getModulus().bitLength();
        this.e = this.c - 1.0;
        this.d = (int)Math.ceil(this.e / 8.0);
        this.a(rSAPublicKey, this.a);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.a = JCAUtil.getSecureRandom();
        this.engineInitSign(privateKey, this.a);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)RSAKeyFactory.toRSAKey(privateKey);
        this.c = rSAPrivateKey.getModulus().bitLength();
        this.e = this.c - 1.0;
        this.d = (int)Math.ceil(this.e / 8.0);
        this.b(rSAPrivateKey);
        this.j = rSAPrivateKey;
        this.k = null;
        this.a(rSAPrivateKey, this.a);
    }

    private void a(RSAKey rSAKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.a = secureRandom == null ? JCAUtil.getSecureRandom() : secureRandom;
        int n2 = RSACore.getByteLength(rSAKey);
        try {
            this.i = RSAPadding.getInstance(5, n2, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
        this.a();
    }

    private void a() {
        if (!this.h) {
            this.f.reset();
            this.h = true;
        }
    }

    private byte[] b() {
        this.h = true;
        return this.f.digest();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.d();
        this.f.update(by);
        this.h = false;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.d();
        this.f.update(byArray, n2, n3);
        this.h = false;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        try {
            this.d();
        }
        catch (SignatureException signatureException) {
            throw new RuntimeException(signatureException.getMessage());
        }
        this.f.update(byteBuffer);
        this.h = false;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = this.b();
        try {
            byte[] byArray2 = this.encodeSignature(byArray);
            byte[] byArray3 = RSACore.rsa(byArray2, this.j);
            int n2 = ((int)this.c + 7) / 8;
            return byArray3;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SignatureException(z[17], generalSecurityException);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (byArray.length != RSACore.getByteLength(this.k)) {
            throw new SignatureException(z[62] + byArray.length + z[60] + RSACore.getByteLength(this.k));
        }
        int n2 = ((int)this.c + 7) / 8;
        if (byArray.length != n2) {
            throw new SignatureException(z[61] + byArray.length + z[64] + RSACore.getByteLength(this.k));
        }
        byte[] byArray2 = this.b();
        try {
            byte[] byArray3 = RSACore.rsa(byArray, this.k);
            byte[] byArray4 = this.i.unpad(byArray3);
            if (byArray4.length > this.d) {
                return false;
            }
            if (byArray4.length < this.d) {
                byte[] byArray5 = new byte[this.d];
                System.arraycopy(byArray4, 0, byArray5, this.d - byArray4.length, byArray4.length);
                byArray4 = byArray5;
            }
            boolean bl2 = this.decodeSignature(byArray4, byArray2);
            return bl2;
        }
        catch (BadPaddingException badPaddingException) {
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            return false;
        }
        catch (IOException iOException) {
            throw new SignatureException(z[63], iOException);
        }
    }

    public byte[] encodeSignature(byte[] byArray) throws InvalidKeyException, InvalidAlgorithmParameterException, BadPaddingException {
        int n2;
        if (this.d < byArray.length + this.l.getSaltLength() + 2) {
            throw new SecurityException(z[0]);
        }
        byte[] byArray2 = new byte[this.l.getSaltLength()];
        this.a.nextBytes(byArray2);
        byte[] byArray3 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] byArray4 = new byte[8 + byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray4, byArray3.length, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, byArray3.length + byArray.length, byArray2.length);
        this.h = false;
        this.f.reset();
        this.f.update(byArray4);
        byte[] byArray5 = this.f.digest();
        this.h = true;
        int n3 = this.d - byArray5.length - byArray2.length - 2;
        byte[] byArray6 = new byte[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            byArray6[n2] = 0;
        }
        byte[] byArray7 = new byte[this.d - byArray5.length - 1];
        if (n3 > 0) {
            System.arraycopy(byArray6, 0, byArray7, 0, byArray6.length);
        }
        byArray7[n2++] = 1;
        System.arraycopy(byArray2, 0, byArray7, n2, byArray2.length);
        byte[] byArray8 = new byte[n3 + 1 + byArray2.length];
        byArray8 = this.a(byArray5, byArray8.length);
        byte[] byArray9 = new byte[n3 + 1 + byArray2.length];
        int n4 = 0;
        for (byte by : byArray8) {
            byArray9[n4] = (byte)(by ^ byArray7[n4++]);
        }
        int n5 = 8 * this.d - (int)this.e;
        if (n5 > 0) {
            int n6 = (byte)(255 >>> n5);
            byArray9[0] = (byte)(byArray9[0] & n6);
        }
        byte[] byArray10 = new byte[this.d];
        System.arraycopy(byArray9, 0, byArray10, 0, byArray9.length);
        System.arraycopy(byArray5, 0, byArray10, byArray9.length, byArray5.length);
        byArray10[byArray9.length + byArray5.length] = -68;
        return byArray10;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean decodeSignature(byte[] byArray, byte[] byArray2) throws IOException, SignatureException, InvalidKeyException, InvalidAlgorithmParameterException, BadPaddingException {
        int n2;
        byte by2;
        if (this.d < byArray2.length + 2 + this.l.getSaltLength()) {
            return false;
        }
        byte by = byArray[this.d - 1];
        if ((by ^ 0xBC) == 0) {
            return false;
        }
        byte[] byArray5 = Arrays.copyOfRange(byArray, 0, this.d - byArray2.length - 1);
        byte[] byArray4 = Arrays.copyOfRange(byArray, byArray5.length, this.d - 1);
        int n3 = 8 * this.d - (int)this.e;
        int n4 = 8 - n3;
        if (n4 > 0 && (byArray5[0] & (by2 = (byte)(255 << n4))) != 0) {
            return false;
        }
        byte[] byArray6 = new byte[this.d - byArray4.length - 1];
        byArray6 = this.a(byArray4, byArray6.length);
        byte[] byArray3 = new byte[byArray6.length];
        int n5 = 0;
        byte[] byArray7 = byArray6;
        int n6 = byArray7.length;
        for (int i2 = 0; i2 < n6; ++n5, ++i2) {
            byte by3 = byArray7[i2];
            byArray3[n5] = (byte)(by3 ^ byArray5[n5]);
        }
        n3 = 8 * this.d - (int)this.e;
        if (n3 > 0) {
            byte by4 = (byte)(255 >>> n3);
            byArray3[0] = (byte)(byArray3[0] & by4);
        }
        if ((n2 = this.d - byArray4.length - this.l.getSaltLength() - 2) > 0) {
            for (n6 = 0; n6 < n2; ++n6) {
                if (byArray3[n6] == 0) continue;
                return false;
            }
        }
        if (byArray3[n2] != 1) {
            return false;
        }
        byte[] byArray72 = Arrays.copyOfRange(byArray3, n2 + 1, byArray3.length);
        byte[] byArray8 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] byArray9 = new byte[8 + byArray2.length + byArray72.length];
        System.arraycopy(byArray8, 0, byArray9, 0, byArray8.length);
        System.arraycopy(byArray2, 0, byArray9, byArray8.length, byArray2.length);
        System.arraycopy(byArray72, 0, byArray9, byArray8.length + byArray2.length, byArray72.length);
        this.h = false;
        this.f.reset();
        this.f.update(byArray9);
        byte[] byArray10 = this.f.digest();
        this.h = true;
        return MessageDigest.isEqual(byArray4, byArray10);
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException(z[16]);
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException(z[21]);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        block71: {
            boolean bl2;
            block75: {
                block89: {
                    String string;
                    String string2;
                    block87: {
                        block88: {
                            block85: {
                                block86: {
                                    block84: {
                                        block82: {
                                            block83: {
                                                block81: {
                                                    block79: {
                                                        block80: {
                                                            block78: {
                                                                block76: {
                                                                    block77: {
                                                                        block73: {
                                                                            block74: {
                                                                                block72: {
                                                                                    this.l = this.a(algorithmParameterSpec);
                                                                                    if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
                                                                                        throw new InvalidAlgorithmParameterException();
                                                                                    }
                                                                                    if (!this.h) {
                                                                                        throw new ProviderException(z[28]);
                                                                                    }
                                                                                    this.l = (PSSParameterSpec)algorithmParameterSpec;
                                                                                    string2 = this.l.getDigestAlgorithm();
                                                                                    AlgorithmParameterSpec algorithmParameterSpec2 = this.l.getMGFParameters();
                                                                                    if (string2 == null || algorithmParameterSpec2 == null) break block71;
                                                                                    if (!(algorithmParameterSpec2 instanceof MGF1ParameterSpec)) break block71;
                                                                                    string = ((MGF1ParameterSpec)algorithmParameterSpec2).getDigestAlgorithm();
                                                                                    if (string == null) break block71;
                                                                                    bl2 = true;
                                                                                    if (string2.equalsIgnoreCase(z[46]) || string2.equalsIgnoreCase(z[39])) break block72;
                                                                                    if (!string2.equalsIgnoreCase(z[55])) break block73;
                                                                                }
                                                                                if (string.equalsIgnoreCase(z[36])) break block74;
                                                                                if (string.equalsIgnoreCase(z[33])) break block74;
                                                                                if (!string.equalsIgnoreCase(z[34])) break block75;
                                                                            }
                                                                            bl2 = false;
                                                                            break block75;
                                                                        }
                                                                        if (!string2.equalsIgnoreCase(z[40]) && !string2.equalsIgnoreCase(z[23])) break block76;
                                                                        if (string.equalsIgnoreCase(z[42])) break block77;
                                                                        if (!string.equalsIgnoreCase(z[56])) break block75;
                                                                    }
                                                                    bl2 = false;
                                                                    break block75;
                                                                }
                                                                if (string2.equalsIgnoreCase(z[53]) || string2.equalsIgnoreCase(z[30])) break block78;
                                                                if (!string2.equalsIgnoreCase(z[37])) break block79;
                                                            }
                                                            if (string.equalsIgnoreCase(z[29])) break block80;
                                                            if (string.equalsIgnoreCase(z[31])) break block80;
                                                            if (!string.equalsIgnoreCase(z[54])) break block75;
                                                        }
                                                        bl2 = false;
                                                        break block75;
                                                    }
                                                    if (string2.equalsIgnoreCase(z[50]) || string2.equalsIgnoreCase(z[49])) break block81;
                                                    if (!string2.equalsIgnoreCase(z[51])) break block82;
                                                }
                                                if (string.equalsIgnoreCase(z[24])) break block83;
                                                if (string.equalsIgnoreCase(z[27])) break block83;
                                                if (!string.equalsIgnoreCase(z[58])) break block75;
                                            }
                                            bl2 = false;
                                            break block75;
                                        }
                                        if (string2.equalsIgnoreCase(z[57]) || string2.equalsIgnoreCase(z[47])) break block84;
                                        if (!string2.equalsIgnoreCase(z[52])) break block85;
                                    }
                                    if (string.equalsIgnoreCase(z[22])) break block86;
                                    if (string.equalsIgnoreCase(z[59])) break block86;
                                    if (!string.equalsIgnoreCase(z[38])) break block75;
                                }
                                bl2 = false;
                                break block75;
                            }
                            if (!string2.equalsIgnoreCase(z[45]) && !string2.equalsIgnoreCase(z[41])) break block87;
                            if (string.equalsIgnoreCase(z[48])) break block88;
                            if (!string.equalsIgnoreCase(z[32])) break block75;
                        }
                        bl2 = false;
                        break block75;
                    }
                    if (!string2.equalsIgnoreCase(z[25]) && !string2.equalsIgnoreCase(z[26])) break block75;
                    if (string.equalsIgnoreCase(z[43])) break block89;
                    if (!string.equalsIgnoreCase(z[44])) break block75;
                }
                bl2 = false;
            }
            if (bl2) {
                InvalidAlgorithmParameterException invalidAlgorithmParameterException = new InvalidAlgorithmParameterException(z[35]);
                throw invalidAlgorithmParameterException;
            }
        }
        try {
            this.f = MessageDigest.getInstance(this.l.getDigestAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidAlgorithmParameterException(noSuchAlgorithmException);
        }
        this.h = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(byte[] byArray, int n2) throws InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException {
        String string = this.l.getDigestAlgorithm();
        String string2 = this.l.getMGFAlgorithm();
        if (!string2.equalsIgnoreCase(z[13])) {
            throw new InvalidAlgorithmParameterException(z[10] + string2);
        }
        String string3 = null;
        string3 = this.l.getMGFParameters() == null ? string : ((MGF1ParameterSpec)this.l.getMGFParameters()).getDigestAlgorithm();
        try {
            this.g = MessageDigest.getInstance(string3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException(z[12] + string + z[11], noSuchAlgorithmException);
        }
        byte[] byArray2 = new byte[n2];
        int n3 = this.g.getDigestLength();
        int n4 = n2 / n3;
        if (n2 % n3 > 0) {
            ++n4;
        }
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = new byte[n3];
        int n5 = 0;
        while (n5 < n4) {
            byArray3[0] = (byte)(n5 >>> 24);
            byArray3[1] = (byte)(n5 >>> 16);
            byArray3[2] = (byte)(n5 >>> 8);
            byArray3[3] = (byte)n5;
            this.g.update(byArray, 0, byArray.length);
            this.g.update(byArray3);
            try {
                this.g.digest(byArray4, 0, byArray4.length);
            }
            catch (DigestException digestException) {
                throw new BadPaddingException(digestException.toString());
            }
            for (int i2 = 0; i2 < byArray4.length && n5 * n3 + i2 < n2; ++i2) {
                byArray2[n5 * n3 + i2] = byArray4[i2];
            }
            ++n5;
        }
        return byArray2;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() throws InvalidParameterException {
        AlgorithmParameters algorithmParameters = null;
        if (this.l != null) {
            try {
                algorithmParameters = AlgorithmParameters.getInstance(z[18], z[20]);
                algorithmParameters.init(this.l);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new RuntimeException(z[19]);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new ProviderException(generalSecurityException.getMessage());
            }
        }
        if (this.l == null) {
            return null;
        }
        return algorithmParameters;
    }

    String a(byte[] byArray) {
        String string = z[1];
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            stringBuffer.append(string.charAt(n2 >> 4));
            stringBuffer.append(string.charAt(n2 & 0xF));
        }
        return stringBuffer.toString();
    }

    private static void a(RSAKey rSAKey, int n2, int n3) throws SignatureException {
        if (rSAKey != null) {
            int n4 = RSAPSSSignature.a(rSAKey) >> 3;
            int n5 = Math.addExact(Math.addExact(n2, n3), 2);
            if (n4 < n5) {
                throw new SignatureException(z[9] + n5);
            }
        }
    }

    private static int a(RSAKey rSAKey) {
        if (rSAKey != null) {
            return rSAKey.getModulus().bitLength();
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean a(String string, String string2) {
        if (string == null) return false;
        if (string2 == null) {
            return false;
        }
        if (string2.indexOf("-") != -1) {
            return string.equalsIgnoreCase(string2);
        }
        if (!string.equals(z[6])) {
            StringBuilder stringBuilder = new StringBuilder(string2);
            if (!string2.regionMatches(true, 0, z[5], 0, 3)) throw new ProviderException(z[8] + string2);
            string2 = stringBuilder.insert(3, "-").toString();
            return string.equalsIgnoreCase(string2);
        }
        if (string2.equalsIgnoreCase(z[4])) return true;
        if (string2.equalsIgnoreCase(z[7])) return true;
        return false;
    }

    private static boolean a(AlgorithmParameterSpec algorithmParameterSpec, PSSParameterSpec pSSParameterSpec) {
        if (algorithmParameterSpec == null) {
            return true;
        }
        if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
            return false;
        }
        if (pSSParameterSpec == null) {
            return true;
        }
        PSSParameterSpec pSSParameterSpec2 = (PSSParameterSpec)algorithmParameterSpec;
        if (pSSParameterSpec2.getSaltLength() > pSSParameterSpec.getSaltLength()) {
            return false;
        }
        PSSParameterSpec pSSParameterSpec3 = new PSSParameterSpec(pSSParameterSpec2.getDigestAlgorithm(), pSSParameterSpec2.getMGFAlgorithm(), pSSParameterSpec2.getMGFParameters(), pSSParameterSpec.getSaltLength(), pSSParameterSpec2.getTrailerField());
        PSSParameters pSSParameters = new PSSParameters();
        try {
            pSSParameters.engineInit(pSSParameterSpec3);
            byte[] byArray = pSSParameters.engineGetEncoded();
            pSSParameters.engineInit(pSSParameterSpec);
            byte[] byArray2 = pSSParameters.engineGetEncoded();
            return Arrays.equals(byArray, byArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private void b(RSAKey rSAKey) throws InvalidKeyException {
        try {
            AlgorithmParameterSpec algorithmParameterSpec = rSAKey.getParams();
            if (!RSAPSSSignature.a(rSAKey.getParams(), this.l)) {
                throw new InvalidKeyException(z[14]);
            }
            if (this.l != null) {
                Integer n2 = b.get(this.l.getDigestAlgorithm());
                if (n2 == null) {
                    throw new ProviderException(z[15] + this.l.getDigestAlgorithm());
                }
                RSAPSSSignature.a(rSAKey, n2, this.l.getSaltLength());
            }
            return;
        }
        catch (SignatureException signatureException) {
            throw new InvalidKeyException(signatureException);
        }
    }

    private PSSParameterSpec a(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        Key key;
        PSSParameterSpec pSSParameterSpec;
        block24: {
            if (algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException(z[68]);
            }
            if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
                throw new InvalidAlgorithmParameterException(z[65]);
            }
            pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
            if (pSSParameterSpec == this.l) {
                return pSSParameterSpec;
            }
            Key key2 = this.j == null ? this.k : this.j;
            key = key2;
            if (key == null || RSAPSSSignature.a(key.getParams(), pSSParameterSpec)) break block24;
            throw new InvalidAlgorithmParameterException(z[66]);
        }
        if (!pSSParameterSpec.getMGFAlgorithm().equalsIgnoreCase(z[67])) {
            throw new InvalidAlgorithmParameterException(z[70]);
        }
        if (pSSParameterSpec.getTrailerField() != 1) {
            throw new InvalidAlgorithmParameterException(z[69]);
        }
        String string = pSSParameterSpec.getDigestAlgorithm();
        if (key != null) {
            try {
                int n2 = b.get(string);
                RSAPSSSignature.a((RSAKey)((Object)key), n2, pSSParameterSpec.getSaltLength());
            }
            catch (SignatureException signatureException) {
                throw new InvalidAlgorithmParameterException(signatureException);
            }
        }
        return pSSParameterSpec;
    }

    private void d() throws SignatureException {
        Key key = this.j == null ? this.k : this.j;
        Key key2 = key;
        if (key2 == null) {
            throw new SignatureException(z[71]);
        }
        if (this.l == null) {
            throw new SignatureException(z[72]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String string2;
        int n2;
        String[] stringArray = new String[73];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n3 = 0;
        String string3 = "\u000b]=%y\u0007]9jx\u001cA18";
        int n4 = -1;
        block103: while (true) {
            char[] cArray;
            block110: {
                int n5;
                block109: {
                    char[] cArray2 = string3.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n2 = 0;
                    if (!true) break block109;
                    n5 = n5;
                    if (n5 <= n2) break block110;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n2;
                    char c2 = cArray[n7];
                    switch (n2 % 5) {
                        case 0: {
                            n6 = 110;
                            break;
                        }
                        case 1: {
                            n6 = 51;
                            break;
                        }
                        case 2: {
                            n6 = 94;
                            break;
                        }
                        case 3: {
                            n6 = 74;
                            break;
                        }
                        default: {
                            n6 = 29;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n2;
                    n5 = n5;
                } while (n5 > n2);
            }
            string2 = new String(cArray);
            switch (n4) {
                default: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 1;
                    string3 = "^\u0002ly)[\u0005ir$\u000fQ=.x\b";
                    n4 = 0;
                    continue block103;
                }
                case 0: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 2;
                    string3 = "={\u001fg,";
                    n4 = 1;
                    continue block103;
                }
                case 1: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 3;
                    string3 = "#t\u0018{";
                    n4 = 2;
                    continue block103;
                }
                case 2: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 4;
                    string3 = "={\u001f";
                    n4 = 3;
                    continue block103;
                }
                case 3: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 5;
                    string3 = "={\u001f";
                    n4 = 4;
                    continue block103;
                }
                case 4: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 6;
                    string3 = "={\u001fg,";
                    n4 = 5;
                    continue block103;
                }
                case 5: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 7;
                    string3 = "={\u001f{";
                    n4 = 6;
                    continue block103;
                }
                case 6: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 8;
                    string3 = ";]-?m\u001e\\,>x\n\u0013:#z\u000b@*j|\u0002T18t\u001a[3j";
                    n4 = 7;
                    continue block103;
                }
                case 7: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 9;
                    string3 = "%V'jt\u001d\u0013*%rN@6%o\u001a\u001f~$x\u000bW~'t\u0000\u0013";
                    n4 = 8;
                    continue block103;
                }
                case 8: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 10;
                    string3 = ";]-?m\u001e\\,>x\n\u0013\u0013\r[NR2-rT\u0013";
                    n4 = 9;
                    continue block103;
                }
                case 9: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 11;
                    string3 = "N]1>=\u000fE?#q\u000fQ2/";
                    n4 = 10;
                    continue block103;
                }
                case 10: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 12;
                    string3 = "*Z9/n\u001a\u0013";
                    n4 = 11;
                    continue block103;
                }
                case 11: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 13;
                    string3 = "#t\u0018{";
                    n4 = 12;
                    continue block103;
                }
                case 12: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 14;
                    string3 = "%V'j~\u0001]*+t\u0000@~#s\r\\3:|\u001aZ<&xNc\r\u0019=\u001eR,+p\u000bG;8=\u0018R2?x\u001d";
                    n4 = 13;
                    continue block103;
                }
                case 13: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 15;
                    string3 = ";]-?m\u001e\\,>x\n\u0013:#z\u000b@*j|\u0002T1p=";
                    n4 = 14;
                    continue block103;
                }
                case 14: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 16;
                    string3 = "\u001dV*\u001a|\u001cR3/i\u000bAvc=\u0000\\*jn\u001bC.%o\u001aV:";
                    n4 = 15;
                    continue block103;
                }
                case 15: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 17;
                    string3 = "-\\+&yN]1>=\u001dZ9$=\nR*+";
                    n4 = 16;
                    continue block103;
                }
                case 16: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 18;
                    string3 = "<`\u001f\u001aN=";
                    n4 = 17;
                    continue block103;
                }
                case 17: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 19;
                    string3 = "'q\u0013\u0000^+\u0013=+q\u0002V:f=\fF*js\u0001G~)r\u0000U7-h\u001cV:";
                    n4 = 18;
                    continue block103;
                }
                case 18: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 20;
                    string3 = "'q\u0013\u0000^+";
                    n4 = 19;
                    continue block103;
                }
                case 19: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 21;
                    string3 = "\tV*\u001a|\u001cR3/i\u000bAvc=\u0000\\*jn\u001bC.%o\u001aV:";
                    n4 = 20;
                    continue block103;
                }
                case 20: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 22;
                    string3 = "={\u001f\u007f,\\";
                    n4 = 21;
                    continue block103;
                }
                case 21: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 23;
                    string3 = "={\u001fg/\\\u0007";
                    n4 = 22;
                    continue block103;
                }
                case 22: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 24;
                    string3 = "={\u001fy%Z";
                    n4 = 23;
                    continue block103;
                }
                case 23: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 25;
                    string3 = "={\u001f\u007f,\\\u001cl\u007f+";
                    n4 = 24;
                    continue block103;
                }
                case 24: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 26;
                    string3 = "={\u001fg(_\u0001qx(X";
                    n4 = 25;
                    continue block103;
                }
                case 25: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 27;
                    string3 = "={\u001fg.V\u0007";
                    n4 = 26;
                    continue block103;
                }
                case 26: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 28;
                    string3 = "-R0$r\u001a\u0013-/iNC?8|\u0003V*/o\u001d\u0013:?o\u0007]9jr\u001eV,+i\u0007\\09";
                    n4 = 27;
                    continue block103;
                }
                case 27: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 29;
                    string3 = "={\u001fx(X";
                    n4 = 28;
                    continue block103;
                }
                case 28: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 30;
                    string3 = "={\u001fg/[\u0005";
                    n4 = 29;
                    continue block103;
                }
                case 29: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 31;
                    string3 = "={\u001fg/[\u0005";
                    n4 = 30;
                    continue block103;
                }
                case 30: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 32;
                    string3 = "={\u001fg(_\u0001qx/Z";
                    n4 = 31;
                    continue block103;
                }
                case 31: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 33;
                    string3 = "={\u001fg,";
                    n4 = 32;
                    continue block103;
                }
                case 32: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 34;
                    string3 = "={\u001f";
                    n4 = 33;
                    continue block103;
                }
                case 33: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 35;
                    string3 = ":[;jp\u000b@-+z\u000b\u0013:#z\u000b@*jj\u0007G6#sNG6/=>`\r\u001a|\u001cR3/i\u000bA\r:x\r\u0013:%x\u001d\u00130%iN^?>~\u0006\u0013*\"xN~\u0019\f=\u0003V-9|\tV~.t\tV->3";
                    n4 = 34;
                    continue block103;
                }
                case 34: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 36;
                    string3 = "={\u001f{";
                    n4 = 35;
                    continue block103;
                }
                case 35: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 37;
                    string3 = "={\u001fx";
                    n4 = 36;
                    continue block103;
                }
                case 36: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 38;
                    string3 = "={\u001f\u007f";
                    n4 = 37;
                    continue block103;
                }
                case 37: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 39;
                    string3 = "={\u001fg,";
                    n4 = 38;
                    continue block103;
                }
                case 38: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 40;
                    string3 = "={\u001fx/Z";
                    n4 = 39;
                    continue block103;
                }
                case 39: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 41;
                    string3 = "={\u001fg(_\u0001qx/Z";
                    n4 = 40;
                    continue block103;
                }
                case 40: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 42;
                    string3 = "={\u001fx/Z";
                    n4 = 41;
                    continue block103;
                }
                case 41: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 43;
                    string3 = "={\u001f\u007f,\\\u001cl\u007f+";
                    n4 = 42;
                    continue block103;
                }
                case 42: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 44;
                    string3 = "={\u001fg(_\u0001qx(X";
                    n4 = 43;
                    continue block103;
                }
                case 43: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 45;
                    string3 = "={\u001f\u007f,\\\u001clx)";
                    n4 = 44;
                    continue block103;
                }
                case 44: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 46;
                    string3 = "={\u001f{";
                    n4 = 45;
                    continue block103;
                }
                case 45: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 47;
                    string3 = "={\u001fg(_\u0001";
                    n4 = 46;
                    continue block103;
                }
                case 46: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 48;
                    string3 = "={\u001f\u007f,\\\u001clx)";
                    n4 = 47;
                    continue block103;
                }
                case 47: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 49;
                    string3 = "={\u001fg.V\u0007";
                    n4 = 48;
                    continue block103;
                }
                case 48: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 50;
                    string3 = "={\u001fy%Z";
                    n4 = 49;
                    continue block103;
                }
                case 49: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 51;
                    string3 = "={\u001fy";
                    n4 = 50;
                    continue block103;
                }
                case 50: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 52;
                    string3 = "={\u001f\u007f";
                    n4 = 51;
                    continue block103;
                }
                case 51: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 53;
                    string3 = "={\u001fx(X";
                    n4 = 52;
                    continue block103;
                }
                case 52: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 54;
                    string3 = "={\u001fx";
                    n4 = 53;
                    continue block103;
                }
                case 53: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 55;
                    string3 = "={\u001f";
                    n4 = 54;
                    continue block103;
                }
                case 54: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 56;
                    string3 = "={\u001fg/\\\u0007";
                    n4 = 55;
                    continue block103;
                }
                case 55: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 57;
                    string3 = "={\u001f\u007f,\\";
                    n4 = 56;
                    continue block103;
                }
                case 56: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 58;
                    string3 = "={\u001fy";
                    n4 = 57;
                    continue block103;
                }
                case 57: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 59;
                    string3 = "={\u001fg(_\u0001";
                    n4 = 58;
                    continue block103;
                }
                case 58: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 60;
                    string3 = "NQ+>=\u0019R-jx\u0016C;)i\u0007]9j";
                    n4 = 59;
                    continue block103;
                }
                case 59: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 61;
                    string3 = "N`7-s\u000fG+8xN_;$z\u001a[~$r\u001a\u0013=%o\u001cV=>'NT1>=";
                    n4 = 60;
                    continue block103;
                }
                case 60: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 62;
                    string3 = "N`7-s\u000fG+8xN_;$z\u001a[~$r\u001a\u0013=%o\u001cV=>'NT1>=";
                    n4 = 61;
                    continue block103;
                }
                case 61: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 63;
                    string3 = "=Z9$|\u001aF,/=\u000b]=%y\u0007]9jx\u001cA18";
                    n4 = 62;
                    continue block103;
                }
                case 62: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 64;
                    string3 = "NQ+>=\u0019R-jx\u0016C;)i\u0007]9j";
                    n4 = 63;
                    continue block103;
                }
                case 63: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 65;
                    string3 = "\u001eR,+p\u000bG;8nN^+9iNQ;ji\u0017C;jM=`\u000e+o\u000f^;>x\u001c`./~";
                    n4 = 64;
                    continue block103;
                }
                case 64: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 66;
                    string3 = "=Z9$|\u001aF,/=\u001eR,+p\u000bG;8nNW1/nN]1>=\u0003R*)uNX;3=\u001eR,+p\u000bG;8n";
                    n4 = 65;
                    continue block103;
                }
                case 65: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 67;
                    string3 = "#t\u0018{";
                    n4 = 66;
                    continue block103;
                }
                case 66: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 68;
                    string3 = ">R,+p\u000bG;8nNP?$s\u0001G~(xN]+&q";
                    n4 = 67;
                    continue block103;
                }
                case 67: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 69;
                    string3 = "!]23=\u001dF.:r\u001cG-jI\u001cR7&x\u001cu7/q\nq\u001db,G";
                    n4 = 68;
                    continue block103;
                }
                case 68: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 70;
                    string3 = "!]23=\u001dF.:r\u001cG-jP)uo";
                    n4 = 69;
                    continue block103;
                }
                case 69: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 71;
                    string3 = "#Z-9t\u0000T~!x\u0017";
                    n4 = 70;
                    continue block103;
                }
                case 70: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 72;
                    string3 = ">R,+p\u000bG;8nNA;;h\u0007A;.=\b\\,jO=r\r\u0019\\Cc\r\u0019=\u001dZ9$|\u001aF,/n";
                    n4 = 71;
                    continue block103;
                }
                case 71: 
            }
            break;
        }
        stringArray2[n3] = string2.intern();
        z = stringArray3;
        Hashtable<String, Integer> hashtable = b = new Hashtable();
        String string4 = "={\u001fg,";
        int n8 = -1;
        block105: while (true) {
            char[] cArray;
            block112: {
                int n9;
                block111: {
                    char[] cArray3 = string4.toCharArray();
                    cArray = cArray3;
                    n9 = cArray3.length;
                    n2 = 0;
                    if (!true) break block111;
                    n9 = n9;
                    if (n9 <= n2) break block112;
                }
                do {
                    int n10;
                    cArray = cArray;
                    int n11 = n2;
                    char c3 = cArray[n11];
                    switch (n2 % 5) {
                        case 0: {
                            n10 = 110;
                            break;
                        }
                        case 1: {
                            n10 = 51;
                            break;
                        }
                        case 2: {
                            n10 = 94;
                            break;
                        }
                        case 3: {
                            n10 = 74;
                            break;
                        }
                        default: {
                            n10 = 29;
                        }
                    }
                    cArray[n11] = (char)(c3 ^ n10);
                    ++n2;
                    n9 = n9;
                } while (n9 > n2);
            }
            string = new String(cArray).intern();
            switch (n8) {
                default: {
                    hashtable.put(string, 20);
                    hashtable = b;
                    string4 = "={\u001f";
                    n8 = 0;
                    continue block105;
                }
                case 0: {
                    hashtable.put(string, 20);
                    hashtable = b;
                    string4 = "={\u001f{";
                    n8 = 1;
                    continue block105;
                }
                case 1: {
                    hashtable.put(string, 20);
                    hashtable = b;
                    string4 = "={\u001fg/\\\u0007";
                    n8 = 2;
                    continue block105;
                }
                case 2: {
                    hashtable.put(string, 28);
                    hashtable = b;
                    string4 = "={\u001fx/Z";
                    n8 = 3;
                    continue block105;
                }
                case 3: {
                    hashtable.put(string, 28);
                    hashtable = b;
                    string4 = "={\u001fg/[\u0005";
                    n8 = 4;
                    continue block105;
                }
                case 4: {
                    hashtable.put(string, 32);
                    hashtable = b;
                    string4 = "={\u001fx(X";
                    n8 = 5;
                    continue block105;
                }
                case 5: {
                    hashtable.put(string, 32);
                    hashtable = b;
                    string4 = "={\u001fg.V\u0007";
                    n8 = 6;
                    continue block105;
                }
                case 6: {
                    hashtable.put(string, 48);
                    hashtable = b;
                    string4 = "={\u001fy%Z";
                    n8 = 7;
                    continue block105;
                }
                case 7: {
                    hashtable.put(string, 48);
                    hashtable = b;
                    string4 = "={\u001fg(_\u0001";
                    n8 = 8;
                    continue block105;
                }
                case 8: {
                    hashtable.put(string, 64);
                    hashtable = b;
                    string4 = "={\u001f\u007f,\\";
                    n8 = 9;
                    continue block105;
                }
                case 9: {
                    hashtable.put(string, 64);
                    hashtable = b;
                    string4 = "#wk";
                    n8 = 10;
                    continue block105;
                }
                case 10: {
                    hashtable.put(string, 16);
                    hashtable = b;
                    string4 = "={\u001fg(_\u0001qx/Z";
                    n8 = 11;
                    continue block105;
                }
                case 11: {
                    hashtable.put(string, 28);
                    hashtable = b;
                    string4 = "={\u001f\u007f,\\\u001clx)";
                    n8 = 12;
                    continue block105;
                }
                case 12: {
                    hashtable.put(string, 28);
                    hashtable = b;
                    string4 = "={\u001fg(_\u0001qx(X";
                    n8 = 13;
                    continue block105;
                }
                case 13: {
                    hashtable.put(string, 32);
                    hashtable = b;
                    string4 = "={\u001f\u007f,\\\u001cl\u007f+";
                    n8 = 14;
                    continue block105;
                }
                case 14: 
            }
            break;
        }
        hashtable.put(string, 32);
    }
}

