/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.RC2ParameterSpec;

public final class RC2Parameters
extends AlgorithmParametersSpi {
    private byte[] a;
    private int b;
    private int c;
    private static final byte[] d;
    private static final String[] z;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        int n2;
        if (!(algorithmParameterSpec instanceof RC2ParameterSpec)) {
            throw new InvalidParameterSpecException(z[8]);
        }
        byte[] byArray = ((RC2ParameterSpec)algorithmParameterSpec).getIV();
        if (byArray != null) {
            if (byArray.length != 8) {
                throw new InvalidParameterSpecException(z[7]);
            }
            this.a = (byte[])byArray.clone();
        }
        if ((n2 = ((RC2ParameterSpec)algorithmParameterSpec).getEffectiveKeyBits()) < 1) throw new InvalidParameterSpecException(z[6]);
        if (n2 > 1024) {
            throw new InvalidParameterSpecException(z[6]);
        }
        this.c = n2;
        if (n2 >= 256) {
            this.b = n2;
            return;
        }
        this.b = this.a(n2);
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        byte[] byArray2;
        block19: {
            byArray2 = null;
            try {
                DerValue derValue = new DerValue(byArray);
                if (derValue.getTag() == 4) {
                    byArray2 = derValue.getData().getOctetString();
                    if (derValue.getData().available() != 0) {
                        throw new IOException(z[11]);
                    }
                    this.b = this.a(32);
                    this.c = 32;
                    break block19;
                }
                if (derValue.getTag() == 48) {
                    int n2;
                    block20: {
                        n2 = derValue.getData().getInteger().intValue();
                        byArray2 = derValue.getData().getOctetString();
                        if (derValue.getData().available() != 0) {
                            throw new IOException(z[12]);
                        }
                        if (n2 >= 1 && n2 <= 1024) break block20;
                        throw new IOException(z[9]);
                    }
                    this.c = n2 >= 256 ? n2 : this.b(n2);
                    this.b = n2;
                    break block19;
                }
                throw new IOException(z[13] + derValue.getTag() + z[14]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(z[10]);
            }
        }
        if (byArray2.length != 8) {
            throw new IOException(z[15]);
        }
        this.a = byArray2;
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        try {
            block4: {
                block5: {
                    Class<T> clazz2 = Class.forName(z[2]);
                    if (!clazz2.isAssignableFrom(clazz)) break block4;
                    if (this.a != null) break block5;
                    return (T)((AlgorithmParameterSpec)clazz.cast(new RC2ParameterSpec(this.c)));
                }
                return (T)((AlgorithmParameterSpec)clazz.cast(new RC2ParameterSpec(this.c, this.a)));
            }
            throw new InvalidParameterSpecException(z[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException(z[1] + classNotFoundException.getMessage());
        }
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream;
        block3: {
            block2: {
                derOutputStream = new DerOutputStream();
                if (this.c != 32) break block2;
                derOutputStream.putOctetString(this.a);
                break block3;
            }
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(BigInteger.valueOf(this.b));
            derOutputStream2.putOctetString(this.a);
            derOutputStream.write((byte)48, derOutputStream2);
        }
        return derOutputStream.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        String string = z[5];
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        string = string + hexDumpEncoder.encodeBuffer(this.a);
        string = string + "]";
        return z[4] + BigInteger.valueOf(this.c).toString() + "\n" + string;
    }

    private int a(int n2) {
        byte by = d[n2];
        if (by >= 0) {
            return by;
        }
        return by + 256;
    }

    private int b(int n2) throws IOException {
        int n3;
        for (n3 = 1; n3 < 256; ++n3) {
            int n4 = d[n3];
            int n5 = n4 >= 0 ? n4 : n4 + 256;
            int n6 = n5;
            if (n2 != n6) continue;
            break;
        }
        if (n3 < 256) {
            return n3;
        }
        throw new IOException(z[3]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[16];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = ";08\u0012O\u00001)\u0010V\u0013*<BO\u0013,8\u000fZ\u0006;+BL\u0002;:\u000bY\u001b=8\u0016V\u001d0";
        int n3 = -1;
        block23: while (true) {
            char[] cArray;
            block27: {
                int n4;
                int n5;
                block26: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block26;
                    n5 = n5;
                    if (n5 <= n4) break block27;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 114;
                            break;
                        }
                        case 1: {
                            n6 = 94;
                            break;
                        }
                        case 2: {
                            n6 = 89;
                            break;
                        }
                        case 3: {
                            n6 = 98;
                            break;
                        }
                        default: {
                            n6 = 63;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "'0*\u0017O\u00021+\u0016Z\u0016~)\u0003M\u00133<\u0016Z\u0000~*\u0012Z\u00117?\u000b\\\u0013*0\rQH~";
                    n3 = 0;
                    continue block23;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0018?/\u0003G\\=+\u001bO\u00061w\u0011O\u0017=w0|@\u000e8\u0010^\u001f;-\u0007M!.<\u0001";
                    n3 = 1;
                    continue block23;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = " \u001dk4Z\u0000-0\rQR=8\fQ\u001d*y\u0000ZR86\u0017Q\u0016~0\f\u001f\u00066<BK\u0000?7\u0011S\u0013*0\rQR*8\u0000S\u0017p";
                    n3 = 2;
                    continue block23;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "78?\u0007\\\u00067/\u0007\u001f\u0019; B]\u001b**X5";
                    n3 = 3;
                    continue block23;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "x~yB\u001f;\bchd";
                    n3 = 4;
                    continue block23;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "78?\u0007\\\u00067/\u0007\u001f\u0019; BL\u001b$<BV\u0001~7\rKR77BK\u001a;y\u0010^\u001c9<BP\u0014~hB\u0012RoiP\u000bR<0\u0016L\\";
                    n3 = 5;
                    continue block23;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = ";\by\fP\u0006~aB]\u000b*<\u0011\u001f\u001e17\u0005";
                    n3 = 6;
                    continue block23;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = ";08\u0012O\u00001)\u0010V\u0013*<BO\u0013,8\u000fZ\u0006;+BL\u0002;:\u000bY\u001b=8\u0016V\u001d0";
                    n3 = 7;
                    continue block23;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = " \u001dk4Z\u0000-0\rQR7*BQ\u001d*y\u000bQR*1\u0007\u001f\u0000?7\u0005ZR1?B\u000eRsyS\u000f@jw";
                    n3 = 8;
                    continue block23;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = " \u001dk4Z\u0000-0\rQR2<\fX\u00066y\u0016P\u001d~;\u000bX";
                    n3 = 9;
                    continue block23;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = ";\by\u0012^\u0000-0\fXR;+\u0010P\u0000dy\u0007G\u0006,8B[\u0013*8";
                    n3 = 10;
                    continue block23;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = " \u001dkBo\u0013,8\u000fZ\u0006;+\u0011\u001f\u0002?+\u0011V\u001c9y\u0007M\u00001+X\u001f7&-\u0010^R:8\u0016^";
                    n3 = 11;
                    continue block23;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = " \u001dkBo\u0013,8\u000fZ\u0006;+\u0011\u001f\u0002?+\u0011V\u001c9y\u0007M\u00001+X\u001f\u0006?>B";
                    n3 = 12;
                    continue block23;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "R06\u0016\u001f\u0001+)\u0012P\u0000*<\u0006";
                    n3 = 13;
                    continue block23;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = ";\by\fP\u0006~aB]\u000b*<\u0011\u001f\u001e17\u0005";
                    n3 = 14;
                    continue block23;
                }
                case 14: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        d = new byte[]{-67, 86, -22, -14, -94, -15, -84, 42, -80, -109, -47, -100, 27, 51, -3, -48, 48, 4, -74, -36, 125, -33, 50, 75, -9, -53, 69, -101, 49, -69, 33, 90, 65, -97, -31, -39, 74, 77, -98, -38, -96, 104, 44, -61, 39, 95, -128, 54, 62, -18, -5, -107, 26, -2, -50, -88, 52, -87, 19, -16, -90, 63, -40, 12, 120, 36, -81, 35, 82, -63, 103, 23, -11, 102, -112, -25, -24, 7, -72, 96, 72, -26, 30, 83, -13, -110, -92, 114, -116, 8, 21, 110, -122, 0, -124, -6, -12, 127, -118, 66, 25, -10, -37, -51, 20, -115, 80, 18, -70, 60, 6, 78, -20, -77, 53, 17, -95, -120, -114, 43, -108, -103, -73, 113, 116, -45, -28, -65, 58, -34, -106, 14, -68, 10, -19, 119, -4, 55, 107, 3, 121, -119, 98, -58, -41, -64, -46, 124, 106, -117, 34, -93, 91, 5, 93, 2, 117, -43, 97, -29, 24, -113, 85, 81, -83, 31, 11, 94, -123, -27, -62, 87, 99, -54, 61, 108, -76, -59, -52, 112, -78, -111, 89, 13, 71, 32, -56, 79, 88, -32, 1, -30, 22, 56, -60, 111, 59, 15, 101, 70, -66, 126, 45, 123, -126, -7, 64, -75, 29, 115, -8, -21, 38, -57, -121, -105, 37, 84, -79, 40, -86, -104, -99, -91, 100, 109, 122, -44, 16, -127, 68, -17, 73, -42, -82, 46, -35, 118, 92, 47, -89, 28, -55, 9, 105, -102, -125, -49, 41, 57, -71, -23, 76, -1, 67, -85};
    }
}

