/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.ByteAdder;
import com.ibm.crypto.provider.IBMJCE;
import com.ibm.crypto.provider.IHashDrbg;
import com.ibm.crypto.provider.n;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;

public class HASHDRBG
extends SecureRandomSpi
implements IHashDrbg {
    private static final long serialVersionUID = 2596920209735836086L;
    public static final int MIN_STRENGTH = 112;
    public static final int MAX_STRENGTH = 256;
    public static final int SHA1_MAX_STRENGTH = 128;
    public static final int SHA224_MAX_STRENGTH = 192;
    public static final int MIN_SEED_LENGTH = 440;
    public static final int MAX_SEED_LENGTH = 888;
    public static final String DEFAULT_DIGEST_ALG;
    public static final int DEFAULT_STRENGTH = 256;
    private static final int MIN_SEED_BYTES = 55;
    private static final int MAX_SEED_BYTES = 111;
    private static final long MAX_UNTIL_RESEED = 0x1000000000000L;
    protected String hashAlgName;
    protected int security_strength = 0;
    protected int ss_bytes = 0;
    protected int seed_byte_count;
    protected ByteBuffer entropy;
    protected MessageDigest hash;
    private int seedlen;
    private int outlenbits;
    protected byte[] V;
    protected byte[] C;
    protected long reseed_counter = 0L;
    protected SecureRandom sr;
    protected boolean resistant;
    protected boolean initDone;
    private static final String[] z;

    public HASHDRBG() {
    }

    protected HASHDRBG(String string, int n2) {
        this.security_strength = n2;
        if (n2 < 112) {
            throw new IllegalArgumentException(z[19]);
        }
        if (n2 > 256) {
            throw new IllegalArgumentException(z[18]);
        }
        this.hashAlgName = string;
        try {
            this.hash = MessageDigest.getInstance(string, IBMJCE.getInstance());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    @Override
    protected byte[] engineGenerateSeed(int n2) {
        byte[] byArray = new byte[n2];
        if (!n.getInstance().generateSeed(byArray)) {
            this.engineNextBytes(byArray);
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected synchronized void engineNextBytes(byte[] byArray) {
        byte[] byArray2;
        if (!this.initDone) {
            if (this.hashAlgName == null) {
                this.hashAlgName = z[16];
            }
            if (this.security_strength >= 0) {
                this.security_strength = 256;
            }
            this.engineSetSeed(null);
        }
        if ((byArray2 = this.generate(byArray.length, false, null)).length != byArray.length) throw new IllegalStateException(z[15]);
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected synchronized void engineSetSeed(byte[] byArray) {
        if (byArray == null) {
            byArray = this.b(this.ss_bytes);
        }
        if (!this.initDone) {
            if (this.hashAlgName == null) {
                this.init(z[2], 256, ByteBuffer.wrap(byArray), false);
            } else {
                this.init(this.hashAlgName, this.security_strength, ByteBuffer.wrap(byArray), false);
            }
            if (byArray.length < this.ss_bytes) {
                throw new IllegalArgumentException(z[1] + this.ss_bytes + z[0]);
            }
        } else {
            this.entropy = ByteBuffer.wrap(byArray, 0, this.ss_bytes);
        }
        if (this.reseed_counter >= 1L) {
            this.reseed(null);
            return;
        }
        byte[] byArray2 = new byte[]{};
        if (byArray.length > this.ss_bytes) {
            byArray2 = new byte[byArray.length - this.ss_bytes];
            System.arraycopy(byArray, this.ss_bytes, byArray2, 0, byArray.length - this.ss_bytes);
        }
        this.instantiate(byArray2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int init(String string, int n2, ByteBuffer byteBuffer, boolean bl2) throws IllegalArgumentException {
        block42: {
            byte[] byArray;
            block44: {
                block43: {
                    block41: {
                        if (string == null || !string.startsWith(z[11])) {
                            throw new IllegalArgumentException(z[10]);
                        }
                        if (this.hashAlgName != null && !this.hashAlgName.equalsIgnoreCase(string)) {
                            throw new IllegalStateException(z[7]);
                        }
                        try {
                            this.hash = MessageDigest.getInstance(string, IBMJCE.getInstance());
                        }
                        catch (Exception exception) {
                            throw new IllegalArgumentException(exception);
                        }
                        byArray = this.hash.digest();
                        this.seed_byte_count = 55;
                        this.seedlen = 440;
                        if (byArray == null || byArray.length < 20) {
                            throw new IllegalArgumentException(z[5]);
                        }
                        this.outlenbits = byArray.length << 3;
                        this.ss_bytes = n2 >> 3;
                        if (this.ss_bytes << 3 != n2) {
                            throw new IllegalArgumentException(z[12]);
                        }
                        if (n2 > 112) break block41;
                        n2 = 112;
                        break block42;
                    }
                    if (byArray.length != 20) break block43;
                    if (n2 > 128) {
                        throw new IllegalArgumentException(z[6]);
                    }
                    this.security_strength = 128;
                    break block42;
                }
                if (byArray.length != 28) break block44;
                if (n2 > 192) {
                    throw new IllegalArgumentException(z[8]);
                }
                if (n2 > 112 && n2 <= 128) {
                    this.security_strength = 128;
                    break block42;
                } else if (n2 > 128 && n2 <= 192) {
                    this.security_strength = 192;
                }
                break block42;
            }
            if (byArray.length > 32) {
                this.seed_byte_count = 111;
                this.seedlen = 888;
            }
            if (n2 > 256) {
                throw new IllegalArgumentException(z[9]);
            }
            if (n2 > 112 && n2 <= 128) {
                this.security_strength = 128;
            } else if (n2 > 128 && n2 <= 192) {
                this.security_strength = 192;
            } else if (n2 > 192 && n2 <= 256) {
                this.security_strength = 256;
            }
        }
        this.entropy = byteBuffer;
        this.resistant = bl2;
        this.initDone = true;
        return this.security_strength;
    }

    @Override
    public void instantiate(byte[] byArray, byte[] byArray2) {
        byte[] byArray3;
        int n2;
        int n3;
        block13: {
            block12: {
                n3 = 0;
                n2 = 0;
                if (byArray2 != null) {
                    n3 = byArray2.length;
                }
                if (byArray != null) {
                    n2 = byArray.length;
                }
                byArray3 = null;
                if (this.entropy != null && this.entropy.remaining() != 0) break block12;
                byArray3 = this.b(0);
                break block13;
            }
            byArray3 = new byte[this.ss_bytes];
            try {
                this.entropy.get(byArray3);
            }
            catch (Exception exception) {
                throw new IllegalStateException(z[17], exception);
            }
        }
        byte[] byArray4 = new byte[byArray3.length + n2 + n3];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        if (n2 > 0) {
            System.arraycopy(byArray, 0, byArray4, byArray3.length, byArray.length);
        }
        if (n3 != 0) {
            System.arraycopy(byArray2, 0, byArray4, byArray3.length + n2, n3);
        }
        this.V = this.a(this.hash, this.outlenbits, byArray4, this.seedlen);
        byte[] byArray5 = new byte[this.V.length + 1];
        byArray5[0] = 0;
        System.arraycopy(this.V, 0, byArray5, 1, this.V.length);
        this.C = this.a(this.hash, this.outlenbits, byArray5, this.seedlen);
        this.reseed_counter = 1L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] generate(int n2, boolean bl2, byte[] byArray) {
        int n3 = n2 << 3;
        if (bl2 && !this.resistant) {
            throw new IllegalArgumentException(z[4]);
        }
        if (this.reseed_counter >= 0x1000000000000L || bl2) {
            this.reseed(byArray);
            byArray = null;
        }
        byte[] byArray2 = null;
        if (byArray != null) {
            byte[] byArray3 = null;
            this.hash.update((byte)2);
            this.hash.update(this.V);
            byArray3 = this.hash.digest(byArray);
            this.V = ByteAdder.add(this.seed_byte_count, this.V, byArray3);
        }
        int n4 = this.a(n3, this.outlenbits);
        byte[] byArray4 = (byte[])this.V.clone();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int n5 = 1; n5 <= n4; ++n5) {
            try {
                byteArrayOutputStream.write(this.hash.digest(byArray4));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            byArray4 = ByteAdder.add(this.seed_byte_count, byArray4, HASHDRBG.a(1));
        }
        byArray2 = byteArrayOutputStream.toByteArray();
        if (byArray2.length > n2) {
            byte[] byArray5 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray5, 0, n2);
            byArray2 = byArray5;
        }
        byte[] byArray6 = null;
        this.hash.update((byte)3);
        byArray6 = this.hash.digest(this.V);
        this.V = ByteAdder.add(this.seed_byte_count, this.V, byArray6, this.C, HASHDRBG.a((int)this.reseed_counter));
        ++this.reseed_counter;
        return byArray2;
    }

    @Override
    public void reseed(byte[] byArray) {
        int n2 = 0;
        if (byArray != null) {
            n2 = byArray.length;
        }
        byte[] byArray2 = new byte[this.ss_bytes];
        try {
            this.entropy.get(byArray2);
        }
        catch (Exception exception) {
            throw new IllegalStateException(z[3], exception);
        }
        byte[] byArray3 = new byte[1 + this.V.length + byArray2.length + n2];
        byArray3[0] = 1;
        int n3 = 1;
        System.arraycopy(this.V, 0, byArray3, n3, this.V.length);
        System.arraycopy(byArray2, 0, byArray3, n3 += this.V.length, byArray2.length);
        n3 += byArray2.length;
        if (n2 != 0) {
            System.arraycopy(byArray, 0, byArray3, n3, n2);
        }
        this.V = this.a(this.hash, this.outlenbits, byArray3, this.seedlen);
        byte[] byArray4 = new byte[this.V.length + 1];
        byArray4[0] = 0;
        System.arraycopy(this.V, 0, byArray4, 1, this.V.length);
        this.C = this.a(this.hash, this.outlenbits, byArray4, this.seedlen);
        this.reseed_counter = 1L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(MessageDigest messageDigest, int n2, byte[] byArray, int n3) {
        byte[] byArray2 = null;
        int n4 = this.a(n3, n2);
        int n5 = n3 + 7 >> 3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n5);
        for (int n6 = 1; n6 <= n4; ++n6) {
            messageDigest.update((byte)n6);
            messageDigest.update(HASHDRBG.a(n3));
            try {
                byteArrayOutputStream.write(messageDigest.digest(byArray));
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        byArray2 = byteArrayOutputStream.toByteArray();
        if (byArray2.length > n5) {
            byte[] byArray3 = byArray2;
            byArray2 = new byte[n5];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
        }
        return byArray2;
    }

    private static final void a(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >>> 24);
        byArray[n3 + 1] = (byte)(n2 >>> 16);
        byArray[n3 + 2] = (byte)(n2 >>> 8);
        byArray[n3 + 3] = (byte)n2;
    }

    private static final byte[] a(int n2) {
        byte[] byArray = new byte[4];
        HASHDRBG.a(n2, byArray, 0);
        return byArray;
    }

    private int a(int n2, int n3) {
        if (n3 <= 0) {
            throw new IllegalArgumentException(z[14]);
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        int n4 = n2 / n3;
        if (n4 * n3 != n2) {
            ++n4;
        }
        return n4;
    }

    private byte[] b(int n2) {
        if (n2 <= 0) {
            n2 = 32;
        }
        byte[] byArray = n.getInstance().generateSeed(n2);
        if (byArray != null) {
            return byArray;
        }
        if (this.sr == null) {
            try {
                this.sr = SecureRandom.getInstance(z[13], IBMJCE.getInstance());
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        return this.sr.generateSeed(n2);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[20];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0014\"JVrr\\";
        int n3 = 19;
        block28: while (true) {
            char[] cArray;
            block32: {
                int n4;
                int n5;
                block31: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block31;
                    n5 = n5;
                    if (n5 <= n4) break block32;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 71;
                            break;
                        }
                        case 1: {
                            n6 = 106;
                            break;
                        }
                        case 2: {
                            n6 = 11;
                            break;
                        }
                        case 3: {
                            n6 = 123;
                            break;
                        }
                        default: {
                            n6 = 64;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                case 19: {
                    DEFAULT_DIGEST_ALG = string.intern();
                    string2 = "g\br\u000f%4Jd\u001d`\"\u0004\u007f\t/7\u0013";
                    n3 = -1;
                    continue block28;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = ")\u000fn\u001f`&\u001e+\u0017%&\u0019\u007f[";
                    n3 = 0;
                    continue block28;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0014\"JVrr\\";
                    n3 = 1;
                    continue block28;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = ")\u0005\u007f[%)\u0005~\u001c(g\u000fe\u000f2(\u001ar";
                    n3 = 2;
                    continue block28;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "7\u0018n\u001f)$\u001eb\u0014.g\u0018n\b)4\u001ej\u0015#\"Jh\u001a0&\bb\u0017)3\u0013+\u0015/3Jb\u001533\u000be\u000f)&\u001en\u001f";
                    n3 = 3;
                    continue block28;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "&\u0006l\u00142.\u001ec\u0016`)\u0005\u007f[33\u0018d\u0015'g\u000fe\u00145 \u0002";
                    n3 = 4;
                    continue block28;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "&\u0006l\u00142.\u001ec\u0016`)\u0005\u007f[33\u0018d\u0015'g\u000fe\u00145 \u0002";
                    n3 = 5;
                    continue block28;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "$\u000be\u0015/3Jb\u0015)3J|\u00124/Jo\u0012&!\u000fy\u001e.3Jc\u001a3/Jj\u0017'(\u0018b\u000f(*";
                    n3 = 6;
                    continue block28;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "&\u0006l\u00142.\u001ec\u0016`)\u0005\u007f[33\u0018d\u0015'g\u000fe\u00145 \u0002";
                    n3 = 7;
                    continue block28;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "&\u0006l\u00142.\u001ec\u0016`)\u0005\u007f[33\u0018d\u0015'g\u000fe\u00145 \u0002";
                    n3 = 8;
                    continue block28;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "(\u0004g\u0002`4\u001f{\u000b/5\u001e+\u000f(\"JX3\u0001g\fj\u0016)+\u0013";
                    n3 = 9;
                    continue block28;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u0014\"J";
                    n3 = 10;
                    continue block28;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = ")\u000fn\u001f`%\u0013\u007f\u001e`*\u001fg\u000f)7\u0006n[&(\u0018+\u0019)39\u007f\t%)\r\u007f\u0013\u0012\"\u001b~\u001e33\u000fo";
                    n3 = 11;
                    continue block28;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u0014\"JJ\u0010\u0015$L";
                    n3 = 12;
                    continue block28;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "4\u001ey\u0012$\"Jb\b`{W+\u0001%5\u0005";
                    n3 = 13;
                    continue block28;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "\u000e\u0004\u007f\u001e2)\u000bg[%5\u0018d\tlg\u001dy\u0014. Jg\u001e. \u001ec[/2\u001e{\u000e4g\rn\u0015%5\u000b\u007f\u001e$";
                    n3 = 14;
                    continue block28;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "\u0014\"JVrr\\";
                    n3 = 15;
                    continue block28;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = ")\u0005\u007f[%)\u0005~\u001c(g\u000fe\u000f2(\u001ar";
                    n3 = 16;
                    continue block28;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "3\u0005d[33\u0018d\u0015'";
                    n3 = 17;
                    continue block28;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "3\u0005d[7\"\u000b`";
                    n3 = 18;
                    continue block28;
                }
                case 18: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

