/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.ECNamedCurve;
import com.ibm.crypto.provider.ECUtils;
import com.ibm.crypto.provider.IBMJCE;
import com.ibm.crypto.provider.PrimeCurve;
import com.ibm.crypto.provider.PrimeField;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.AlgorithmParametersSpi;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;
import java.util.Map;
import java.util.Set;

public class ECParameters
extends AlgorithmParametersSpi {
    protected int a;
    protected EllipticCurve b;
    protected ECPoint c;
    protected BigInteger d;
    private static final String[] z;

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        byte[] byArray = this.encodeECParameters();
        return byArray;
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        try {
            Class<T> clazz2 = Class.forName(z[12]);
            if (clazz2.isAssignableFrom(clazz)) {
                return (T)((AlgorithmParameterSpec)clazz.cast(new ECParameterSpec(this.b, this.c, this.d, this.a)));
            }
            throw new InvalidParameterSpecException(z[11]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException(z[13] + classNotFoundException.getMessage());
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        ECParameterSpec eCParameterSpec;
        block9: {
            if (algorithmParameterSpec == null) {
                throw new InvalidParameterSpecException(z[3]);
            }
            if (algorithmParameterSpec instanceof ECParameterSpec) {
                eCParameterSpec = (ECParameterSpec)algorithmParameterSpec;
            } else {
                if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                    String string = ((ECGenParameterSpec)algorithmParameterSpec).getName();
                    eCParameterSpec = ECNamedCurve.getECParameterSpec(string);
                    if (eCParameterSpec == null) {
                        throw new InvalidParameterSpecException(z[2] + string);
                    }
                    break block9;
                }
                throw new InvalidParameterSpecException(z[1]);
            }
        }
        eCParameterSpec = ECUtils.getPrimeParameterSpec(eCParameterSpec);
        this.b = eCParameterSpec.getCurve();
        this.c = eCParameterSpec.getGenerator();
        this.d = eCParameterSpec.getOrder();
        this.a = eCParameterSpec.getCofactor();
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        ECParameterSpec eCParameterSpec = ECParameters.decodeECParameters(byArray);
        eCParameterSpec = ECUtils.getPrimeParameterSpec(eCParameterSpec);
        this.b = eCParameterSpec.getCurve();
        this.c = eCParameterSpec.getGenerator();
        this.d = eCParameterSpec.getOrder();
        this.a = eCParameterSpec.getCofactor();
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected String engineToString() {
        return z[16] + this.b.getA() + z[19] + this.b.getB() + z[15] + this.b.getField().getFieldSize() + z[18] + ECUtils.a(this.c) + z[14] + this.d.toString() + z[17] + this.a + "\n";
    }

    protected static AlgorithmParameters a(ECParameterSpec eCParameterSpec) throws InvalidKeyException, InvalidParameterSpecException {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(z[22], IBMJCE.getInstance());
            algorithmParameters.init(eCParameterSpec);
            return algorithmParameters;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidParameterSpecException(z[21] + generalSecurityException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] encodePoint(ECPoint eCPoint, EllipticCurve ellipticCurve) {
        int n3 = ellipticCurve.getField().getFieldSize();
        int n2 = n3 + 7 >> 3;
        byte[] byArray2 = ECParameters.a(eCPoint.getAffineX().toByteArray());
        byte[] byArray = ECParameters.a(eCPoint.getAffineY().toByteArray());
        if (byArray2.length <= n2 && byArray.length <= n2) {
            byte[] byArray3 = new byte[1 + (n2 << 1)];
            byArray3[0] = 4;
            System.arraycopy(byArray2, 0, byArray3, n2 - byArray2.length + 1, byArray2.length);
            System.arraycopy(byArray, 0, byArray3, byArray3.length - byArray.length, byArray.length);
            return byArray3;
        }
        throw new RuntimeException(z[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ECPoint decodePoint(byte[] byArray, EllipticCurve ellipticCurve) throws IOException {
        if (byArray.length == 0 || byArray[0] != 4) {
            throw new IOException(z[6]);
        }
        int n2 = ellipticCurve.getField().getFieldSize() + 7 >> 3;
        if (byArray.length != n2 * 2 + 1) {
            throw new IOException(z[7]);
        }
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 1, byArray2, 0, n2);
        System.arraycopy(byArray, n2 + 1, byArray3, 0, n2);
        return new ECPoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] a(byte[] byArray) {
        int n2;
        for (n2 = 0; n2 < byArray.length - 1 && byArray[n2] == 0; ++n2) {
        }
        if (n2 == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static DerValue encodeEllipticCurve(EllipticCurve ellipticCurve) throws IOException {
        try {
            byte[] byArray = ECParameters.a(ellipticCurve.getA().toByteArray());
            byte[] byArray2 = ECParameters.a(ellipticCurve.getB().toByteArray());
            byte[] byArray3 = ellipticCurve.getSeed();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(byArray);
            derOutputStream.putOctetString(byArray2);
            if (byArray3 != null) {
                derOutputStream.putBitString(byArray3);
            }
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue;
        }
        catch (IOException iOException) {
            throw new IOException(z[20] + iOException);
        }
    }

    public static EllipticCurve decodeEllipticCurve(DerValue derValue, ECField eCField) throws IOException {
        try {
            if (derValue.getTag() != 48) {
                throw new IOException(z[23]);
            }
            DerInputStream derInputStream = derValue.getData();
            byte[] byArray = derInputStream.getOctetString();
            BigInteger bigInteger = new BigInteger(1, byArray);
            byte[] byArray2 = derInputStream.getOctetString();
            BigInteger bigInteger2 = new BigInteger(1, byArray2);
            byte[] byArray3 = null;
            if (derInputStream.available() != 0) {
                byArray3 = derInputStream.getBitString();
            }
            PrimeCurve primeCurve = null;
            int n2 = 0;
            if (ECUtils.isNistPrime(((ECFieldFp)eCField).getP())) {
                n2 = 1;
            }
            primeCurve = byArray3 == null ? ECUtils.getCurve((PrimeField)eCField, bigInteger, bigInteger2, n2) : ECUtils.getCurve((PrimeField)eCField, bigInteger, bigInteger2, byArray3, n2);
            return primeCurve;
        }
        catch (IOException iOException) {
            throw new IOException(z[24] + iOException);
        }
    }

    public static DerValue encodePrimeFieldType(ECFieldFp eCFieldFp) throws IOException {
        try {
            int[] nArray = new int[]{1, 2, 840, 10045, 1, 1};
            ObjectIdentifier objectIdentifier = new ObjectIdentifier(nArray);
            BigInteger bigInteger = eCFieldFp.getP();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOID(objectIdentifier);
            derOutputStream.putInteger(bigInteger);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue;
        }
        catch (IOException iOException) {
            throw new IOException(z[25] + iOException);
        }
    }

    public static ECFieldFp decodePrimeFieldType(DerValue derValue) throws IOException {
        int[] nArray = new int[]{1, 2, 840, 10045, 1, 1};
        ObjectIdentifier objectIdentifier = new ObjectIdentifier(nArray);
        try {
            if (derValue.getTag() != 48) {
                throw new IOException(z[10]);
            }
            DerInputStream derInputStream = derValue.getData();
            ObjectIdentifier objectIdentifier2 = derInputStream.getOID();
            if (!objectIdentifier2.equals(objectIdentifier)) {
                throw new IOException(z[8]);
            }
            BigInteger bigInteger = derInputStream.getInteger();
            ECFieldFp eCFieldFp = (ECFieldFp)((Object)ECUtils.getField(bigInteger.bitLength(), bigInteger, ECUtils.isNistPrime(bigInteger)));
            return eCFieldFp;
        }
        catch (IOException iOException) {
            throw new IOException(z[9] + iOException);
        }
    }

    public byte[] encodeECParameters() throws IOException {
        try {
            EllipticCurve ellipticCurve = this.b;
            ECPoint eCPoint = this.c;
            BigInteger bigInteger = this.d;
            int n2 = this.a;
            ECParameterSpec eCParameterSpec = new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n2);
            ECNamedCurve eCNamedCurve = ECParameters.getNamedCurve(eCParameterSpec);
            if (eCNamedCurve != null) {
                return eCNamedCurve.a();
            }
            ECField eCField = ellipticCurve.getField();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(1);
            if (!(eCField instanceof ECFieldFp)) {
                throw new IOException(z[4]);
            }
            DerValue derValue = ECParameters.encodePrimeFieldType((ECFieldFp)eCField);
            derOutputStream.putDerValue(derValue);
            derValue = ECParameters.encodeEllipticCurve(ellipticCurve);
            derOutputStream.putDerValue(derValue);
            byte[] byArray = ECParameters.encodePoint(eCPoint, ellipticCurve);
            derOutputStream.putOctetString(byArray);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(n2);
            DerValue derValue2 = new DerValue(48, derOutputStream.toByteArray());
            byte[] byArray2 = derValue2.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new IOException(z[5] + iOException);
        }
    }

    public static ECParameterSpec decodeECParameters(byte[] byArray) throws IOException {
        boolean bl2 = false;
        try {
            DerValue derValue;
            block5: {
                block6: {
                    DerInputStream derInputStream = new DerInputStream(byArray);
                    derValue = derInputStream.getDerValue();
                    if (derValue.getTag() == 48) break block5;
                    if (derValue.getTag() != 6) break block6;
                    String string = derValue.getOID().toString();
                    return ECNamedCurve.getECParameterSpec(string);
                }
                throw new IOException(z[27]);
            }
            DerInputStream derInputStream = derValue.getData();
            int n2 = derInputStream.getInteger().intValue();
            DerValue derValue2 = derInputStream.getDerValue();
            ECFieldFp eCFieldFp = ECParameters.decodePrimeFieldType(derValue2);
            DerValue derValue3 = derInputStream.getDerValue();
            EllipticCurve ellipticCurve = ECParameters.decodeEllipticCurve(derValue3, eCFieldFp);
            byte[] byArray2 = derInputStream.getOctetString();
            ECPoint eCPoint = ECParameters.decodePoint(byArray2, ellipticCurve);
            BigInteger bigInteger = derInputStream.getBigInteger();
            int n3 = 0;
            if (derInputStream.available() != 0) {
                bl2 = true;
                n3 = derInputStream.getInteger().intValue();
            }
            ECParameterSpec eCParameterSpec = null;
            eCParameterSpec = bl2 ? new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n3) : new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, 0);
            return eCParameterSpec;
        }
        catch (IOException iOException) {
            throw new IOException(z[26] + iOException);
        }
    }

    public static ECNamedCurve getNamedCurve(ECParameterSpec eCParameterSpec) {
        try {
            Map<String, ECParameterSpec> map = ECNamedCurve.b();
            Set<Map.Entry<String, ECParameterSpec>> set = map.entrySet();
            for (Map.Entry<String, ECParameterSpec> entry : set) {
                ECParameterSpec eCParameterSpec2;
                String string;
                block43: {
                    byte[] byArray;
                    byte[] byArray2;
                    block42: {
                        string = entry.getKey();
                        eCParameterSpec2 = entry.getValue();
                        eCParameterSpec2 = ECUtils.getPrimeParameterSpec(eCParameterSpec2);
                        eCParameterSpec = ECUtils.getPrimeParameterSpec(eCParameterSpec);
                        BigInteger bigInteger = eCParameterSpec2.getCurve().getA();
                        BigInteger bigInteger2 = eCParameterSpec.getCurve().getA();
                        BigInteger bigInteger3 = eCParameterSpec2.getCurve().getB();
                        BigInteger bigInteger4 = eCParameterSpec.getCurve().getB();
                        int n2 = eCParameterSpec2.getCurve().getField().getFieldSize();
                        int n3 = eCParameterSpec.getCurve().getField().getFieldSize();
                        byArray2 = eCParameterSpec2.getCurve().getSeed();
                        byArray = eCParameterSpec.getCurve().getSeed();
                        if (!bigInteger.equals(bigInteger2) || !bigInteger3.equals(bigInteger4)) continue;
                        if (n2 != n3) {
                            continue;
                        }
                        if (byArray2 != null || byArray != null) break block42;
                        break block43;
                    }
                    if (byArray2 == null && byArray != null) {
                        continue;
                    }
                    if (byArray2 != null && byArray == null) {
                        continue;
                    }
                    if (byArray2 == null || byArray == null) break block43;
                    if (byArray2.length != byArray.length) {
                        continue;
                    }
                    boolean bl2 = true;
                    int n4 = 0;
                    while (true) {
                        block47: {
                            if (n4 >= byArray2.length) break;
                            if (byArray2[n4] == byArray[n4]) break block47;
                            bl2 = false;
                            break;
                        }
                        ++n4;
                    }
                    if (!bl2) {
                        continue;
                    }
                }
                if (!eCParameterSpec2.getGenerator().equals(eCParameterSpec.getGenerator())) {
                    continue;
                }
                if (!eCParameterSpec2.getOrder().equals(eCParameterSpec.getOrder())) {
                    continue;
                }
                if (eCParameterSpec2.getCofactor() != eCParameterSpec.getCofactor()) {
                    continue;
                }
                ECNamedCurve eCNamedCurve = new ECNamedCurve(string);
                return eCNamedCurve;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[28];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "_VBME/ZDLCkPEBEjJ\u000bG^/WDW\u0011bX_@Y/_BF]k\u0019XJKj";
        int n3 = -1;
        block35: while (true) {
            char[] cArray;
            block39: {
                int n4;
                int n5;
                block38: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block38;
                    n5 = n5;
                    if (n5 <= n4) break block39;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 15;
                            break;
                        }
                        case 1: {
                            n6 = 57;
                            break;
                        }
                        case 2: {
                            n6 = 43;
                            break;
                        }
                        case 3: {
                            n6 = 35;
                            break;
                        }
                        default: {
                            n6 = 49;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "FWJSA}V[QXnMN\u0003AnKJNT{\\Y\u0003B\u007f\\HJWfZJWX`W";
                    n3 = 0;
                    continue block35;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "ZW@M^xW\u000b@D}ON\u0019\u0011";
                    n3 = 1;
                    continue block35;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u007fXYB\\\\IN@\u0011bLXW\u0011aV_\u0003Sj\u0019EV]c";
                    n3 = 2;
                    continue block35;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "JzmJTc]m\u0011\\/\\E@^zW_FCj]\u000bJ_/\\E@^k\\n`anKJNT{\\YP\u0019&\u0017\u000b\u0003tL\u007fBF]k\u007f\u0019N\u0011fJ\u000bM^{\u0019HVC}\\EW]v\u0019XVA\u007fVYWTk\u0017";
                    n3 = 3;
                    continue block35;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "JAHFA{PDM\u0011fW\u000bF_lVOFtLiJQPb\\_FC|\u0011\u0002\u0019\u0011";
                    n3 = 4;
                    continue block35;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "@WGZ\u0011zWHL\\\u007fKNPBj]\u000bS^fW_\u0003W`KFBE/J^SA`K_FU";
                    n3 = 5;
                    continue block35;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "_VBME/]DFB/WDW\u0011bX_@Y/_BF]k\u0019XJKj";
                    n3 = 6;
                    continue block35;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "FWHLC}\\HW\u0011@po\u0003TaZDV_{\\YFU/]^QXa^\u000bGTlVOFa}PFFwf\\GGevIN\r";
                    n3 = 7;
                    continue block35;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "JAHFA{PDM\u0011fW\u000bGTlVOFa}PFFwf\\GGevIN\u000b\u00185\u0019";
                    n3 = 8;
                    continue block35;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "AV_\u0003P/jnrdJwhf";
                    n3 = 9;
                    continue block35;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "FWJSA}V[QXnMN\u0003AnKJNT{\\Y\u0003b\u007f\\HJWfZJWX`W";
                    n3 = 10;
                    continue block35;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "eX]B\u001f|\\HVCfMR\rB\u007f\\H\rtLiJQPb\\_FC\\IN@";
                    n3 = 11;
                    continue block35;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "ZWXVA\u007fVYWTk\u0019[BCnTNWT}\u0019XSTlPMJRnMBL_5\u0019";
                    n3 = 12;
                    continue block35;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\u00050DQUjK\u0011\u0003;\u00060";
                    n3 = 13;
                    continue block35;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "\u00050\"PXu\\\u0011\u0003";
                    n3 = 14;
                    continue block35;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "\u00050HVCy\\\u0011\u0003;\u00060J\u0019\u0011";
                    n3 = 15;
                    continue block35;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "\u00050HLWnZ_LC5\u0019";
                    n3 = 16;
                    continue block35;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "\u00050LF_jKJW^}\u0003\u000b)8\u0006";
                    n3 = 17;
                    continue block35;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "\u00050\"A\u000b/";
                    n3 = 18;
                    continue block35;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "JAHFA{PDM\u0011fW\u000bF_lVOFtcUBSEfZhVCy\\\u0003\n\u000b/";
                    n3 = 19;
                    continue block35;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "ZWXVA\u007fVYWTk\u0019[BCnTNWT}\u0019XSTlPMJRnMBL_5\u0019";
                    n3 = 20;
                    continue block35;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "Jz";
                    n3 = 21;
                    continue block35;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "AV_\u0003P/jnrdJwhf";
                    n3 = 22;
                    continue block35;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "JAHFA{PDM\u0011fW\u000bGTlVOFtcUBSEfZhVCy\\\u0003\n\u000b/";
                    n3 = 23;
                    continue block35;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = "JAHFA{PDM\u0011fW\u000bF_lVOFa}PFFwf\\GGevIN\u000b\u00185\u0019";
                    n3 = 24;
                    continue block35;
                }
                case 24: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = "JAHFA{PDM\u0011fW\u000bGTlVOFtLiJQPb\\_FC|\u0011\u0002\u0019\u0011";
                    n3 = 25;
                    continue block35;
                }
                case 25: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 27;
                    string2 = "AV_\u0003P/jnrdJwhf\u0011`K\u000bB_/vbg";
                    n3 = 26;
                    continue block35;
                }
                case 26: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

