/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.ECPrivateKey;
import com.ibm.crypto.provider.ECPublicKey;
import ibm.security.internal.spec.RFC5915ECPrivateKeyEncodedKeySpec;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class ECKeyFactory
extends KeyFactorySpi {
    private static final String[] z;

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            return new ECPrivateKey(byArray);
        }
        if (keySpec instanceof ECPrivateKeySpec) {
            ECParameterSpec eCParameterSpec = ((ECPrivateKeySpec)keySpec).getParams();
            BigInteger bigInteger = ((ECPrivateKeySpec)keySpec).getS();
            return new ECPrivateKey(bigInteger, eCParameterSpec);
        }
        if (keySpec instanceof RFC5915ECPrivateKeyEncodedKeySpec) {
            return new ECPrivateKey((RFC5915ECPrivateKeyEncodedKeySpec)keySpec);
        }
        try {
            throw new InvalidKeySpecException(z[0]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeySpecException(invalidParameterSpecException.getMessage());
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof X509EncodedKeySpec) {
                byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
                return new ECPublicKey(byArray);
            }
            if (keySpec instanceof ECPublicKeySpec) {
                ECParameterSpec eCParameterSpec = ((ECPublicKeySpec)keySpec).getParams();
                ECPoint eCPoint = ((ECPublicKeySpec)keySpec).getW();
                return new ECPublicKey(eCPoint, eCParameterSpec);
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
                ECPrivateKey eCPrivateKey = new ECPrivateKey(byArray);
                return eCPrivateKey.getPublicKey();
            }
            if (keySpec instanceof RFC5915ECPrivateKeyEncodedKeySpec) {
                ECPrivateKey eCPrivateKey = new ECPrivateKey((RFC5915ECPrivateKeyEncodedKeySpec)keySpec);
                return eCPrivateKey.getPublicKey();
            }
            throw new InvalidKeySpecException(z[14]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeySpecException(invalidParameterSpecException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        try {
            Class<T> clazz2;
            if (key instanceof java.security.interfaces.ECPrivateKey) {
                clazz2 = Class.forName(z[4]);
                Class<T> clazz3 = Class.forName(z[13]);
                Class<T> clazz4 = Class.forName(z[9]);
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.ECPrivateKey eCPrivateKey = (java.security.interfaces.ECPrivateKey)key;
                    return (T)((KeySpec)clazz.cast(new ECPrivateKeySpec(eCPrivateKey.getS(), eCPrivateKey.getParams())));
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    return (T)((KeySpec)clazz.cast(new PKCS8EncodedKeySpec(key.getEncoded())));
                }
                if (!clazz4.isAssignableFrom(clazz)) {
                    throw new InvalidKeySpecException(z[5]);
                }
                if (key instanceof ECPrivateKey) {
                    return (T)((KeySpec)clazz.cast(new RFC5915ECPrivateKeyEncodedKeySpec(((ECPrivateKey)key).getEncoded(z[7]))));
                }
                try {
                    ECPrivateKey eCPrivateKey = new ECPrivateKey(key.getEncoded());
                    return (T)((KeySpec)clazz.cast(new RFC5915ECPrivateKeyEncodedKeySpec(eCPrivateKey.getEncoded(z[8]))));
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new InvalidKeySpecException(invalidKeyException.getMessage());
                }
            }
            if (key instanceof java.security.interfaces.ECPublicKey) {
                clazz2 = Class.forName(z[6]);
                Class<T> clazz5 = Class.forName(z[10]);
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.ECPublicKey eCPublicKey = (java.security.interfaces.ECPublicKey)key;
                    return (T)((KeySpec)clazz.cast(new ECPublicKeySpec(eCPublicKey.getW(), eCPublicKey.getParams())));
                }
                if (clazz5.isAssignableFrom(clazz)) {
                    return (T)((KeySpec)clazz.cast(new X509EncodedKeySpec(key.getEncoded())));
                }
                throw new InvalidKeySpecException(z[11]);
            }
            throw new InvalidKeySpecException(z[3]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException(z[12] + classNotFoundException.getMessage());
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            block8: {
                block9: {
                    block6: {
                        block7: {
                            if (!(key instanceof java.security.interfaces.ECPrivateKey)) break block6;
                            if (!(key instanceof ECPrivateKey)) break block7;
                            return key;
                        }
                        ECPrivateKeySpec eCPrivateKeySpec = this.engineGetKeySpec(key, ECPrivateKeySpec.class);
                        return this.engineGeneratePrivate(eCPrivateKeySpec);
                    }
                    if (!(key instanceof java.security.interfaces.ECPublicKey)) break block8;
                    if (!(key instanceof ECPublicKey)) break block9;
                    return key;
                }
                ECPublicKeySpec eCPublicKeySpec = this.engineGetKeySpec(key, ECPublicKeySpec.class);
                return this.engineGeneratePublic(eCPublicKeySpec);
            }
            throw new InvalidKeyException(z[1]);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(z[2] + invalidKeySpecException.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[15];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "=\b`\"&\u0018\ta#3\fFx2/H\u0015c25\u0001\u0000z47\u001c\u000f|9";
        int n3 = -1;
        block22: while (true) {
            char[] cArray;
            block26: {
                int n4;
                int n5;
                block25: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block25;
                    n5 = n5;
                    if (n5 <= n4) break block26;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 104;
                            break;
                        }
                        case 1: {
                            n6 = 102;
                            break;
                        }
                        case 2: {
                            n6 = 19;
                            break;
                        }
                        case 3: {
                            n6 = 87;
                            break;
                        }
                        default: {
                            n6 = 86;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "?\u0014|91H\u0007\u007f09\u001a\u000fg?;H\u0012j'3";
                    n3 = 0;
                    continue block22;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "+\u0007}99\u001cFg%7\u0006\u0015\u007f6\"\rFx2/RF";
                    n3 = 1;
                    continue block22;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "!\br'&\u001a\tc%?\t\u0012vw=\r\u001f3#/\u0018\u0003";
                    n3 = 2;
                    continue block22;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0002\u0007e6x\u001b\u0003p\"$\u0001\u0012jy%\u0018\u0003py\u0013+6a> \t\u0012v\u001c3\u00115c25";
                    n3 = 3;
                    continue block22;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "!\br'&\u001a\tc%?\t\u0012vw=\r\u001f3$&\r\u0005z1?\u000b\u0007g>9\u0006";
                    n3 = 4;
                    continue block22;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u0002\u0007e6x\u001b\u0003p\"$\u0001\u0012jy%\u0018\u0003py\u0013+6f5:\u0001\u0005X2/;\u0016v4";
                    n3 = 5;
                    continue block22;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = ": PboYS";
                    n3 = 6;
                    continue block22;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = ": PboYS";
                    n3 = 7;
                    continue block22;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u0001\u0004~y%\r\u0005f%?\u001c\u001f=>8\u001c\u0003a97\u0004H`'3\u000bHA\u0011\u0015]_\"b\u0013+6a> \t\u0012v\u001c3\u0011#}49\f\u0003w\u001c3\u00115c25";
                    n3 = 8;
                    continue block22;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u0002\u0007e6x\u001b\u0003p\"$\u0001\u0012jy%\u0018\u0003py\u000e]V*\u00128\u000b\tw22#\u0003j\u0004&\r\u0005";
                    n3 = 9;
                    continue block22;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "!\br'&\u001a\tc%?\t\u0012vw=\r\u001f3$&\r\u0005z1?\u000b\u0007g>9\u0006";
                    n3 = 10;
                    continue block22;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "=\b`\"&\u0018\ta#3\fFx2/H\u0015c25\u0001\u0000z47\u001c\u000f|9lH";
                    n3 = 11;
                    continue block22;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u0002\u0007e6x\u001b\u0003p\"$\u0001\u0012jy%\u0018\u0003py\u0006#%@o\u0013\u0006\u0005|33\f-v.\u0005\u0018\u0003p";
                    n3 = 12;
                    continue block22;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "=\b`\"&\u0018\ta#3\fFx2/H\u0015c25\u0001\u0000z47\u001c\u000f|9";
                    n3 = 13;
                    continue block22;
                }
                case 13: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

