/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.DSAPrivateKey;
import com.ibm.crypto.provider.DSAPublicKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class DSAKeyFactory
extends KeyFactorySpi {
    private static final String[] z;

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DSAPrivateKeySpec) {
                DSAPrivateKeySpec dSAPrivateKeySpec = (DSAPrivateKeySpec)keySpec;
                BigInteger bigInteger = dSAPrivateKeySpec.getP();
                BigInteger bigInteger2 = dSAPrivateKeySpec.getQ();
                BigInteger bigInteger3 = dSAPrivateKeySpec.getG();
                BigInteger bigInteger4 = dSAPrivateKeySpec.getX();
                try {
                    return new DSAPrivateKey(bigInteger4, bigInteger, bigInteger2, bigInteger3);
                }
                catch (Exception exception) {
                    throw new InvalidKeySpecException(z[14]);
                }
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return new DSAPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException(z[13]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(z[15] + invalidKeyException);
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DSAPublicKeySpec) {
                DSAPublicKeySpec dSAPublicKeySpec = (DSAPublicKeySpec)keySpec;
                BigInteger bigInteger = dSAPublicKeySpec.getP();
                BigInteger bigInteger2 = dSAPublicKeySpec.getQ();
                BigInteger bigInteger3 = dSAPublicKeySpec.getG();
                BigInteger bigInteger4 = dSAPublicKeySpec.getY();
                try {
                    return new DSAPublicKey(bigInteger4, bigInteger, bigInteger2, bigInteger3);
                }
                catch (Exception exception) {
                    throw new InvalidKeySpecException(z[1]);
                }
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new DSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException(z[2]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(z[0] + invalidKeyException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        Class<T> clazz2;
        try {
            if (key instanceof java.security.interfaces.DSAPublicKey) {
                clazz2 = Class.forName(z[4]);
                Class<T> clazz3 = Class.forName(z[6]);
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.DSAPublicKey dSAPublicKey = (java.security.interfaces.DSAPublicKey)key;
                    DSAParams dSAParams = dSAPublicKey.getParams();
                    return (T)((KeySpec)clazz.cast(new DSAPublicKeySpec(dSAPublicKey.getY(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG())));
                }
                if (!clazz3.isAssignableFrom(clazz)) throw new InvalidKeySpecException(z[8]);
                return (T)((KeySpec)clazz.cast(new X509EncodedKeySpec(key.getEncoded())));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException(z[5] + classNotFoundException.getMessage());
        }
        {
            if (!(key instanceof java.security.interfaces.DSAPrivateKey)) throw new InvalidKeySpecException(z[9]);
            clazz2 = Class.forName(z[3]);
            Class<T> clazz4 = Class.forName(z[7]);
            if (clazz2.isAssignableFrom(clazz)) {
                java.security.interfaces.DSAPrivateKey dSAPrivateKey = (java.security.interfaces.DSAPrivateKey)key;
                DSAParams dSAParams = dSAPrivateKey.getParams();
                return (T)((KeySpec)clazz.cast(new DSAPrivateKeySpec(dSAPrivateKey.getX(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG())));
            }
            if (!clazz4.isAssignableFrom(clazz)) throw new InvalidKeySpecException(z[10]);
            return (T)((KeySpec)clazz.cast(new PKCS8EncodedKeySpec(key.getEncoded())));
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            block8: {
                block9: {
                    block6: {
                        block7: {
                            if (!(key instanceof java.security.interfaces.DSAPublicKey)) break block6;
                            if (!(key instanceof DSAPublicKey)) break block7;
                            return key;
                        }
                        DSAPublicKeySpec dSAPublicKeySpec = this.engineGetKeySpec(key, DSAPublicKeySpec.class);
                        return this.engineGeneratePublic(dSAPublicKeySpec);
                    }
                    if (!(key instanceof java.security.interfaces.DSAPrivateKey)) break block8;
                    if (!(key instanceof DSAPrivateKey)) break block9;
                    return key;
                }
                DSAPrivateKeySpec dSAPrivateKeySpec = this.engineGetKeySpec(key, DSAPrivateKeySpec.class);
                return this.engineGeneratePrivate(dSAPrivateKeySpec);
            }
            throw new InvalidKeyException(z[11]);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(z[12] + invalidKeySpecException.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[16];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0012\u001c1\u0014\u001a2\u0016g\u001e\u0013\"R4\u0005\u00138Hg";
        int n3 = -1;
        block23: while (true) {
            char[] cArray;
            block27: {
                int n4;
                int n5;
                block26: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block26;
                    n5 = n5;
                    if (n5 <= n4) break block27;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 91;
                            break;
                        }
                        case 1: {
                            n6 = 114;
                            break;
                        }
                        case 2: {
                            n6 = 71;
                            break;
                        }
                        case 3: {
                            n6 = 117;
                            break;
                        }
                        default: {
                            n6 = 118;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0012\u001c1\u0014\u001a2\u0016g\u001e\u0013\"R4\u0005\u00138";
                    n3 = 0;
                    continue block23;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0012\u001c1\u0014\u001a2\u0016g\u001e\u0013\"R4\u0005\u00138";
                    n3 = 1;
                    continue block23;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "1\u00131\u0014X(\u0017$\u0000\u00042\u0006>[\u0005+\u0017$[2\b3\u0017\u0007\u001f-\u00133\u0010=>\u000b\u0014\u0005\u00138";
                    n3 = 2;
                    continue block23;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "1\u00131\u0014X(\u0017$\u0000\u00042\u0006>[\u0005+\u0017$[2\b3\u0017\u0000\u00147\u001b$>\u0013\"!7\u0010\u0015";
                    n3 = 3;
                    continue block23;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u000e\u001c4\u0000\u0006+\u001d5\u0001\u0013?R,\u0010\u000f{\u00017\u0010\u00152\u0014.\u0016\u0017/\u001b(\u001bL{";
                    n3 = 4;
                    continue block23;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "1\u00131\u0014X(\u0017$\u0000\u00042\u0006>[\u0005+\u0017$[.nB~0\u00188\u001d#\u0010\u0012\u0010\u0017>&\u0006>\u0011";
                    n3 = 5;
                    continue block23;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "1\u00131\u0014X(\u0017$\u0000\u00042\u0006>[\u0005+\u0017$[&\u00101\u0014M35\u0011(\u0011\u0013?9\"\f%+\u0017$";
                    n3 = 6;
                    continue block23;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u0012\u001c&\u0005\u0006)\u001d7\u0007\u001f:\u0006\"U\u001d>\u000bg\u0006\u0006>\u0011.\u0013\u001f8\u00133\u001c\u00195";
                    n3 = 7;
                    continue block23;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u0012\u001c&\u0005\u0006)\u001d7\u0007\u001f:\u0006\"U\u001d>\u000bg\u0001\u000f+\u0017";
                    n3 = 8;
                    continue block23;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u0012\u001c&\u0005\u0006)\u001d7\u0007\u001f:\u0006\"U\u001d>\u000bg\u0006\u0006>\u0011.\u0013\u001f8\u00133\u001c\u00195";
                    n3 = 9;
                    continue block23;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\f\u0000(\u001b\u0011{\u0013+\u0012\u0019)\u001b3\u001d\u001b{\u0006>\u0005\u0013";
                    n3 = 10;
                    continue block23;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\u0018\u0013)\u001b\u0019/R3\u0007\u00175\u0001+\u0014\u0002>R,\u0010\u000faR";
                    n3 = 11;
                    continue block23;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u0012\u001c1\u0014\u001a2\u0016g\u001e\u0013\"R4\u0005\u00138";
                    n3 = 12;
                    continue block23;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\u0012\u001c1\u0014\u001a2\u0016g\u001e\u0013\"R4\u0005\u00138";
                    n3 = 13;
                    continue block23;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "\u0012\u001c1\u0014\u001a2\u0016g\u001e\u0013\"R4\u0005\u00138Hg";
                    n3 = 14;
                    continue block23;
                }
                case 14: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

