/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.FileHeader;
import com.ibm.security.cmskeystore.FileHeaderHashGenerator;
import com.ibm.security.cmskeystore.FileHeaderHashGeneratorFactory$1;
import com.ibm.security.cmskeystore.NonPrintableAsciiPBEKey;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.PBEKeySpec;

final class FileHeaderHashGeneratorFactory$FileHeaderHashGeneratorV6Impl
implements FileHeaderHashGenerator {
    private FileHeaderHashGeneratorFactory$FileHeaderHashGeneratorV6Impl() {
    }

    public ByteSequence generateHash(FileHeader fileHeader, String string) throws NullPointerException, NoSuchAlgorithmException {
        if (fileHeader == null || string == null) {
            throw new NullPointerException();
        }
        Mac mac = Mac.getInstance("HmacSHA384");
        try {
            mac.init(new NonPrintableAsciiPBEKey(new PBEKeySpec(string.toCharArray())));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException);
        }
        ByteSequenceIterator byteSequenceIterator = fileHeader.getMagicNumber().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getMajorVersionNumber().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getMinorVersionNumber().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getPasswordExpirationTime().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getFileType().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getFixedRecordLength().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getRecordsAllocated().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getFileLabel().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byte[] byArray = mac.doFinal();
        return ByteSequenceFactory.newByteSequence(byArray);
    }

    FileHeaderHashGeneratorFactory$FileHeaderHashGeneratorV6Impl(FileHeaderHashGeneratorFactory$1 fileHeaderHashGeneratorFactory$1) {
        this();
    }
}

