/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.HostAddresses;
import com.ibm.security.krb5.KDCOptions;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.Realm;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.krb5.internal.Ticket;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;

public class KDCReqBody {
    private KDCOptions a;
    private PrincipalName b;
    private PrincipalName c;
    private KerberosTime d;
    private KerberosTime e;
    private KerberosTime f;
    private int g;
    public int[] eType;
    private HostAddresses h;
    private EncryptedData i;
    public Ticket[] additionalTickets;
    private static final String[] z;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KDCReqBody(KDCOptions kDCOptions, PrincipalName principalName, PrincipalName principalName2, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int n2, int[] nArray, HostAddresses hostAddresses, EncryptedData encryptedData, Ticket[] ticketArray) throws IOException {
        this.a = kDCOptions;
        this.b = principalName;
        this.c = principalName2;
        this.d = kerberosTime;
        this.e = kerberosTime2;
        this.f = kerberosTime3;
        this.g = n2;
        if (nArray != null) {
            this.eType = (int[])nArray.clone();
        }
        this.h = hostAddresses;
        this.i = encryptedData;
        if (ticketArray != null) {
            this.additionalTickets = new Ticket[ticketArray.length];
            for (int n3 = 0; n3 < ticketArray.length; ++n3) {
                if (ticketArray[n3] == null) {
                    throw new IOException(z[1]);
                }
                this.additionalTickets[n3] = (Ticket)ticketArray[n3].clone();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KDCReqBody(DerValue derValue, int n2) throws Asn1Exception, RealmException, KrbException, IOException {
        this.h = null;
        this.i = null;
        this.additionalTickets = null;
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.a = KDCOptions.parse(derValue.getData(), (byte)0, false);
        this.b = PrincipalName.parse(derValue.getData(), (byte)1, true, new Realm(z[0]));
        if (n2 != 10 && this.b != null) {
            throw new Asn1Exception(906);
        }
        Realm realm = Realm.parse(derValue.getData(), (byte)2, false);
        if (this.b != null) {
            this.b = new PrincipalName(this.b.getNameType(), this.b.getNameStrings(), realm);
        }
        this.c = PrincipalName.parse(derValue.getData(), (byte)3, true, realm);
        this.d = KerberosTime.parse(derValue.getData(), (byte)4, true);
        this.e = KerberosTime.parse(derValue.getData(), (byte)5, false);
        this.f = KerberosTime.parse(derValue.getData(), (byte)6, true);
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 7) {
            throw new Asn1Exception(906);
        }
        this.g = derValue2.getData().getBigInteger().intValue();
        derValue2 = derValue.getData().getDerValue();
        Vector<Integer> vector = new Vector<Integer>();
        if ((derValue2.getTag() & 0x1F) != 8) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if (derValue3.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        while (derValue3.getData().available() > 0) {
            vector.addElement(new Integer(derValue3.getData().getBigInteger().intValue()));
        }
        this.eType = new int[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            this.eType[i2] = (Integer)vector.elementAt(i2);
        }
        if (derValue.getData().available() > 0) {
            this.h = HostAddresses.parse(derValue.getData(), (byte)9, true);
        }
        if (derValue.getData().available() > 0) {
            this.i = EncryptedData.parse(derValue.getData(), (byte)10, true);
        }
        if (derValue.getData().available() > 0) {
            Vector<Ticket> vector2 = new Vector<Ticket>();
            derValue2 = derValue.getData().getDerValue();
            if ((derValue2.getTag() & 0x1F) != 11) {
                throw new Asn1Exception(906);
            }
            derValue3 = derValue2.getData().getDerValue();
            if (derValue3.getTag() != 48) {
                throw new Asn1Exception(906);
            }
            while (derValue3.getData().available() > 0) {
                vector2.addElement(new Ticket(derValue3.getData().getDerValue()));
            }
            if (vector2.size() > 0) {
                this.additionalTickets = new Ticket[vector2.size()];
                vector2.copyInto(this.additionalTickets);
            }
        }
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] asn1Encode(int n2) throws Asn1Exception, IOException {
        DerOutputStream derOutputStream;
        Vector<DerValue> vector = new Vector<DerValue>();
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), this.a.asn1Encode()));
        if (n2 == 10 && this.b != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), this.b.asn1Encode()));
        }
        if (this.c != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.c.getRealm().asn1Encode()));
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)3), this.c.asn1Encode()));
        } else if (this.b != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.b.getRealm().asn1Encode()));
        }
        if (this.d != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.d.asn1Encode()));
        }
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)5), this.e.asn1Encode()));
        if (this.f != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)6), this.f.asn1Encode()));
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.g);
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)7), derOutputStream2.toByteArray()));
        derOutputStream2 = new DerOutputStream();
        for (int i2 = 0; i2 < this.eType.length; ++i2) {
            derOutputStream2.putInteger(BigInteger.valueOf(this.eType[i2]));
        }
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream2);
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)8), derOutputStream3.toByteArray()));
        if (this.h != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)9), this.h.asn1Encode()));
        }
        if (this.i != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)10), this.i.asn1Encode()));
        }
        if (this.additionalTickets != null && this.additionalTickets.length > 0) {
            derOutputStream2 = new DerOutputStream();
            for (int i3 = 0; i3 < this.additionalTickets.length; ++i3) {
                derOutputStream2.write(this.additionalTickets[i3].asn1Encode());
            }
            derOutputStream = new DerOutputStream();
            derOutputStream.write((byte)48, derOutputStream2);
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)11), derOutputStream.toByteArray()));
        }
        derOutputStream = new DerValue[vector.size()];
        vector.copyInto((Object[])derOutputStream);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putSequence((DerValue[])derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public void setClient(PrincipalName principalName) {
        this.b = principalName;
    }

    public void setServer(PrincipalName principalName) {
        this.c = principalName;
    }

    public Ticket[] getAdditionalTickets() {
        return this.additionalTickets;
    }

    public EncryptedData getEncryptedAuthzData() {
        return this.i;
    }

    public PrincipalName getClient() {
        return this.b;
    }

    public PrincipalName getServer() {
        return this.c;
    }

    public int getNonce() {
        return this.g;
    }

    public KDCOptions getOptions() {
        return this.a;
    }

    public KerberosTime getStartTime() {
        return this.d;
    }

    public KerberosTime getEndTime() {
        return this.e;
    }

    public KerberosTime getRenewableTillTime() {
        return this.f;
    }

    public int[] getEtypes() {
        return this.eType;
    }

    public HostAddresses getAddresses() {
        return this.h;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0000~|'\u000b\u0018}q \u000b\u0002";
        int n3 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block13;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 80;
                                break;
                            }
                            case 1: {
                                n9 = 50;
                                break;
                            }
                            case 2: {
                                n9 = 61;
                                break;
                            }
                            case 3: {
                                n9 = 100;
                                break;
                            }
                            default: {
                                n9 = 78;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0013SS\n!$\u0012^\u0016+1FXD/pyy'\u001c5C\u007f\u000b*)";
                    n3 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

