/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class HostAddress
implements Cloneable {
    public int addrType;
    public byte[] address;
    private static byte[] a;
    private static final String[] z;

    private HostAddress(int n2) {
    }

    public Object clone() {
        HostAddress hostAddress = new HostAddress(0);
        hostAddress.addrType = this.addrType;
        if (this.address != null) {
            hostAddress.address = new byte[this.address.length];
            System.arraycopy(this.address, 0, hostAddress.address, 0, this.address.length);
        }
        return hostAddress;
    }

    public boolean equals(HostAddress hostAddress) {
        if (this.addrType != hostAddress.addrType || this.address != null && hostAddress.address == null || this.address == null && hostAddress.address != null) {
            return false;
        }
        if (this.address != null && hostAddress.address != null) {
            if (this.address.length != hostAddress.address.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.address.length; ++i2) {
                if (this.address[i2] == hostAddress.address[i2]) continue;
                return false;
            }
        }
        return true;
    }

    public static void refreshLocalInetAddress() throws UnknownHostException {
        a = InetAddress.getLocalHost().getAddress();
    }

    public static byte[] getLocalInetAddress() throws UnknownHostException {
        if (a == null) {
            HostAddress.refreshLocalInetAddress();
        }
        if (a == null) {
            throw new UnknownHostException();
        }
        byte[] byArray = new byte[a.length];
        System.arraycopy(a, 0, byArray, 0, a.length);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InetAddress getInetAddress() throws UnknownHostException {
        if (this.addrType != 2 && this.addrType != 24) {
            return null;
        }
        return InetAddress.getByAddress(this.address);
    }

    private int a(InetAddress inetAddress) {
        int n2 = 0;
        if (inetAddress instanceof Inet4Address) {
            n2 = 2;
        } else if (inetAddress instanceof Inet6Address) {
            n2 = 24;
        }
        return n2;
    }

    public HostAddress() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByAddress(HostAddress.getLocalInetAddress());
        this.addrType = this.a(inetAddress);
        this.address = inetAddress.getAddress();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HostAddress(int n2, byte[] byArray) throws KrbApErrException {
        switch (n2) {
            case 2: {
                if (byArray.length == 4) break;
                throw new KrbApErrException(0, z[1]);
            }
            case 5: {
                if (byArray.length == 2) break;
                throw new KrbApErrException(0, z[2]);
            }
            case 7: {
                break;
            }
            case 6: {
                if (byArray.length == 6) break;
                throw new KrbApErrException(0, z[5]);
            }
            case 16: {
                if (byArray.length == 3) break;
                throw new KrbApErrException(0, z[4]);
            }
            case 12: {
                if (byArray.length == 2) break;
                throw new KrbApErrException(0, z[6]);
            }
            case 24: {
                if (byArray.length == 16) break;
                throw new KrbApErrException(0, z[3]);
            }
        }
        this.addrType = n2;
        this.address = byArray;
        if (Krb5Debug.on(5) && this.addrType == 2) {
            Krb5Debug krb5Debug = new Krb5Debug(z[8] + Thread.currentThread().getName() + z[7]);
            krb5Debug.out(5, z[0] + (this.address[0] & 0xFF) + "." + (this.address[1] & 0xFF) + "." + (this.address[2] & 0xFF) + "." + (this.address[3] & 0xFF));
        }
    }

    public HostAddress(InetAddress inetAddress) {
        this.addrType = this.a(inetAddress);
        byte[] byArray = inetAddress.getAddress();
        this.address = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.address, 0, byArray.length);
    }

    public HostAddress(DerValue derValue) throws Asn1Exception, IOException {
        block10: {
            block9: {
                DerValue derValue2;
                block8: {
                    block7: {
                        derValue2 = derValue.getData().getDerValue();
                        if ((derValue2.getTag() & 0x1F) != 0) break block7;
                        this.addrType = derValue2.getData().getBigInteger().intValue();
                        break block8;
                    }
                    throw new Asn1Exception(906);
                }
                derValue2 = derValue.getData().getDerValue();
                if ((derValue2.getTag() & 0x1F) != 1) break block9;
                this.address = derValue2.getData().getOctetString();
                break block10;
            }
            throw new Asn1Exception(906);
        }
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.addrType);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.address);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HostAddress parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new HostAddress(derValue2);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[9];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "w&[.1^-L(tL:\b3b\u001f";
        int n3 = -1;
        block16: while (true) {
            char[] cArray;
            block21: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block20: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block20;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block21;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 63;
                                break;
                            }
                            case 1: {
                                n9 = 73;
                                break;
                            }
                            case 2: {
                                n9 = 40;
                                break;
                            }
                            case 3: {
                                n9 = 90;
                                break;
                            }
                            default: {
                                n9 = 17;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "}(L\u0013\u007fZ=i>uM,[)";
                    n3 = 0;
                    continue block16;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "}(L\u0019Y~\u0006{\u001bu[;M)b";
                    n3 = 1;
                    continue block16;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "}(L\u0013AI\u007fa4tK\bL>cZ:[";
                    n3 = 2;
                    continue block16;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "}(L\u001eUo\bL>cZ:[";
                    n3 = 3;
                    continue block16;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "}(L\u0002_l\bL>cZ:[";
                    n3 = 4;
                    continue block16;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "}(L\u001eT|\u0007M.P[-Z?bL";
                    n3 = 5;
                    continue block16;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u0005i";
                    n3 = 6;
                    continue block16;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "|&F<xXs";
                    n3 = 7;
                    continue block16;
                }
                case 7: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

