/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui;

import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.gui.CenteredDialog;
import com.ibm.gsk.ikeyman.gui.GUIConstants$Actions;
import com.ibm.gsk.ikeyman.gui.GUIConstants$DialogResult;
import com.ibm.gsk.ikeyman.gui.panels.CheckBoxTree;
import com.ibm.gsk.ikeyman.gui.panels.OKResetCancelButtonPanel;
import com.ibm.gsk.ikeyman.keystore.ext.CACertificates;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree$KeymanTreeNode;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SignerSelectDialog
extends CenteredDialog {
    private static final String COLLECTION_DELIMITER = ",";
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane scrollPane = null;
    private CheckBoxTree checkBoxTree = null;
    private JLabel jLabel = null;
    private OKResetCancelButtonPanel oKResetCancelButtonPanel = null;
    private KeymanTree tree;

    public SignerSelectDialog(Frame frame) {
        super(frame);
        this.initialize();
    }

    public SignerSelectDialog(Frame frame, KeymanTree keymanTree) {
        super(frame);
        this.tree = keymanTree;
        this.initialize();
    }

    private void initialize() {
        this.setSize(450, 550);
        this.centerToParent();
        this.setModal(true);
        this.setTitle(Messages.getString("GUI.Title.SelectSigners"));
        this.setContentPane(this.getJContentPane());
        this.setName(ControlNames.SignerSelectDialog.toString());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(0, 0, 5, 0);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints2.gridx = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText(Messages.getString("Label.SignerCertificatesSelect"));
            this.jLabel.setName(ControlNames.SignerSelectDialogSelectSignerLabel.toString());
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints3.gridy = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getScrollPane(), gridBagConstraints3);
            this.jContentPane.add((Component)this.jLabel, gridBagConstraints2);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints);
        }
        return this.jContentPane;
    }

    private CheckBoxTree getCheckBoxTree() {
        if (this.checkBoxTree == null) {
            this.checkBoxTree = new CheckBoxTree(this.tree);
            this.checkBoxTree.getAccessibleContext().setAccessibleDescription(Messages.getString("Label.SignerCertificatesSelect"));
        }
        return this.checkBoxTree;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.getCheckBoxTree());
        }
        return this.scrollPane;
    }

    private OKResetCancelButtonPanel getButtonPanel() {
        if (this.oKResetCancelButtonPanel == null) {
            this.oKResetCancelButtonPanel = new OKResetCancelButtonPanel(new GUIConstants$Actions[]{GUIConstants$Actions.OK, GUIConstants$Actions.Cancel, GUIConstants$Actions.Reset});
            this.oKResetCancelButtonPanel.addActionListener(this);
        }
        return this.oKResetCancelButtonPanel;
    }

    protected void okHandler() {
        this.setDialogResult(GUIConstants$DialogResult.OK);
        this.setVisible(false);
    }

    protected void resetHandler() {
        this.resetFields();
    }

    private void resetFields() {
        this.checkBoxTree.resetFields();
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
        KeymanTree keymanTree = new KeymanTree(KeymanTree.newNode("Root"));
        KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode = (KeymanTree$KeymanTreeNode)keymanTree.getRoot();
        KeymanTree$KeymanTreeNode[] keymanTree$KeymanTreeNodeArray = new KeymanTree$KeymanTreeNode[5];
        for (int i = 0; i < keymanTree$KeymanTreeNodeArray.length; ++i) {
            object2 = keymanTree$KeymanTreeNode.addChild(KeymanTree.newNode("child " + i, false));
            for (int j = 0; j < 5; ++j) {
                object = ((KeymanTree$KeymanTreeNode)object2).addChild(KeymanTree.newNode("child " + i + "'s child " + j, false));
                ((KeymanTree$KeymanTreeNode)object).addChild(KeymanTree.newNode("child " + i + "'s child " + j + "'s child 1", false));
                ((KeymanTree$KeymanTreeNode)object).addChild(KeymanTree.newNode("child " + i + "'s child " + j + "'s child 2", false));
                ((KeymanTree$KeymanTreeNode)object).addChild(KeymanTree.newNode("child " + i + "'s child " + j + "'s child 3", false));
            }
        }
        SignerSelectDialog signerSelectDialog = new SignerSelectDialog((Frame)jFrame, keymanTree);
        signerSelectDialog.setVisible(true);
        object2 = signerSelectDialog.checkBoxTree.getSelectedLeaves();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            System.out.println((String)object);
        }
    }

    private ParameterMap getParameters() throws KeyManagerException {
        Collection collection = this.checkBoxTree.getSelectedLeaves();
        if (collection.size() == 0) {
            throw new CancelledException();
        }
        ParameterMap parameterMap = new ParameterMap();
        parameterMap.put(Constants$Parameter.Label, SignerSelectDialog.collectionToString(collection));
        return parameterMap;
    }

    public static String collectionToString(Collection collection) {
        if (collection.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : collection) {
            stringBuffer.append(string).append(COLLECTION_DELIMITER);
        }
        return stringBuffer.toString().substring(0, stringBuffer.length() - COLLECTION_DELIMITER.length());
    }

    public static ParameterMap getData(Frame frame) throws KeyManagerException {
        SignerSelectDialog signerSelectDialog = new SignerSelectDialog(frame, CACertificates.getCertificateTree());
        try {
            signerSelectDialog.setVisible(true);
            if (signerSelectDialog.getDialogResult() == GUIConstants$DialogResult.OK) {
                ParameterMap parameterMap = signerSelectDialog.getParameters();
                return parameterMap;
            }
            throw new CancelledException();
        }
        finally {
            signerSelectDialog.dispose();
        }
    }
}

