/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui;

import com.ibm.gsk.ikeyman.command.LabelMap;
import com.ibm.gsk.ikeyman.command.gui.KeymanView;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.gui.CenteredDialog;
import com.ibm.gsk.ikeyman.gui.ChangeLabelsDialog;
import com.ibm.gsk.ikeyman.gui.GUIConstants$Actions;
import com.ibm.gsk.ikeyman.gui.GUIConstants$DialogResult;
import com.ibm.gsk.ikeyman.gui.controls.MnemonicLabel;
import com.ibm.gsk.ikeyman.gui.panels.OKResetCancelButtonPanel;
import com.ibm.gsk.ikeyman.gui.panels.OKResetCancelButtonPanel$Orientation;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class KeySelectDialog
extends CenteredDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private JScrollPane jScrollPane = null;
    private JList keyList = null;
    private OKResetCancelButtonPanel buttonPanel = null;
    private Collection keyStoreEntries;
    private boolean allowMultiSelect;
    private String[] selectedLabels = null;

    protected KeySelectDialog(Frame frame) {
        super(frame);
        this.initialize();
    }

    public KeySelectDialog(Frame frame, String string, Collection collection, boolean bl) {
        super(frame, MessageFormat.format(Messages.getString("GUI.Title.KeySelect"), string));
        this.keyStoreEntries = collection;
        this.allowMultiSelect = bl;
        this.initialize();
    }

    public static String getSingleSelection(Frame frame, String string, Collection collection) throws CancelledException {
        KeySelectDialog keySelectDialog = new KeySelectDialog(frame, string, collection, false);
        keySelectDialog.setVisible(true);
        if (keySelectDialog.getDialogResult() == GUIConstants$DialogResult.OK) {
            return keySelectDialog.getSelectedLabels()[0];
        }
        throw new CancelledException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LabelMap getLabelMap(KeymanView keymanView, Frame frame, String string, Collection collection, boolean bl) throws CancelledException, KeyManagerException {
        String[] stringArray;
        Object object;
        if (collection.size() > 1) {
            object = new KeySelectDialog(frame, string, collection, true);
            ((Dialog)object).setVisible(true);
            if (((CenteredDialog)object).getDialogResult() != GUIConstants$DialogResult.OK) throw new CancelledException();
            stringArray = super.getSelectedLabels();
        } else {
            if (collection.size() == 0) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.SOURCE_DB_IS_EMPTY);
            }
            object = collection.toArray(new Entry[0])[0].getLabel();
            stringArray = new String[]{object};
        }
        if (!bl || stringArray.length != 1) return ChangeLabelsDialog.getLabelMap(frame, stringArray);
        object = keymanView.getInput(Messages.getString("Label.EnterLabelForCert"), Messages.getString("GUI.Title.EnterLabel"), "");
        LabelMap labelMap = new LabelMap();
        labelMap.add(stringArray[0], (String)object);
        return labelMap;
    }

    public static LabelMap getLabelMap(Frame frame, LabelMap labelMap) {
        return ChangeLabelsDialog.getLabelMap(frame, labelMap);
    }

    private String[] getSelectedLabels() {
        return this.selectedLabels;
    }

    private void initialize() {
        this.setSize(549, 533);
        this.setModal(true);
        this.setResizable(false);
        this.setContentPane(this.getJContentPane());
        this.getRootPane().setDefaultButton(this.getButtonPanel().getOkBtn());
        this.pack();
        this.setName(ControlNames.KeySelectDialog.toString());
        this.centerToParent();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.insets = new Insets(10, 20, 0, 5);
            gridBagConstraints.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(0, 5, 5, 10);
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(10, 5, 10, 0);
            gridBagConstraints3.gridx = 0;
            this.jLabel = new MnemonicLabel();
            if (this.allowMultiSelect) {
                this.jLabel.setText(Messages.getStringWithMnemonics("Label.SelectKeys"));
            } else {
                this.jLabel.setText(Messages.getStringWithMnemonics("Label.SelectKey"));
            }
            this.jLabel.setName(ControlNames.KeySelectDialogSelectLabel.toString());
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.jLabel, gridBagConstraints3);
            this.jContentPane.add((Component)this.getJScrollPane(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints);
            this.jLabel.setLabelFor(this.getKeyList());
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getKeyList());
        }
        return this.jScrollPane;
    }

    private JList getKeyList() {
        if (this.keyList == null) {
            this.keyList = this.keyStoreEntries != null ? new JList<Entry>(this.keyStoreEntries.toArray(new Entry[0])) : new JList();
            if (this.allowMultiSelect) {
                this.keyList.setSelectionMode(2);
            } else {
                this.keyList.setSelectionMode(0);
            }
            this.keyList.setVisibleRowCount(20);
        }
        return this.keyList;
    }

    private OKResetCancelButtonPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new OKResetCancelButtonPanel(OKResetCancelButtonPanel$Orientation.Vertical, new GUIConstants$Actions[]{GUIConstants$Actions.OK, GUIConstants$Actions.Cancel});
            this.buttonPanel.addActionListener(this);
        }
        return this.buttonPanel;
    }

    protected void okHandler() {
        if (this.keyList.getSelectedValues().length > 0) {
            Object[] objectArray = this.keyList.getSelectedValues();
            this.selectedLabels = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                this.selectedLabels[i] = ((Entry)objectArray[i]).getLabel();
            }
            this.setDialogResult(GUIConstants$DialogResult.OK);
            this.setVisible(false);
        }
    }

    protected void resetHandler() {
    }
}

