/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.certrequest.cmscertrequest;

import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.Buffer;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.IntableByteSequenceFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordEncoding;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordEncodingFactory$RequestRecordEncodingImpl;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.VersionNumber;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceFactory;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.security.cmskeystore.NonPrintableAsciiEncryptDecrypt;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;

final class RequestRecordEncodingFactory {
    private RequestRecordEncodingFactory() {
        throw new UnsupportedOperationException();
    }

    public static RequestRecordEncoding newRequestRecordEncoding(Buffer buffer) throws IOException {
        return new RequestRecordEncodingFactory$RequestRecordEncodingImpl(buffer);
    }

    public static RequestRecordEncoding newRequestRecordEncoding(int n, CertificationRequest certificationRequest, PrivateKey privateKey, char[] cArray, String string, VersionNumber versionNumber) throws IOException, PKCSException, NoSuchAlgorithmException {
        Object object;
        PrivateKeyInfo privateKeyInfo;
        String string2;
        String string3;
        String string4;
        byte[] byArray = null;
        if (versionNumber != VersionNumber.SIX) {
            String string5;
            if (KeymanUtil.isIBMJCE()) {
                string5 = "PBEWithSHAAnd3KeyTripleDES";
                string4 = "3KeyTripleDES";
            } else {
                string5 = "PBEWithSHA1AndDESede";
                string4 = "DESede";
            }
            string3 = "SHA1";
            string2 = string5;
        } else {
            String string6 = "PBEWithHmacSHA384AndAES_256";
            string4 = "AES_256";
            string3 = "HmacSHA384";
            string2 = "PBES2";
        }
        if (RequestRecordEncodingFactory.isPrintable(cArray)) {
            privateKeyInfo = new PrivateKeyInfo(privateKey.getEncoded());
            object = new EncryptedPrivateKeyInfo(cArray, privateKeyInfo, string3, string4);
            byArray = object.encode();
        } else {
            byArray = NonPrintableAsciiEncryptDecrypt.encrypt((char[])cArray, (PrivateKey)privateKey, (AlgorithmId)AlgorithmId.get((String)string2));
        }
        privateKeyInfo = new DerOutputStream();
        privateKeyInfo.putSequence(new DerValue[]{new DerValue(certificationRequest.encode()), new DerValue(byArray)});
        object = privateKeyInfo.toByteArray();
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(n);
        derOutputStream.putTag((byte)-128, true, (byte)0);
        derOutputStream.putLength(((EncryptedPrivateKeyInfo)object).length);
        derOutputStream.write((byte[])object);
        derOutputStream.putVisibleString(string);
        derOutputStream.write(3);
        derOutputStream.putLength(1);
        derOutputStream.write(new byte[]{0});
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return new RequestRecordEncodingFactory$RequestRecordEncodingImpl(IntableByteSequenceFactory.newIntableByteSequence(derOutputStream2.size()), ByteSequenceFactory.newByteSequence(derOutputStream2.toByteArray()));
    }

    private static boolean isPrintable(char[] cArray) {
        for (char c : cArray) {
            if (c >= ' ' && c <= '~') continue;
            return false;
        }
        return true;
    }

    static boolean access$000(char[] cArray) {
        return RequestRecordEncodingFactory.isPrintable(cArray);
    }
}

