/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.certrequest.cmscertrequest;

import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.FileHeader;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestDatabase;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestDatabaseHashGenerator;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestDatabaseHashGeneratorFactory$1;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecord;
import com.ibm.gsk.ikeyman.sequence.Sequence;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequence;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceFactory;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceIterator;
import com.ibm.security.cmskeystore.NonPrintableAsciiPBEKey;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.KeySpec;
import javax.crypto.Mac;
import javax.crypto.spec.PBEKeySpec;

final class RequestDatabaseHashGeneratorFactory$RequestDatabaseHashGeneratorV4Impl
implements RequestDatabaseHashGenerator {
    private RequestDatabaseHashGeneratorFactory$RequestDatabaseHashGeneratorV4Impl() {
    }

    public ByteSequence generateHash(RequestDatabase requestDatabase, String string) throws NullPointerException, NoSuchAlgorithmException, IOException {
        if (requestDatabase == null || string == null) {
            throw new NullPointerException();
        }
        FileHeader fileHeader = requestDatabase.getHeader();
        Sequence sequence = requestDatabase.getRecords();
        Mac mac = Mac.getInstance("HmacSHA1");
        try {
            mac.init((Key)new NonPrintableAsciiPBEKey((KeySpec)new PBEKeySpec(string.toCharArray())));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException);
        }
        ByteSequenceIterator byteSequenceIterator = fileHeader.getMagicNumber().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getMajorVersionNumber().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getMinorVersionNumber().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getPasswordExpirationTime().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getFileType().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getFixedRecordLength().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getRecordsAllocated().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getFileLabel().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        byteSequenceIterator = fileHeader.getPasswordHeaderHash().getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            mac.update(byteSequenceIterator.getNextByte());
        }
        for (RequestRecord requestRecord : sequence) {
            byteSequenceIterator = requestRecord.getIterator();
            while (byteSequenceIterator.hasNextByte()) {
                mac.update(byteSequenceIterator.getNextByte());
            }
        }
        ByteSequence byteSequence = ByteSequenceFactory.newByteSequence(mac.doFinal());
        return byteSequence;
    }

    RequestDatabaseHashGeneratorFactory$RequestDatabaseHashGeneratorV4Impl(RequestDatabaseHashGeneratorFactory$1 requestDatabaseHashGeneratorFactory$1) {
        this();
    }
}

