/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.icc.XECKey;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import ibm.security.internal.interfaces.XECPrivateKey;
import ibm.security.internal.spec.NamedParameterSpec;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyRep;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Optional;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class XDHPrivateKeyImpl
extends PrivateKeyInfo
implements XECPrivateKey,
Serializable,
Destroyable {
    private static final long serialVersionUID = 6034044314589513430L;
    private IBMJCEPlusProvider provider;
    private Optional<byte[]> scalar;
    private NamedParameterSpec params;
    BigInteger bi1;
    BigInteger bi2;
    BigInteger bi3;
    private Exception exception;
    private static final byte TAG_PARAMETERS_ATTRS = 0;
    private transient boolean destroyed;
    private transient XECKey xecKey;
    private static final String[] z;

    private void a() throws Exception {
        if (this.key == null) {
            this.key = this.a(this.xecKey.getPrivateKeyBytes());
            this.scalar = Optional.of(this.key);
            this.algid = XECKey.getAlgId(this.params.getCurve());
        }
    }

    public XDHPrivateKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, XECKey xECKey) throws InvalidKeyException {
        this.provider = null;
        this.exception = null;
        this.destroyed = false;
        this.xecKey = null;
        if (iBMJCEPlusProvider == null) {
            throw new InvalidKeyException(z[16]);
        }
        if (xECKey == null) {
            throw new InvalidKeyException(z[17]);
        }
        this.xecKey = xECKey;
        this.provider = iBMJCEPlusProvider;
        try {
            this.a();
        }
        catch (Exception exception) {
            throw new InvalidKeyException(exception.getMessage());
        }
    }

    public XDHPrivateKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = null;
        this.exception = null;
        this.destroyed = false;
        this.xecKey = null;
        this.provider = iBMJCEPlusProvider;
        try {
            byte[] byArray2 = this.b(byArray);
            this.xecKey = XECKey.createPrivateKey(iBMJCEPlusProvider.a(), byArray2, this.params.getCurve());
            this.scalar = Optional.of(this.key);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[10]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public XDHPrivateKeyImpl(IBMJCEPlusProvider iBMJCEPlusProvider, AlgorithmParameterSpec algorithmParameterSpec, Optional<byte[]> optional) throws InvalidParameterException {
        block15: {
            this.provider = null;
            this.exception = null;
            this.destroyed = false;
            this.xecKey = null;
            if (iBMJCEPlusProvider == null) {
                throw new InvalidParameterException(z[12]);
            }
            if (!(algorithmParameterSpec instanceof NamedParameterSpec)) {
                throw new InvalidParameterException(z[15]);
            }
            this.params = (NamedParameterSpec)algorithmParameterSpec;
            try {
                if (XECKey.isFFDHE(this.params.getCurve())) {
                    throw new InvalidParameterException(z[14]);
                }
            }
            catch (Exception exception) {
                throw new InvalidParameterException(exception.getMessage());
            }
            this.provider = iBMJCEPlusProvider;
            this.scalar = optional;
            if (optional != null) {
                this.key = optional.get();
            }
            try {
                block14: {
                    if (this.key != null) break block14;
                    this.xecKey = XECKey.generateKeyPair(iBMJCEPlusProvider.a(), this.params.getCurve());
                    break block15;
                }
                this.algid = XECKey.getAlgId(this.params.getCurve());
                byte[] byArray = this.b();
                this.xecKey = XECKey.createPrivateKey(iBMJCEPlusProvider.a(), byArray, this.params.getCurve());
            }
            catch (Exception exception) {
                InvalidParameterException invalidParameterException = new InvalidParameterException(z[13]);
                iBMJCEPlusProvider.a(invalidParameterException, (Throwable)exception);
                throw invalidParameterException;
            }
        }
    }

    private byte[] b() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(0);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.algid.getOID());
        derOutputStream.write((byte)48, derOutputStream2.toByteArray());
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.putOctetString(this.key);
        derOutputStream.putOctetString(derOutputStream3.toByteArray());
        DerOutputStream derOutputStream4 = new DerOutputStream();
        derOutputStream4.write((byte)48, derOutputStream);
        return derOutputStream4.toByteArray();
    }

    private byte[] a(byte[] byArray) throws IOException {
        Object object;
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(3);
        DerInputStream derInputStream2 = null;
        if (derValueArray.length > 1) {
            derInputStream2 = derValueArray[1].getData();
            if (derInputStream2.tag != 0) {
                throw new IOException(z[2]);
            }
            try {
                object = this.a(derInputStream2, null);
            }
            catch (Exception exception) {
                throw new IOException(z[3]);
            }
        }
        object = null;
        if (derValueArray.length > 2) {
            object = derValueArray[2].getOctetString();
            object = this.params.getName().contains(z[4]) ? new DerInputStream(object).getInteger().toByteArray() : new DerInputStream(object).getOctetString();
            return object;
        }
        return null;
    }

    private ObjectIdentifier a(DerInputStream derInputStream, DerOutputStream derOutputStream) throws IOException {
        NamedParameterSpec.CURVE cURVE;
        ObjectIdentifier objectIdentifier;
        block5: {
            DerOutputStream derOutputStream2;
            objectIdentifier = derInputStream.getOID();
            XECKey.checkOid(objectIdentifier);
            try {
                derOutputStream2 = derInputStream.getSequence(3);
                if (((DerValue[])derOutputStream2).length < 3) {
                    throw new IOException(z[9]);
                }
                this.bi1 = derOutputStream2[0].getInteger();
                this.bi2 = derOutputStream2[1].getInteger();
                this.bi3 = derOutputStream2[2].getInteger();
                int n2 = this.bi1.bitLength();
                cURVE = XECKey.getCurve(objectIdentifier, n2);
            }
            catch (IOException iOException) {
                cURVE = XECKey.getCurve(objectIdentifier, null);
            }
            if (derOutputStream == null) break block5;
            derOutputStream.putOID(objectIdentifier);
            if (!XECKey.isFFDHE(cURVE)) break block5;
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(this.bi1);
            derOutputStream2.putInteger(this.bi2);
            derOutputStream2.putInteger(this.bi3);
            derOutputStream.write((byte)48, derOutputStream2.toByteArray());
        }
        this.params = new NamedParameterSpec(cURVE);
        return objectIdentifier;
    }

    private byte[] b(byte[] byArray) throws IOException {
        BigInteger bigInteger;
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(3);
        DerOutputStream derOutputStream = new DerOutputStream();
        BigInteger bigInteger2 = derValueArray[0].getInteger();
        derOutputStream.putInteger(bigInteger2);
        Object var6_6 = null;
        ObjectIdentifier objectIdentifier = null;
        if (derValueArray.length < 3) {
            throw new IOException(z[0]);
        }
        if (derValueArray[1].getTag() != 48) {
            throw new IOException(z[1]);
        }
        Object object = derValueArray[1].toDerInputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        objectIdentifier = this.a((DerInputStream)object, derOutputStream2);
        this.algid = new AlgorithmId(objectIdentifier);
        derOutputStream.write((byte)48, derOutputStream2.toByteArray());
        object = derValueArray[2].getOctetString();
        derOutputStream2 = new DerInputStream((byte[])object);
        try {
            this.key = derOutputStream2.getOctetString();
        }
        catch (IOException iOException) {
            this.key = (byte[])object;
        }
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (XECKey.isFFDHE(this.params.getCurve())) {
            bigInteger = new BigInteger(this.key);
            derOutputStream3.putInteger(bigInteger);
        } else {
            derOutputStream3.putOctetString(this.key);
        }
        derOutputStream.putOctetString(derOutputStream3.toByteArray());
        bigInteger = new DerOutputStream();
        bigInteger.write((byte)48, derOutputStream);
        return bigInteger.toByteArray();
    }

    public XECKey getICCKey() {
        return this.xecKey;
    }

    public AlgorithmParameterSpec getParams() {
        return this.params;
    }

    public Optional<byte[]> getScalar() {
        try {
            this.a();
        }
        catch (Exception exception) {
            this.exception = exception;
        }
        return this.scalar;
    }

    public byte[] getKeyBytes() {
        try {
            this.a();
        }
        catch (Exception exception) {
            this.exception = exception;
        }
        return super.getKeyBytes();
    }

    public AlgorithmId getAlgorithmId() {
        try {
            this.a();
        }
        catch (Exception exception) {
            this.exception = exception;
        }
        return super.getAlgorithmId();
    }

    public String getAlgorithm() {
        try {
            this.a();
        }
        catch (Exception exception) {
            this.exception = exception;
        }
        return super.getAlgorithm();
    }

    public static void putFFDHEIntegers(DerOutputStream derOutputStream, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(bigInteger);
        derOutputStream2.putInteger(bigInteger2);
        derOutputStream2.putInteger(bigInteger3);
        derOutputStream.write((byte)48, derOutputStream2.toByteArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void encode(OutputStream outputStream) throws IOException {
        try {
            this.a();
        }
        catch (Exception exception) {
            IOException iOException = new IOException(z[5]);
            this.provider.a(iOException, (Throwable)exception);
            throw iOException;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(0);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        DerOutputStream derOutputStream4 = new DerOutputStream();
        derOutputStream3.putOID(this.algid.getOID());
        switch (this.params.getCurve()) {
            case X25519: {
                derOutputStream3.putNull();
                break;
            }
            case X448: {
                derOutputStream3.putNull();
                break;
            }
            case Ed25519: {
                derOutputStream3.putNull();
                break;
            }
            case Ed448: {
                derOutputStream3.putNull();
                break;
            }
            case FFDHE2048: {
                XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream3, this.bi1, this.bi2, this.bi3);
                break;
            }
            case FFDHE3072: {
                XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream3, this.bi1, this.bi2, this.bi3);
                break;
            }
            case FFDHE4096: {
                XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream3, this.bi1, this.bi2, this.bi3);
                break;
            }
            case FFDHE6144: {
                XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream3, this.bi1, this.bi2, this.bi3);
                break;
            }
            case FFDHE8192: {
                XDHPrivateKeyImpl.putFFDHEIntegers(derOutputStream3, this.bi1, this.bi2, this.bi3);
                break;
            }
        }
        derOutputStream4.write((byte)48, derOutputStream3);
        derOutputStream.write(derOutputStream4.toByteArray());
        if (this.key != null) {
            derOutputStream.putOctetString(this.key);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (this.exception != null) {
            String string = this.exception.getMessage();
            string = string + z[8];
            StackTraceElement[] stackTraceElementArray = this.exception.getStackTrace();
            int n2 = stackTraceElementArray.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    throw new DestroyFailedException(z[6] + string);
                }
                StackTraceElement stackTraceElement = stackTraceElementArray[n3];
                string = string + z[7] + stackTraceElement.toString() + "\n";
                ++n3;
            }
        }
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.xecKey = null;
            this.scalar = null;
            this.params = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void c() {
        if (this.destroyed) {
            throw new IllegalStateException(z[11]);
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[18];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "P9@M]g$[H\u0018$5F[\u000e$?FJ]w4LS]p>\t\\\u0018$0\tH\u001ch8M\u001e%A\u0012\u0006x;@\u0019l\u001e\u001eq#_[";
        int n3 = -1;
        block25: while (true) {
            char[] cArray;
            block29: {
                int n4;
                int n5;
                block28: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block28;
                    n5 = n5;
                    if (n5 <= n4) break block29;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 4;
                            break;
                        }
                        case 1: {
                            n6 = 81;
                            break;
                        }
                        case 2: {
                            n6 = 41;
                            break;
                        }
                        case 3: {
                            n6 = 62;
                            break;
                        }
                        default: {
                            n6 = 125;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "Q?LF\ra2][\u0019$?FP]w4XK\u0018j2L\u001e\nl8E[]t0[M\u0014j6\tN\u000fm'HJ\u0018$:LG]f(][\u000e";
                    n3 = 0;
                    continue block25;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "$\u0005A[]j4QJ]a?JQ\u0019a5\tM\tv$JJ\bv4\tS\bw%\t\\\u0018$0\t]\u0012j%LF\t$2FP\u000ep#\\]\ta5\tq4@";
                    n3 = 1;
                    continue block25;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "P9@M]g$[H\u0018$5F[\u000e$?FJ]w4LS]p>\t\\\u0018$0G\u001e%A\u0012\tQ\u000f$\u0017oz5AqJK\u000fr4";
                    n3 = 2;
                    continue block25;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "B\u0017mv";
                    n3 = 3;
                    continue block25;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "B0@R\u0018`q@P]w4]x\u0014a=MM;v>Df\u0018g:LG";
                    n3 = 4;
                    continue block25;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "E?\t[\u0005g4YJ\u0014k?\tQ\u001eg$[L\u0018`qMK\u000fm?N\u001e\tl4\t[\u0005a2\\J\u0014k?\tQ\u001b$%AW\u000e$>KT\u0018g%\u0013\u001e";
                    n3 = 5;
                    continue block25;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = ")q";
                    n3 = 6;
                    continue block25;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u000e\u0002]_\u001eok#";
                    n3 = 7;
                    continue block25;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "P9@M]g$[H\u0018$5F[\u000e$?FJ]w4LS]p>\t\\\u0018$0\tH\u001ch8M\u001e%A\u0012\u0006x;@\u0019l\u001e\u001eq#_[";
                    n3 = 8;
                    continue block25;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "B0@R\u0018`q]Q]g#L_\taqq{>$![W\u000be%L\u001e\u0016a(";
                    n3 = 9;
                    continue block25;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "P9@M]o4P\u001e\u0014wqGQ]h>GY\u0018vq__\u0011m5";
                    n3 = 10;
                    continue block25;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "t#FH\u0014`4[\u001e\u0010q\"]\u001e\u0013k%\t\\\u0018$?\\R\u0011";
                    n3 = 11;
                    continue block25;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "B0@R\u0018`q]Q]g#L_\taqq{>$![W\u000be%L\u001e\u0016a(";
                    n3 = 12;
                    continue block25;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "B\u0017mv8$0EY\u0012v8]V\u0010wqHL\u0018$?FJ]w$YN\u0012a#][\u0019";
                    n3 = 13;
                    continue block25;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "t0[_\u0010wqDK\u000epqK[]k7\tJ\u0004t4\tp\u001ci4Mn\u001cv0D[\ta#zN\u0018g";
                    n3 = 14;
                    continue block25;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "t#FH\u0014`4[\u001e\u001ee?GQ\t$3L\u001e\u0013q=E";
                    n3 = 15;
                    continue block25;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "|4Ju\u0018}qJ_\u0013j>]\u001e\u001faqGK\u0011h";
                    n3 = 16;
                    continue block25;
                }
                case 16: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

