/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.icc.RSAKey;
import com.ibm.crypto.plus.provider.t;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class RSAPublicKey
extends X509Key
implements java.security.interfaces.RSAPublicKey,
Destroyable {
    private static final long serialVersionUID = 8560764496984239182L;
    private static final BigInteger THREE;
    private IBMJCEPlusProvider provider = null;
    private BigInteger modulus = null;
    private BigInteger publicExponent = null;
    private transient RSAKey rsaKey = null;
    private transient boolean destroyed = false;
    private AlgorithmParameterSpec keyParams;
    private static final String[] z;

    public RSAPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.rsaPublicKey(this.algid, iBMJCEPlusProvider, bigInteger, bigInteger2);
    }

    public RSAPublicKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.rsaPublicKey(algorithmId, iBMJCEPlusProvider, bigInteger, bigInteger2);
    }

    public void rsaPublicKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        this.algid = algorithmId;
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
        this.keyParams = RSAUtil.getParamSpec((AlgorithmId)algorithmId);
        t.a(this.provider, this.modulus.bitLength(), this.publicExponent);
        this.a();
        try {
            byte[] byArray = RSAPublicKey.a(bigInteger, bigInteger2);
            this.setKey(new BitArray(byArray.length * 8, byArray));
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[3] + iOException.getMessage());
        }
        try {
            this.rsaKey = RSAKey.createPublicKey(iBMJCEPlusProvider.a(), this.key);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[4]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public RSAPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        this.decode(byArray);
        t.a(this.provider, this.modulus.bitLength(), this.publicExponent);
        this.a();
        try {
            this.rsaKey = RSAKey.createPublicKey(iBMJCEPlusProvider.a(), this.key);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[0]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
        try {
            this.keyParams = RSAUtil.getParamSpec((AlgorithmId)this.algid);
        }
        catch (ProviderException providerException) {
            throw new InvalidKeyException(providerException);
        }
    }

    public static RSAPublicKey newKey(IBMJCEPlusProvider iBMJCEPlusProvider, RSAUtil.KeyType keyType, AlgorithmParameterSpec algorithmParameterSpec, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        AlgorithmId algorithmId = RSAUtil.createAlgorithmId((RSAUtil.KeyType)keyType, (AlgorithmParameterSpec)algorithmParameterSpec);
        return new RSAPublicKey(algorithmId, iBMJCEPlusProvider, bigInteger, bigInteger2);
    }

    private void a() throws InvalidKeyException {
        if (this.publicExponent.compareTo(this.modulus) >= 0) {
            throw new InvalidKeyException(z[8]);
        }
        if (this.publicExponent.compareTo(THREE) < 0) {
            throw new InvalidKeyException(z[7]);
        }
    }

    public RSAPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, RSAKey rSAKey) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.rsaPublicKey(this.algid, iBMJCEPlusProvider, rSAKey);
    }

    public RSAPublicKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, RSAKey rSAKey) throws InvalidKeyException {
        this.rsaPublicKey(algorithmId, iBMJCEPlusProvider, rSAKey);
    }

    public void rsaPublicKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, RSAKey rSAKey) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        try {
            this.algid = algorithmId;
            byte[] byArray = rSAKey.getPublicKeyBytes();
            this.setKey(new BitArray(byArray.length * 8, byArray));
            this.rsaKey = rSAKey;
            this.parseKeyBits();
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[1]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    @Override
    public BigInteger getModulus() {
        this.c();
        return this.modulus;
    }

    @Override
    public BigInteger getPublicExponent() {
        this.c();
        return this.publicExponent;
    }

    @Override
    public String getAlgorithm() {
        this.c();
        return super.getAlgorithm();
    }

    @Override
    public String getFormat() {
        this.c();
        return super.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        this.c();
        return super.getEncoded();
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        return this.keyParams;
    }

    RSAKey b() {
        return this.rsaKey;
    }

    private static byte[] a(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, bigInteger.toByteArray()), new DerValue(2, bigInteger2.toByteArray())};
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putSequence(derValueArray);
        return derOutputStream.toByteArray();
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.getKey().toByteArray());
            DerValue[] derValueArray = derInputStream.getSequence(2);
            this.modulus = derValueArray[0].getPositiveBigInteger();
            this.publicExponent = derValueArray[1].getPositiveBigInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[6], iOException);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        this.c();
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException(z[5]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.rsaKey = null;
            this.modulus = null;
            this.publicExponent = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void c() {
        if (this.destroyed) {
            throw new IllegalStateException(z[2]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[9];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "}.e\u001db_ox\u001e'X=i\u0010s^o^\"F\u001b?y\u0013kR,,\u001abB";
        int n3 = -1;
        block16: while (true) {
            char[] cArray;
            block20: {
                int n4;
                int n5;
                block19: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block19;
                    n5 = n5;
                    if (n5 <= n4) break block20;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 59;
                            break;
                        }
                        case 1: {
                            n6 = 79;
                            break;
                        }
                        case 2: {
                            n6 = 12;
                            break;
                        }
                        case 3: {
                            n6 = 113;
                            break;
                        }
                        default: {
                            n6 = 7;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "}.e\u001db_ox\u001e'X=i\u0010s^o^\"F\u001b?y\u0013kR,,\u001abB";
                    n3 = 0;
                    continue block16;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "o'e\u0002'P*uQnHob\u001e'W b\u0016bIoz\u0010kR+";
                    n3 = 1;
                    continue block16;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "x y\u001dc\u001b!c\u0005'\u007f\n^QbU,c\u0015b\u0001o";
                    n3 = 2;
                    continue block16;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "}.e\u001db_ox\u001e'X=i\u0010s^o^\"F\u001b?y\u0013kR,,\u001abB";
                    n3 = 3;
                    continue block16;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "i\u001cM!rY#e\u0012L^6,\u001abB<,\u0010u^ob\u001es\u001b+e\u0003bX;`\b'_*\u007f\u0014uR.`\u0018}Z-`\u0014";
                    n3 = 4;
                    continue block16;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "r!z\u0010kR+,#Tzo|\u0004eW&oQl^6";
                    n3 = 5;
                    continue block16;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "^7|\u001ei^!xQnHo\u007f\u001cfW#i\u0003'O'm\u001f'\b";
                    n3 = 6;
                    continue block16;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "^7|\u001ei^!xQnHo`\u0010u\\*~QsS.bQjT+y\u001drH";
                    n3 = 7;
                    continue block16;
                }
                case 7: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        THREE = BigInteger.valueOf(3L);
    }
}

