/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.ECParameters;
import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.icc.ECKey;
import com.ibm.security.util.BitArray;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyRep;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class ECPublicKey
extends X509Key
implements Destroyable,
java.security.interfaces.ECPublicKey,
Serializable {
    private static final long serialVersionUID = -3386791752203116789L;
    private IBMJCEPlusProvider provider = null;
    private ECPoint w;
    private ECParameterSpec params;
    protected byte[] publicKeyBytes;
    private transient boolean destroyed = false;
    private transient ECKey ecKey = null;
    private static final String[] z;

    public ECPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, ECPoint eCPoint, ECParameterSpec eCParameterSpec) throws InvalidKeyException, InvalidParameterSpecException {
        this.provider = iBMJCEPlusProvider;
        this.w = eCPoint;
        this.params = eCParameterSpec;
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.a(iBMJCEPlusProvider, eCParameterSpec));
        this.key = ECParameters.a(eCPoint, this.params.getCurve());
        try {
            byte[] byArray = ECParameters.a(eCParameterSpec);
            byte[] byArray2 = this.a();
            this.ecKey = ECKey.createPublicKey(iBMJCEPlusProvider.a(), byArray2, byArray);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[1]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public ECPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        this.decode(byArray);
        try {
            byte[] byArray2 = this.a();
            byte[] byArray3 = ECParameters.a(this.params);
            this.ecKey = ECKey.createPublicKey(iBMJCEPlusProvider.a(), byArray2, byArray3);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[5]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public ECPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, ECKey eCKey) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        try {
            this.algid = new AlgorithmId(AlgorithmId.EC_oid, eCKey.getParameters());
            byte[] byArray = this.a(eCKey.getPublicKeyBytes());
            this.setKey(new BitArray(byArray.length * 8, byArray));
            this.ecKey = eCKey;
            this.parseKeyBits();
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[0]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    private byte[] a(byte[] byArray) throws IOException {
        return byArray;
    }

    private byte[] a() throws IOException {
        ECParameterSpec eCParameterSpec = this.params;
        ECPoint eCPoint = this.w;
        ECParameters eCParameters = new ECParameters(this.provider);
        try {
            eCParameters.engineInit(eCParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidParameterException(z[6] + invalidParameterSpecException.getMessage());
        }
        byte[] byArray = ECParameters.a(eCPoint, eCParameterSpec.getCurve());
        return byArray;
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            AlgorithmParameters algorithmParameters = this.algid.getAlgParameters();
            this.params = algorithmParameters.getParameterSpec(ECParameterSpec.class);
            this.w = ECParameters.a(this.key, this.params.getCurve());
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[4], iOException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeyException(z[3], invalidParameterSpecException);
        }
    }

    ECKey b() {
        return this.ecKey;
    }

    private Object writeReplace() throws ObjectStreamException {
        this.c();
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException(z[2]);
    }

    @Override
    public String getFormat() {
        this.c();
        return super.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        this.c();
        return super.getEncoded();
    }

    @Override
    public ECPoint getW() {
        this.c();
        return this.w;
    }

    @Override
    public ECParameterSpec getParams() {
        this.c();
        return this.params;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.ecKey = null;
            this.w = null;
            this.params = null;
        }
    }

    private void c() {
        if (this.destroyed) {
            throw new IllegalStateException(z[7]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = ".\"\r\u001df\fc\u0010\u001e#\u000b1\u0001\u0010w\rc!2#\u00186\u0006\u001dj\u000bc\u000f\u0014z";
        int n3 = -1;
        block15: while (true) {
            char[] cArray;
            block19: {
                int n4;
                int n5;
                block18: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block18;
                    n5 = n5;
                    if (n5 <= n4) break block19;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 104;
                            break;
                        }
                        case 1: {
                            n6 = 67;
                            break;
                        }
                        case 2: {
                            n6 = 100;
                            break;
                        }
                        case 3: {
                            n6 = 113;
                            break;
                        }
                        default: {
                            n6 = 3;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = ".\"\r\u001df\fc\u0010\u001e#\u000b1\u0001\u0010w\rc!2#\u00186\u0006\u001dj\u000bc\u000f\u0014z";
                    n3 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "-\u00004\u0004a\u0004*\u0007:f\u0011c\u000f\u0014z\u001bc\u0005\u0003fH-\u000b\u0005#\f*\u0016\u0014`\u001c/\u001dQg\r0\u0001\u0003j\t/\r\u000bb\n/\u0001";
                    n3 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "!-\u0012\u0010o\u0001'D4@H(\u0001\b";
                    n3 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "!-\u0012\u0010o\u0001'D4@H(\u0001\b";
                    n3 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = ".\"\r\u001df\fc\u0010\u001e#\u000b1\u0001\u0010w\rc!2#\u00186\u0006\u001dj\u000bc\u000f\u0014z";
                    n3 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "!-\u0012\u0010o\u0001'D!b\u001a\"\t\u0014w\r1D\"s\r \r\u0017j\u000b\"\u0010\u0018l\u0006c";
                    n3 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "<+\r\u0002#\u0003&\u001dQj\u001bc\n\u001e#\u0004,\n\u0016f\u001ac\u0012\u0010o\u0001'";
                    n3 = 6;
                    continue block15;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

