/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.heapdump.portable;

import com.ibm.jvm.dtfjview.heapdump.ReferenceIterator;
import com.ibm.jvm.dtfjview.heapdump.portable.ObjectRecord;
import java.io.DataOutput;
import java.io.IOException;

public class LongObjectRecord
extends ObjectRecord {
    private final byte _tag;
    private final boolean _is64Bit;

    public LongObjectRecord(long address, long previousAddress, long classAddress, int hashCode, ReferenceIterator references, boolean is64Bit, boolean is32BitHash) {
        this(4, address, previousAddress, classAddress, hashCode, references, is64Bit, is32BitHash);
    }

    protected LongObjectRecord(byte tag, long address, long previousAddress, long classAddress, int hashCode, ReferenceIterator references, boolean is64Bit, boolean is32BitHash) {
        super(address, previousAddress, classAddress, hashCode, references, is32BitHash);
        this._tag = tag;
        this._is64Bit = is64Bit;
    }

    @Override
    protected void writeHeapDump(DataOutput out) throws IOException {
        out.writeByte(this._tag);
        int flag = 0;
        flag = (byte)(flag | this._gapSize << 6);
        flag = (byte)(flag | this._referenceFieldSize << 4);
        if (this._is32BitHash) {
            if (this._hashCode != 0) {
                flag = (byte)(flag | 3);
            }
        } else {
            flag = (byte)(flag | 1);
        }
        out.writeByte(flag);
        this.writeReference(out, this._gapSize, this._gapPreceding);
        if (this._is64Bit) {
            out.writeLong(this._classAddress);
        } else {
            out.writeInt((int)this._classAddress);
        }
        if (this._is32BitHash) {
            if (this._hashCode != 0) {
                out.writeInt(this._hashCode);
            }
        } else {
            out.writeShort(this._hashCode);
        }
        out.writeInt(this._numberOfReferences);
        this.writeReferences(out);
    }
}

