/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.setcommands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.heapdump.HeapDumpSettings;
import java.io.PrintStream;

@DTFJPlugin(version="1.*")
public class SetHeapdumpCommand
extends BaseJdmpviewCommand {
    private static final String SHORT_DESCRIPTION = "configures heapdump format, filename and multiple heap support";
    private static final String COMMAND_NAME = "set heapdump";
    private static final String LONG_DESCRIPTION = "parameters: [phd|txt], [file <filename>], [multiplefiles on|off]\n\n[phd|txt] - the format for the heapdump. Default: phd.\n[file <filename>] - the file to write the heapdump to. Default: <core file name>.phd or <core file name>.txt.\n\n[multiplefiles on|off] - if set to on, multiple heaps are written to separate heapdumps. If set to off, multiple heaps are written to the same heapdump. Default: off.\n\nUse \"show heapdump\" to see current settings.\n";

    public SetHeapdumpCommand() {
        this.addCommand(COMMAND_NAME, "", SHORT_DESCRIPTION);
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        if (args.length == 0) {
            out.println("\"set heapdump\" requires at least one parameter\n");
            return;
        }
        String arg1 = args[0];
        if (arg1.equalsIgnoreCase("phd")) {
            HeapDumpSettings.setPHDHeapDumps(this.ctx.getProperties());
            out.print("Heapdump format set to PHD\n");
        } else if (arg1.equalsIgnoreCase("txt")) {
            HeapDumpSettings.setClassicHeapDumps(this.ctx.getProperties());
            out.print("Heapdump format set to classic (TXT)\n");
        } else if (arg1.equalsIgnoreCase("file")) {
            if (args.length == 1) {
                out.println("\"set heapdump file\" requires at least one parameter\n");
                return;
            }
            if (args.length > 2) {
                out.println("\"set heapdump file\" accepts 1 parameter. You supplied " + (args.length - 1) + ".\n");
                return;
            }
            String filename = args[1];
            String originalFileName = HeapDumpSettings.getFileName(this.ctx.getProperties());
            HeapDumpSettings.setFileName(filename, this.ctx.getProperties());
            out.print("Heapdump file changed from " + originalFileName + " to " + filename + "\n");
        } else if (arg1.equalsIgnoreCase("multiplefiles")) {
            if (args.length == 1) {
                out.println("\"set heapdump multiplefiles\" requires one parameter: on or off\n");
                return;
            }
            if (args.length > 2) {
                out.println("\"set heapdump multiplefiles\" requires one parameter: on or off. You suppled " + (args.length - 1) + " parameters\n");
                return;
            }
            String setting = args[1];
            if (setting.equalsIgnoreCase("on")) {
                out.println("Multiple heaps will be dumped into multiple heapdumps");
                HeapDumpSettings.setMultipleHeapsMultipleFiles(this.ctx.getProperties());
            } else if (setting.equalsIgnoreCase("off")) {
                out.println("Multiple heaps will be dumped into a single heapdump");
                HeapDumpSettings.setMultipleHeapsSingleFile(this.ctx.getProperties());
            } else {
                out.println("Unrecognised setting: " + setting + ". Valid options are \"on\" or \"off\"\n");
            }
        } else {
            out.println(arg1 + " is not a valid parameter for the \"set heapdump\" command");
        }
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println(LONG_DESCRIPTION);
    }
}

