/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.IDTFJContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import java.io.PrintStream;
import java.nio.ByteOrder;

@DTFJPlugin(version="1.*", runtime=false)
public class FindPtrCommand
extends BaseJdmpviewCommand {
    String pattern;

    public FindPtrCommand() {
        this.addCommand("findptr", "", "searches memory for the given pointer");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        if (args.length == 1) {
            String[] params;
            String line = args[0];
            if (line.endsWith(",")) {
                line = line + "1";
            }
            if (!this.isParametersValid(params = line.split(","))) {
                return;
            }
            if (FindPtrCommand.isLittleEndian(context)) {
                this.pattern = this.reorderBytes();
            }
            String parameters = this.getParameters(params);
            out.println("issuing: find " + parameters);
            this.ctx.execute("find " + parameters, out);
        } else {
            out.println("\"find\" takes a set comma separated parameters with no spaces");
        }
    }

    private String getParameters(String[] params) {
        String temp = "0x" + this.pattern;
        for (int i = 1; i < params.length; ++i) {
            temp = temp + "," + params[i];
        }
        return temp;
    }

    private String reorderBytes() {
        if (0 != this.pattern.length() % 2) {
            this.pattern = "0" + this.pattern;
        }
        String temp = "";
        for (int i = this.pattern.length() / 2 - 1; i >= 0; --i) {
            temp = temp + this.pattern.substring(i * 2, i * 2 + 2);
        }
        return temp;
    }

    private static boolean isLittleEndian(IContext context) {
        ImageAddressSpace addressSpace;
        return context instanceof IDTFJContext && ByteOrder.LITTLE_ENDIAN == (addressSpace = ((IDTFJContext)context).getAddressSpace()).getByteOrder();
    }

    private boolean isParametersValid(String[] params) {
        if (6 != params.length) {
            this.out.println("insufficient number of parameters");
            return false;
        }
        this.pattern = params[0];
        if (this.pattern.equals("")) {
            this.out.println("missing pattern string");
            return false;
        }
        if (this.pattern.startsWith("0x")) {
            this.pattern = this.pattern.substring(2);
        }
        return true;
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println("searches memory for the given pointer\n\nparameters: see parameters for \"find\" command\n\nthe findptr command searches for <pattern> as a pointer in the memory segment from <start_address> to <end_address> (both inclusive), and outputs the first <matches_to_display> matching addresses that start at the corresponding <memory_boundary>. It also display the next <bytes_to_print> bytes for the last match.");
    }
}

