/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.PathComponent;
import org.apache.xpath.objects.XNodeSet;

public class FilterExprIteratorSimple
extends LocPathIterator {
    static final long serialVersionUID = -6978977187025375579L;
    private Expression m_expr;
    private transient XNodeSet m_exprObj;
    private boolean m_mustHardReset = false;
    private boolean m_canDetachNodeset = true;

    public FilterExprIteratorSimple() {
        super((PrefixResolver)null);
    }

    public FilterExprIteratorSimple(Expression expression) {
        super((PrefixResolver)null);
        this.m_expr = expression;
    }

    @Override
    public void setRoot(int n, Object object) {
        super.setRoot(n, object);
        this.m_exprObj = FilterExprIteratorSimple.executeFilterExpr(n, this.m_execContext, this.getPrefixResolver(), this.getIsTopLevel(), this.m_stackFrame, this.m_expr);
    }

    public static XNodeSet executeFilterExpr(int n, XPathContext xPathContext, PrefixResolver prefixResolver, boolean bl, int n2, Expression expression) throws WrappedRuntimeException {
        PrefixResolver prefixResolver2 = xPathContext.getNamespaceContext();
        XNodeSet xNodeSet = null;
        try {
            xPathContext.pushCurrentNode(n);
            xPathContext.setNamespaceContext(prefixResolver);
            if (bl) {
                VariableStack variableStack = xPathContext.getVarStack();
                int n3 = variableStack.getStackFrame();
                variableStack.setStackFrame(n2);
                xNodeSet = (XNodeSet)expression.execute(xPathContext);
                xNodeSet.setShouldCacheNodes(true);
                variableStack.setStackFrame(n3);
            } else {
                xNodeSet = (XNodeSet)expression.execute(xPathContext);
            }
        }
        catch (TransformerException transformerException) {
            throw new WrappedRuntimeException(transformerException);
        }
        finally {
            xPathContext.popCurrentNode();
            xPathContext.setNamespaceContext(prefixResolver2);
        }
        return xNodeSet;
    }

    @Override
    public int nextNode() {
        int n;
        if (this.m_foundLast) {
            return -1;
        }
        if (null != this.m_exprObj) {
            this.m_lastFetched = n = this.m_exprObj.nextNode();
        } else {
            n = -1;
            this.m_lastFetched = -1;
        }
        if (-1 != n) {
            ++this.m_pos;
            return n;
        }
        this.m_foundLast = true;
        return -1;
    }

    @Override
    public void detach() {
        if (this.m_allowDetach) {
            super.detach();
            this.m_exprObj.detach();
            this.m_exprObj = null;
        }
    }

    @Override
    public void fixupVariables(Vector vector, int n) {
        super.fixupVariables(vector, n);
        this.m_expr.fixupVariables(vector, n);
    }

    public Expression getInnerExpression() {
        return this.m_expr;
    }

    public void setInnerExpression(Expression expression) {
        expression.exprSetParent(this);
        this.m_expr = expression;
    }

    @Override
    public int getAnalysisBits() {
        if (null != this.m_expr && this.m_expr instanceof PathComponent) {
            return ((PathComponent)((Object)this.m_expr)).getAnalysisBits();
        }
        return 0x4000000;
    }

    @Override
    public boolean isDocOrdered() {
        return this.m_exprObj.isDocOrdered();
    }

    @Override
    public void callPredicateVisitors(XPathVisitor xPathVisitor) {
        this.m_expr.callVisitors(new filterExprOwner(), xPathVisitor);
        super.callPredicateVisitors(xPathVisitor);
    }

    @Override
    public boolean deepEquals(Expression expression) {
        if (!super.deepEquals(expression)) {
            return false;
        }
        FilterExprIteratorSimple filterExprIteratorSimple = (FilterExprIteratorSimple)expression;
        return this.m_expr.deepEquals(filterExprIteratorSimple.m_expr);
    }

    @Override
    public int getAxis() {
        if (null != this.m_exprObj) {
            return this.m_exprObj.getAxis();
        }
        return 20;
    }

    class filterExprOwner
    implements ExpressionOwner {
        filterExprOwner() {
        }

        @Override
        public Expression getExpression() {
            return FilterExprIteratorSimple.this.m_expr;
        }

        @Override
        public void setExpression(Expression expression) {
            expression.exprSetParent(FilterExprIteratorSimple.this);
            FilterExprIteratorSimple.this.m_expr = expression;
        }
    }
}

