/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.Writer;
import java.util.Stack;
import java.util.Vector;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class DOMBuilder
implements ContentHandler,
LexicalHandler {
    public Document m_doc;
    protected Node m_currentNode = null;
    protected Node m_root = null;
    protected Node m_nextSibling = null;
    public DocumentFragment m_docFrag = null;
    protected Stack m_elemStack = new Stack();
    protected Vector m_prefixMappings = new Vector();
    protected boolean m_inCData = false;

    public DOMBuilder(Document document, Node node) {
        this.m_doc = document;
        this.m_currentNode = this.m_root = node;
        if (node instanceof Element) {
            this.m_elemStack.push(node);
        }
    }

    public DOMBuilder(Document document, DocumentFragment documentFragment) {
        this.m_doc = document;
        this.m_docFrag = documentFragment;
    }

    public DOMBuilder(Document document) {
        this.m_doc = document;
    }

    public Node getRootDocument() {
        return null != this.m_docFrag ? this.m_docFrag : this.m_doc;
    }

    public Node getRootNode() {
        return this.m_root;
    }

    public Node getCurrentNode() {
        return this.m_currentNode;
    }

    public void setNextSibling(Node node) {
        this.m_nextSibling = node;
    }

    public Node getNextSibling() {
        return this.m_nextSibling;
    }

    public Writer getWriter() {
        return null;
    }

    protected void append(Node node) throws SAXException {
        Node node2 = this.m_currentNode;
        if (null != node2) {
            if (node2 == this.m_root && this.m_nextSibling != null) {
                node2.insertBefore(node, this.m_nextSibling);
            } else {
                node2.appendChild(node);
            }
        } else if (null != this.m_docFrag) {
            if (this.m_nextSibling != null) {
                this.m_docFrag.insertBefore(node, this.m_nextSibling);
            } else {
                this.m_docFrag.appendChild(node);
            }
        } else {
            boolean bl = true;
            short s = node.getNodeType();
            if (s == 3) {
                String string = node.getNodeValue();
                if (null != string && string.trim().length() > 0) {
                    throw new SAXException(XMLMessages.createXMLMessage("ER_CANT_OUTPUT_TEXT_BEFORE_DOC", null));
                }
                bl = false;
            } else if (s == 1 && this.m_doc.getDocumentElement() != null) {
                bl = false;
                throw new SAXException(XMLMessages.createXMLMessage("ER_CANT_HAVE_MORE_THAN_ONE_ROOT", null));
            }
            if (bl) {
                if (this.m_nextSibling != null) {
                    this.m_doc.insertBefore(node, this.m_nextSibling);
                } else {
                    this.m_doc.appendChild(node);
                }
            }
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Element element = null == string || string.length() == 0 ? this.m_doc.createElementNS(null, string3) : this.m_doc.createElementNS(string, string3);
        this.append(element);
        try {
            String string4;
            String string5;
            int n;
            int n2 = attributes.getLength();
            if (0 != n2) {
                for (n = 0; n < n2; ++n) {
                    if (attributes.getType(n).equalsIgnoreCase("ID")) {
                        this.setIDAttribute(attributes.getValue(n), element);
                    }
                    if ("".equals(string5 = attributes.getURI(n))) {
                        string5 = null;
                    }
                    if ((string4 = attributes.getQName(n)).startsWith("xmlns:") || string4.equals("xmlns")) {
                        string5 = "http://www.w3.org/2000/xmlns/";
                    }
                    element.setAttributeNS(string5, string4, attributes.getValue(n));
                }
            }
            n = this.m_prefixMappings.size();
            for (int i = 0; i < n; i += 2) {
                string5 = (String)this.m_prefixMappings.elementAt(i);
                if (string5 == null) continue;
                string4 = (String)this.m_prefixMappings.elementAt(i + 1);
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", string5, string4);
            }
            this.m_prefixMappings.clear();
            this.m_elemStack.push(element);
            this.m_currentNode = element;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.m_elemStack.pop();
        this.m_currentNode = this.m_elemStack.isEmpty() ? null : (Node)this.m_elemStack.peek();
    }

    public void setIDAttribute(String string, Element element) {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Node node;
        if (this.isOutsideDocElem() && XMLCharacterRecognizer.isWhiteSpace(cArray, n, n2)) {
            return;
        }
        if (this.m_inCData) {
            this.cdata(cArray, n, n2);
            return;
        }
        String string = new String(cArray, n, n2);
        Node node2 = node = this.m_currentNode != null ? this.m_currentNode.getLastChild() : null;
        if (node != null && node.getNodeType() == 3) {
            ((Text)node).appendData(string);
        } else {
            Text text = this.m_doc.createTextNode(string);
            this.append(text);
        }
    }

    public void charactersRaw(char[] cArray, int n, int n2) throws SAXException {
        if (this.isOutsideDocElem() && XMLCharacterRecognizer.isWhiteSpace(cArray, n, n2)) {
            return;
        }
        String string = new String(cArray, n, n2);
        this.append(this.m_doc.createProcessingInstruction("xslt-next-is-raw", "formatter-to-dom"));
        this.append(this.m_doc.createTextNode(string));
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    public void entityReference(String string) throws SAXException {
        this.append(this.m_doc.createEntityReference(string));
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.isOutsideDocElem()) {
            return;
        }
        String string = new String(cArray, n, n2);
        this.append(this.m_doc.createTextNode(string));
    }

    private boolean isOutsideDocElem() {
        return null == this.m_docFrag && this.m_elemStack.size() == 0 && (null == this.m_currentNode || this.m_currentNode.getNodeType() == 9);
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        this.append(this.m_doc.createProcessingInstruction(string, string2));
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.append(this.m_doc.createComment(new String(cArray, n, n2)));
    }

    @Override
    public void startCDATA() throws SAXException {
        this.m_inCData = true;
        this.append(this.m_doc.createCDATASection(""));
    }

    @Override
    public void endCDATA() throws SAXException {
        this.m_inCData = false;
    }

    public void cdata(char[] cArray, int n, int n2) throws SAXException {
        if (this.isOutsideDocElem() && XMLCharacterRecognizer.isWhiteSpace(cArray, n, n2)) {
            return;
        }
        String string = new String(cArray, n, n2);
        CDATASection cDATASection = (CDATASection)this.m_currentNode.getLastChild();
        cDATASection.appendData(string);
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        string = null == string || string.equals("") ? "xmlns" : "xmlns:" + string;
        this.m_prefixMappings.addElement(string);
        this.m_prefixMappings.addElement(string2);
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }
}

