/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.util.Properties;
import org.apache.xml.serializer.EmptySerializer;
import org.apache.xml.serializer.ObjectFactory;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.SecuritySupport;
import org.apache.xml.serializer.SerializationHandler;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerBase;
import org.apache.xml.serializer.SerializerConstants;
import org.apache.xml.serializer.ToHTMLStream;
import org.apache.xml.serializer.ToTextStream;
import org.apache.xml.serializer.ToXHTMLStream;
import org.apache.xml.serializer.ToXMLStream;
import org.apache.xml.serializer.utils.Utils;
import org.apache.xml.serializer.utils.WrappedRuntimeException;
import org.xml.sax.ContentHandler;

public final class SerializerFactory {
    private static final String s_expected_html_classname = SerializerBase.PKG_NAME + ".ToHTMLStream";
    private static final String s_expected_xhtml_classname;
    private static final String s_expected_xml_classname;
    private static final String s_expected_text_classname;
    private static final boolean s_empty;

    private SerializerFactory() {
    }

    public static Serializer getSerializer(Properties properties) {
        SerializationHandler serializationHandler;
        block15: {
            if (s_empty) {
                EmptySerializer emptySerializer = new EmptySerializer();
                emptySerializer.setURI("empty");
                return emptySerializer;
            }
            serializationHandler = null;
            try {
                Properties properties2;
                String string = properties.getProperty("method");
                if (string == null) {
                    String string2 = Utils.messages.createMessage("ER_FACTORY_PROPERTY_MISSING", new Object[]{"method"});
                    throw new IllegalArgumentException(string2);
                }
                String string3 = properties.getProperty("{http://xml.apache.org/xalan}content-handler");
                if (null == string3 && null == (string3 = (properties2 = OutputPropertiesFactory.getDefaultMethodProperties(string)).getProperty("{http://xml.apache.org/xalan}content-handler"))) {
                    String string4 = Utils.messages.createMessage("ER_FACTORY_PROPERTY_MISSING", new Object[]{"{http://xml.apache.org/xalan}content-handler"});
                    throw new IllegalArgumentException(string4);
                }
                if (string3.equals(s_expected_html_classname)) {
                    serializationHandler = new ToHTMLStream();
                } else if (string3.equals(s_expected_xml_classname)) {
                    serializationHandler = new ToXMLStream();
                } else if (string3.equals(s_expected_xhtml_classname)) {
                    serializationHandler = new ToXHTMLStream();
                } else if (string3.equals(s_expected_text_classname)) {
                    serializationHandler = new ToTextStream();
                }
                if (serializationHandler != null) {
                    serializationHandler.setOutputFormat(properties);
                    return serializationHandler;
                }
                ClassLoader classLoader = ObjectFactory.findClassLoader();
                Class clazz = ObjectFactory.findProviderClass(string3, classLoader, true);
                Object t = clazz.newInstance();
                if (t instanceof SerializationHandler) {
                    serializationHandler = (SerializationHandler)t;
                    serializationHandler.setOutputFormat(properties);
                    break block15;
                }
                if (t instanceof ContentHandler) {
                    string3 = SerializerConstants.DEFAULT_SAX_SERIALIZER;
                    clazz = ObjectFactory.findProviderClass(string3, classLoader, true);
                    SerializationHandler serializationHandler2 = (SerializationHandler)clazz.newInstance();
                    serializationHandler2.setContentHandler((ContentHandler)t);
                    serializationHandler2.setOutputFormat(properties);
                    serializationHandler = serializationHandler2;
                    break block15;
                }
                throw new Exception(Utils.messages.createMessage("ER_SERIALIZER_NOT_CONTENTHANDLER", new Object[]{string3}));
            }
            catch (Exception exception) {
                throw new WrappedRuntimeException(exception);
            }
        }
        return serializationHandler;
    }

    static {
        s_expected_xml_classname = SerializerBase.PKG_NAME + ".ToXMLStream";
        s_expected_xhtml_classname = SerializerBase.PKG_NAME + ".ToXHTMLStream";
        s_expected_text_classname = SerializerBase.PKG_NAME + ".ToTextStream";
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        String string = securitySupport.getSystemProperty("org.apache.xml.serializer.EmptySerializer");
        s_empty = "true".equals(string);
    }
}

