/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import org.apache.xml.serializer.utils.StringToIntTable;

public final class ElemDesc {
    private int m_flags;
    private StringToIntTable m_attrs = null;
    static final int EMPTY = 2;
    private static final int FLOW = 4;
    static final int BLOCK = 8;
    static final int BLOCKFORM = 16;
    static final int BLOCKFORMFIELDSET = 32;
    private static final int CDATA = 64;
    private static final int PCDATA = 128;
    static final int RAW = 256;
    private static final int INLINE = 512;
    private static final int INLINEA = 1024;
    static final int INLINELABEL = 2048;
    static final int FONTSTYLE = 4096;
    static final int PHRASE = 8192;
    static final int FORMCTRL = 16384;
    static final int SPECIAL = 32768;
    static final int ASPECIAL = 65536;
    static final int HEADMISC = 131072;
    static final int HEAD = 262144;
    static final int LIST = 524288;
    static final int PREFORMATTED = 0x100000;
    static final int WHITESPACESENSITIVE = 0x200000;
    static final int HEADELEM = 0x400000;
    static final int HTMLELEM = 0x800000;
    public static final int ATTRURL = 2;
    public static final int ATTREMPTY = 4;

    ElemDesc(int n) {
        this.m_flags = n;
    }

    boolean is(int n) {
        return (this.m_flags & n) != 0;
    }

    int getFlags() {
        return this.m_flags;
    }

    void setAttr(String string, int n) {
        if (null == this.m_attrs) {
            this.m_attrs = new StringToIntTable();
        }
        this.m_attrs.put(string, n);
    }

    public boolean isAttrFlagSet(String string, int n) {
        return null != this.m_attrs ? (this.m_attrs.getIgnoreCase(string) & n) != 0 : false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ElemDesc:\n");
        if (this.is(65536)) {
            stringBuffer.append("  ASPECIAL\n");
        }
        if (this.is(4)) {
            stringBuffer.append("  ATTREMPTY\n");
        }
        if (this.is(2)) {
            stringBuffer.append("  ATTRURL\n");
        }
        if (this.is(8)) {
            stringBuffer.append("  BLOCK\n");
        }
        if (this.is(16)) {
            stringBuffer.append("  BLOCKFORM\n");
        }
        if (this.is(32)) {
            stringBuffer.append("  BLOCKFORMFIELDSET\n");
        }
        if (this.is(64)) {
            stringBuffer.append("  CDATA\n");
        }
        if (this.is(2)) {
            stringBuffer.append("  EMPTY\n");
        }
        if (this.is(4)) {
            stringBuffer.append("  FLOW\n");
        }
        if (this.is(4096)) {
            stringBuffer.append("  FONTSTYLE\n");
        }
        if (this.is(16384)) {
            stringBuffer.append("  FORMCTRL\n");
        }
        if (this.is(262144)) {
            stringBuffer.append("  \n");
        }
        if (this.is(0x400000)) {
            stringBuffer.append("  HEAD\n");
        }
        if (this.is(131072)) {
            stringBuffer.append("  HEADMISC\n");
        }
        if (this.is(0x800000)) {
            stringBuffer.append("  HEADELEM\n");
        }
        if (this.is(512)) {
            stringBuffer.append("  INLINE\n");
        }
        if (this.is(1024)) {
            stringBuffer.append("  INLINEA\n");
        }
        if (this.is(2048)) {
            stringBuffer.append("  \n");
        }
        if (this.is(524288)) {
            stringBuffer.append("  INLINELABEL\n");
        }
        if (this.is(128)) {
            stringBuffer.append("  PCDATA\n");
        }
        if (this.is(8192)) {
            stringBuffer.append("  PHRASE\n");
        }
        if (this.is(0x100000)) {
            stringBuffer.append("  PREFORMATTED\n");
        }
        if (this.is(256)) {
            stringBuffer.append("  RAW\n");
        }
        if (this.is(32768)) {
            stringBuffer.append("  SPECIAL\n");
        }
        if (this.is(0x200000)) {
            stringBuffer.append("  WHITESPACESENSITIVE\n");
        }
        return stringBuffer.toString();
    }
}

