/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.interpreter;

import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IdentityHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class Environment {
    protected IdentityHashMap m_bindings = new IdentityHashMap();
    protected IdentityHashMap m_memoizedFunctions = new IdentityHashMap();
    public HashMap m_statics = new HashMap();

    public final Object lookupBinding(IBinding iBinding) {
        return this.m_bindings.get(iBinding);
    }

    public final Object bind(IBinding iBinding, Object object) {
        Object object2 = this.lookupBinding(iBinding);
        this.m_bindings.put(iBinding, object);
        return object2;
    }

    public final Object lookupMemoizedFunction(Function function) {
        return this.m_memoizedFunctions.get(function);
    }

    public final void memoizeFunction(Function function, Object object) {
        this.m_memoizedFunctions.put(function, object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("**************** Bindings ****************\n");
        stringBuffer.append(this.getMapString(this.m_bindings));
        stringBuffer.append("***************** Statics ****************\n");
        stringBuffer.append(this.getMapString(this.m_statics));
        stringBuffer.append("*********** Memoized Functions ************\n");
        stringBuffer.append(this.getMapString(this.m_memoizedFunctions));
        return stringBuffer.toString();
    }

    private String getMapString(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NumEntries:" + map.size() + "\n");
        Iterator iterator = map.entrySet().iterator();
        stringBuffer.append("[\n");
        while (iterator.hasNext()) {
            try {
                Map.Entry entry = iterator.next();
                Object object = entry.getKey();
                if (object instanceof IBinding) {
                    object = ((IBinding)object).getName() + "(" + object.getClass().getName() + ":" + object.hashCode() + ")";
                }
                Object v = entry.getValue();
                stringBuffer.append("    (" + object + "," + v + ")\n");
            }
            catch (Exception exception) {
                // empty catch block
                break;
            }
        }
        stringBuffer.append("]\n");
        return stringBuffer.toString();
    }
}

