/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xtq.bcel.generic.ObjectType;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.IImperativeInstruction;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.JavaClassWrapper;
import com.ibm.xylem.JavaConstructorWrapper;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.IConvertible;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.utils.WrappedRuntimeException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;

public class NewJavaObjectInstruction
extends NaryPrimopInstruction
implements IImperativeInstruction {
    protected Type m_type;

    public NewJavaObjectInstruction() {
    }

    public NewJavaObjectInstruction(Instruction[] instructionArray, Type type) {
        super(instructionArray);
        this.setCachedType(type);
        this.m_type = type;
    }

    public NewJavaObjectInstruction(List list, Type type) {
        super(list);
        this.setCachedType(type);
        this.m_type = type;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_type;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_parameters.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        return new NewJavaObjectInstruction(instructionArray, this.m_type);
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] instructionArray = (Instruction[])this.m_parameters.clone();
        return new NewJavaObjectInstruction(instructionArray, this.m_type);
    }

    @Override
    public String innerToString() {
        return "new-java-object (java " + this.m_type + ")";
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        Type type = this.m_type.resolveType(typeEnvironment);
        StringBuffer stringBuffer = new StringBuffer("new ");
        stringBuffer.append(type.getImplementationName(dataFlowCodeGenerationHelper));
        stringBuffer.append('(');
        boolean bl2 = false;
        if (type instanceof NamedType && dataFlowCodeGenerationHelper.getSettings().isMakeAllMethodsStatic()) {
            stringBuffer.append(dataFlowCodeGenerationHelper.generateThisVar());
            bl2 = true;
        }
        for (int i = 0; i < this.m_parameters.length; ++i) {
            if (bl2) {
                stringBuffer.append(", ");
            }
            String string3 = codeGenerationTracker.generateConventionally(this.m_parameters[i], dataFlowCodeGenerationHelper);
            stringBuffer.append(string3);
            bl2 = true;
        }
        stringBuffer.append(')');
        dataFlowCodeGenerationHelper.appendAssignment(string2, this.m_type, stringBuffer.toString(), codeGenerationTracker);
        return string2;
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        JavaConstructorWrapper javaConstructorWrapper = this.m_type instanceof NamedType ? null : (JavaConstructorWrapper)this.evaluate(null, codeGenerationTracker.getCurrentModule().getFunction(bCELCodeGenerationHelper.getCurrentFunction()), null, false);
        String string2 = javaConstructorWrapper == null ? bCELCodeGenerationHelper.getClassName() + "$" + this.m_type.toString() : javaConstructorWrapper.getDeclaringClassName();
        instructionListBuilder.appendNew(string2);
        instructionListBuilder.appendDUP();
        int n = javaConstructorWrapper == null && bCELCodeGenerationHelper.getSettings().isMakeAllMethodsStatic() ? 1 : 0;
        com.ibm.xtq.bcel.generic.Type[] typeArray = new com.ibm.xtq.bcel.generic.Type[this.m_parameters.length + n];
        if (n != 0) {
            typeArray[0] = new ObjectType(bCELCodeGenerationHelper.getClassName());
            instructionListBuilder.appendThis();
        }
        for (int i = 0; i < this.m_parameters.length; ++i) {
            codeGenerationTracker.generateConventionally(this.m_parameters[i], bCELCodeGenerationHelper, null, instructionListBuilder);
            typeArray[i + n] = javaConstructorWrapper == null ? codeGenerationTracker.resolveType(this.m_parameters[i]).getImplementationType(bCELCodeGenerationHelper) : javaConstructorWrapper.getParamType(i).getBCELType();
        }
        instructionListBuilder.appendInvokeConstructor(string2, typeArray);
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        Object object;
        Object object2;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        Type type = this.m_type.resolveType(function.getTypeEnvironment());
        JavaClassWrapper javaClassWrapper = type.getJavaType();
        Object[] objectArray = new Object[this.m_parameters.length];
        JavaClassWrapper[] javaClassWrapperArray = new JavaClassWrapper[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            object2 = this.m_parameters[i].evaluateType(function);
            if (environment != null) {
                object = this.m_parameters[i].evaluate(environment, function, iDebuggerInterceptor, false);
                if (object instanceof IConvertible) {
                    object = ((IConvertible)object).convert((Type)object2);
                }
                objectArray[i] = object;
            }
            javaClassWrapperArray[i] = ((Type)object2).getJavaType();
        }
        try {
            JavaConstructorWrapper javaConstructorWrapper = JavaClassWrapper.getConstructor(javaClassWrapper, javaClassWrapperArray);
            if (environment == null) {
                return javaConstructorWrapper;
            }
            object = object2 = javaConstructorWrapper.newInstance(objectArray);
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, object);
        }
        catch (InvocationTargetException invocationTargetException) {
            object2 = invocationTargetException.getTargetException();
            throw new WrappedRuntimeException((Throwable)object2);
        }
        catch (Exception exception) {
            throw new WrappedRuntimeException(exception);
        }
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        super.typeCheckChildren(typeEnvironment, bindingEnvironment, linkedList);
        return this.m_type;
    }

    @Override
    public boolean equals(Object object) {
        return object == this;
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_type = readObjectFileHelper.readType();
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeType(this.m_type);
    }
}

