/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.Binding;
import com.ibm.xylem.Function;
import com.ibm.xylem.FunctionSignature;
import com.ibm.xylem.Functor;
import com.ibm.xylem.FunctorApplicationDirective;
import com.ibm.xylem.ITypeStore;
import com.ibm.xylem.IdentityHashMap;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleImportDirective;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.Program;
import com.ibm.xylem.TailRecursiveOptimizer;
import com.ibm.xylem.TopLevelModuleImportDirective;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.MatchInstruction;
import com.ibm.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xylem.types.AbstractDataType;
import com.ibm.xylem.types.ClassType;
import com.ibm.xylem.types.CompoundType;
import com.ibm.xylem.types.IntType;
import com.ibm.xylem.utils.XylemError;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class ModuleLinker {
    protected static void flattenADTs(Program program, ITypeStore iTypeStore, String string, IdentityHashMap identityHashMap) {
        CompoundType compoundType;
        Iterator iterator = iTypeStore.getAbstractDataTypesIterator();
        while (iterator.hasNext()) {
            compoundType = (AbstractDataType)iterator.next();
            if (identityHashMap.containsKey(compoundType)) continue;
            identityHashMap.put(compoundType, compoundType);
            program.addAbstractDataType((AbstractDataType)compoundType);
        }
        iterator = iTypeStore.getClassesIterator();
        while (iterator.hasNext()) {
            compoundType = (ClassType)iterator.next();
            if (identityHashMap.containsKey(compoundType)) continue;
            identityHashMap.put(compoundType, compoundType);
            for (ClassType.Method method : ((ClassType)compoundType).m_methods.values()) {
                method.setFunction(ModuleImportDirective.translateFunctionName(method.getFunction(), string));
            }
            program.addClass((ClassType)compoundType);
        }
    }

    protected static void flattenModule(Program program, Module module, ArrayList arrayList, HashSet hashSet, Collection collection, IdentityHashMap identityHashMap, final boolean bl) {
        Serializable serializable;
        Object object2;
        if (!bl) {
            ModuleLinker.flattenADTs(program, module, module.getName(), identityHashMap);
            ModuleLinker.flattenADTs(program, module.m_signature, module.getName(), identityHashMap);
        }
        Iterator iterator = module.m_moduleDefinitions.iterator();
        while (iterator.hasNext()) {
            object2 = (Module)module.m_modules.get(iterator.next());
            ModuleLinker.flattenModule(program, (Module)object2, arrayList, hashSet, collection, identityHashMap, false);
            iterator.remove();
        }
        for (Object object2 : module.getFunctors()) {
            ModuleLinker.convertFunctor(program, (Functor)object2);
        }
        for (Object object2 : module.getModuleImportDirectives()) {
            if (object2 instanceof FunctorApplicationDirective) {
                serializable = (FunctorApplicationDirective)object2;
                arrayList.add(serializable);
                hashSet.add(module.getFunctor(((FunctorApplicationDirective)serializable).m_functorName));
            } else if (object2 instanceof TopLevelModuleImportDirective) {
                ModuleLinker.flattenADTs(program, ((ModuleImportDirective)object2).getSignature(), ((TopLevelModuleImportDirective)object2).getModuleName(), identityHashMap);
                continue;
            }
            ModuleLinker.flattenADTs(program, ((ModuleImportDirective)object2).getSignature(), "", identityHashMap);
        }
        module.getFunctors().clear();
        iterator = module.getFunctions().iterator();
        object2 = new IdentityHashMap();
        while (iterator.hasNext()) {
            serializable = (Function)iterator.next();
            ((Function)serializable).m_name = ModuleImportDirective.translateFunctionName(((Function)serializable).getName(), module);
            new TailRecursiveOptimizer((IdentityHashMap)object2){
                Module m_m;
                final /* synthetic */ IdentityHashMap val$convertedFCIs;
                {
                    this.val$convertedFCIs = identityHashMap;
                }

                @Override
                protected Instruction optimizeStep2(Instruction instruction) {
                    if (!bl && instruction instanceof FunctionCallInstruction) {
                        if (this.val$convertedFCIs.containsKey(instruction)) {
                            return instruction;
                        }
                        FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction;
                        functionCallInstruction.setFunction(ModuleImportDirective.translateFunctionName(functionCallInstruction.getFunction(), this.m_m));
                        this.val$convertedFCIs.put(functionCallInstruction, functionCallInstruction);
                    } else if (instruction instanceof ModuleFunctionCallInstruction) {
                        ModuleFunctionCallInstruction moduleFunctionCallInstruction = (ModuleFunctionCallInstruction)instruction;
                        ModuleImportDirective moduleImportDirective = this.m_m.getModuleImportDirective(moduleFunctionCallInstruction.getModule());
                        if (moduleImportDirective == null) {
                            throw new XylemError("ERR_SYSTEM", "module import not found for moulde '" + moduleFunctionCallInstruction.getModule() + "' in " + moduleFunctionCallInstruction);
                        }
                        return moduleImportDirective.translateFunctionCall(moduleFunctionCallInstruction, this.m_m);
                    }
                    return instruction;
                }

                Optimizer init(Module module) {
                    this.m_m = module;
                    return this;
                }
            }.init(module).optimizeFunction((Function)serializable);
            iterator.remove();
            collection.add(serializable);
        }
        module.m_moduleDefinitions.clear();
        module.m_functors.clear();
    }

    public static void flattenModules(Program program) {
        ModuleLinker.flattenModules(program, false);
    }

    public static void reflattenModules(Program program) {
        ModuleLinker.flattenModules(program, true);
    }

    private static void flattenModules(Program program, boolean bl) {
        ArrayList arrayList = new ArrayList();
        HashSet hashSet = new HashSet();
        ArrayList arrayList2 = new ArrayList();
        IdentityHashMap identityHashMap = new IdentityHashMap();
        ModuleLinker.flattenModule(program, program, arrayList, hashSet, arrayList2, identityHashMap, bl);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            program.addFunction((Function)iterator.next());
        }
        for (Object object : hashSet) {
            ModuleSignature[] moduleSignatureArray = ((Functor)object).getParameters();
            Object object2 = ((Functor)object).getParameterNames();
            HashSet<FunctorApplicationDirective> hashSet2 = new HashSet<FunctorApplicationDirective>();
            for (FunctorApplicationDirective functorApplicationDirective : arrayList) {
                if (!functorApplicationDirective.m_functorName.equals(((Functor)object).getName())) continue;
                hashSet2.add(functorApplicationDirective);
            }
            for (int i = 0; i < moduleSignatureArray.length; ++i) {
                for (FunctionSignature functionSignature : ((ModuleSignature)moduleSignatureArray[i]).m_functionSignatures.values()) {
                    Binding[] bindingArray = new Binding[functionSignature.m_parameterTypes.length + 1];
                    Instruction[] instructionArray = new Instruction[functionSignature.m_parameterTypes.length];
                    for (int j = 0; j < instructionArray.length; ++j) {
                        bindingArray[j] = new Binding((Object)("param" + j), functionSignature.m_parameterTypes[j]);
                        instructionArray[j] = new IdentifierInstruction(bindingArray[j].getName());
                    }
                    bindingArray[functionSignature.m_parameterTypes.length] = new Binding((Object)"__functorinstance__", IntType.s_intType);
                    String string = ((Functor)object).getName() + "$functor$" + (String)object2[i] + "$" + functionSignature.getFunctionName();
                    Iterator iterator2 = hashSet2.iterator();
                    int n = 0;
                    MatchInstruction.Match[] matchArray = new MatchInstruction.Match[hashSet2.size()];
                    while (iterator2.hasNext()) {
                        FunctorApplicationDirective functorApplicationDirective = (FunctorApplicationDirective)iterator2.next();
                        matchArray[n++] = new MatchInstruction.LiteralMatch(LiteralInstruction.integerLiteral(functorApplicationDirective.m_index), new FunctionCallInstruction(functorApplicationDirective.m_modulesToApply[i] + "$" + functionSignature.getFunctionName(), instructionArray).cloneWithoutTypeInformation());
                    }
                    program.addFunction(new Function(string, bindingArray, new MatchInstruction((Instruction)new IdentifierInstruction("__functorinstance__"), matchArray, null)));
                }
            }
        }
        iterator = program.getClassesIterator();
        while (iterator.hasNext()) {
            Object object;
            object = (ClassType)iterator.next();
            for (Object object2 : ((ClassType)object).m_methods.values()) {
                program.forceFunctionGeneration(program.getFunction(((ClassType.Method)object2).getFunction()));
            }
            program.addClass((ClassType)object);
        }
        program.clearTypeInformation(false);
    }

    protected static void convertFunctor(Program program, Functor functor) {
        Module module = functor.getBody();
        Iterator iterator = module.getFunctions().iterator();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            function.m_name = ModuleImportDirective.translateFunctionName(function.getName(), module);
            Binding[] bindingArray = new Binding[function.m_parameters.length + 1];
            System.arraycopy(function.m_parameters, 0, bindingArray, 0, function.m_parameters.length);
            bindingArray[function.m_parameters.length] = new Binding((Object)"__functorinstance__", IntType.s_intType);
            function.m_parameters = bindingArray;
            new TailRecursiveOptimizer(){
                Module m_m;

                @Override
                protected Instruction optimizeStep2(Instruction instruction) {
                    if (instruction instanceof FunctionCallInstruction) {
                        FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction;
                        Instruction[] instructionArray = new Instruction[functionCallInstruction.m_parameters.length + 1];
                        System.arraycopy(functionCallInstruction.m_parameters, 0, instructionArray, 0, functionCallInstruction.m_parameters.length);
                        instructionArray[functionCallInstruction.m_parameters.length] = new IdentifierInstruction("__functorinstance__");
                        return new FunctionCallInstruction(ModuleImportDirective.translateFunctionName(functionCallInstruction.getFunction(), this.m_m), instructionArray);
                    }
                    if (instruction instanceof ModuleFunctionCallInstruction) {
                        ModuleFunctionCallInstruction moduleFunctionCallInstruction = (ModuleFunctionCallInstruction)instruction;
                        ModuleImportDirective moduleImportDirective = this.m_m.getModuleImportDirective(moduleFunctionCallInstruction.getModule());
                        return moduleImportDirective.translateFunctionCall(moduleFunctionCallInstruction, this.m_m);
                    }
                    return instruction;
                }

                Optimizer init(Module module) {
                    this.m_m = module;
                    return this;
                }
            }.init(module).optimizeFunction(function);
            program.addFunction(function);
            iterator.remove();
        }
    }
}

