/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.runtime;

import com.ibm.xtq.common.utils.DOM2Helper;
import com.ibm.xtq.common.utils.TreeWalker;
import com.ibm.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xtq.xslt.runtime.Converter;
import com.ibm.xtq.xslt.runtime.DOMBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serializer.DOMSerializer;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.SerializationHandler;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.apache.xml.serializer.ToHTMLSAXHandler;
import org.apache.xml.serializer.ToTextSAXHandler;
import org.apache.xml.serializer.ToXMLSAXHandler;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

class ConverterImpl
implements Converter,
DOMSerializer {
    private final int TYPE_UNDEFINED = 0;
    private final int TYPE_SAX_LIKE = 1;
    private final int TYPE_SAX = 2;
    private final int TYPE_DOM = 3;
    private final int TYPE_STREAM = 4;
    private int type_output = 0;
    private Properties m_props = null;
    private Writer m_outputWriter;
    private OutputStream m_outputStream;
    private Node m_outputNode;
    private Node m_nextSibling;
    private ContentHandler m_outputContentHandler;
    private LexicalHandler m_outputLexicalHandler;
    private SerializationHandler m_outputSerializationHandler;
    private SerializationHandler m_asSerializationHandler = null;

    ConverterImpl() {
    }

    @Override
    public void setOutputFormat(Properties properties) {
        if (properties != null) {
            if (this.m_props == null) {
                this.m_props = new OutputPropertiesFactory.SerializerProps(properties);
            } else {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = properties.getProperty(string);
                    this.m_props.put(string, string2);
                }
            }
        } else {
            this.m_props = null;
        }
    }

    @Override
    public Properties getOutputFormat() {
        return this.m_props;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.type_output = 4;
        this.m_outputStream = outputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return null;
    }

    @Override
    public void setOutputWriter(Writer writer) {
        this.type_output = 4;
        this.m_outputWriter = writer;
    }

    @Override
    public Writer getOutputWriter() {
        return this.m_outputWriter;
    }

    @Override
    public void setOutputContentHandler(ContentHandler contentHandler) {
        this.type_output = 2;
        this.m_outputContentHandler = contentHandler;
    }

    @Override
    public ContentHandler getOutputContentHandler() {
        return this.m_outputContentHandler;
    }

    @Override
    public void setOutputSerializationHandler(SerializationHandler serializationHandler) {
        this.type_output = 1;
        this.m_outputSerializationHandler = serializationHandler;
    }

    @Override
    public SerializationHandler getOutputSerializationHandler() {
        return this.m_outputSerializationHandler;
    }

    @Override
    public void setOutputDOM(Node node) {
        this.type_output = 3;
        this.m_outputNode = node;
    }

    @Override
    public void setNextSibling(Node node) {
        this.type_output = 3;
        this.m_nextSibling = node;
    }

    @Override
    public Node getOutputDOM() {
        Node node;
        if (this.m_outputContentHandler != null && this.m_outputContentHandler instanceof DOMBuilder && (node = ((DOMBuilder)this.m_outputContentHandler).getRootDocument()) != null) {
            return node;
        }
        return this.m_outputNode;
    }

    @Override
    public ContentHandler getInputContentHandler() throws IOException {
        return this.getInputSerializationHandler(null);
    }

    @Override
    public SerializationHandler getInputSerializationHandler(SerializationHandler serializationHandler) {
        SerializationHandler serializationHandler2 = null;
        if (this.m_asSerializationHandler != null) {
            serializationHandler2 = this.m_asSerializationHandler;
        } else {
            this.init();
            String string = this.m_props == null ? "xml" : this.m_props.getProperty("method");
            switch (this.type_output) {
                case 4: {
                    Serializer serializer;
                    if (serializationHandler == null || !serializationHandler.reset()) {
                        serializer = SerializerFactory.getSerializer(this.m_props);
                    } else {
                        serializationHandler.setOutputFormat(this.m_props);
                        serializer = serializationHandler;
                    }
                    if (!(serializer instanceof SerializationHandler)) {
                        serializationHandler2 = new ToXMLSAXHandler();
                        try {
                            serializationHandler2.setContentHandler(serializer.asContentHandler());
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    serializationHandler2 = (SerializationHandler)serializer;
                    if (this.m_outputWriter != null) {
                        serializationHandler2.setWriter(this.m_outputWriter);
                        break;
                    }
                    serializationHandler2.setOutputStream(this.m_outputStream);
                    break;
                }
                case 3: {
                    try {
                        if (this.m_outputNode != null) {
                            Document document;
                            short s = this.m_outputNode.getNodeType();
                            Document document2 = document = s == 9 ? (Document)this.m_outputNode : this.m_outputNode.getOwnerDocument();
                            this.m_outputContentHandler = s == 11 ? new DOMBuilder(document, (DocumentFragment)this.m_outputNode) : new DOMBuilder(document, this.m_outputNode);
                        } else {
                            this.m_outputContentHandler = new DOMBuilder();
                        }
                        if (this.m_nextSibling != null) {
                            ((DOMBuilder)this.m_outputContentHandler).setNextSibling(this.m_nextSibling);
                        }
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        parserConfigurationException.printStackTrace();
                    }
                }
                case 2: {
                    if (string == null || "".equals(string)) {
                        string = "xml";
                    }
                    if (string.equalsIgnoreCase("xml")) {
                        if (this.m_outputLexicalHandler == null) {
                            serializationHandler2 = new ToXMLSAXHandler();
                            serializationHandler2.setContentHandler(this.m_outputContentHandler);
                            break;
                        }
                        serializationHandler2 = new ToXMLSAXHandler(this.m_outputContentHandler, this.m_outputLexicalHandler);
                        break;
                    }
                    if (string.equalsIgnoreCase("html") || string.equalsIgnoreCase("xhtml")) {
                        if (this.m_outputLexicalHandler == null) {
                            serializationHandler2 = new ToHTMLSAXHandler(this.m_outputContentHandler, this.m_outputLexicalHandler);
                            break;
                        }
                        serializationHandler2 = new ToHTMLSAXHandler(this.m_outputContentHandler);
                        break;
                    }
                    if (!string.equalsIgnoreCase("text")) break;
                    if (this.m_outputLexicalHandler == null) {
                        serializationHandler2 = new ToTextSAXHandler(this.m_outputContentHandler);
                        break;
                    }
                    serializationHandler2 = new ToTextSAXHandler(this.m_outputContentHandler, this.m_outputLexicalHandler);
                    break;
                }
                case 1: {
                    serializationHandler2 = this.m_outputSerializationHandler;
                }
            }
            this.m_asSerializationHandler = serializationHandler2;
        }
        return serializationHandler2;
    }

    @Override
    public DOMSerializer getInputDOMSerializer() {
        return this;
    }

    @Override
    public boolean reset() {
        boolean bl = false;
        if (this.m_asSerializationHandler != null) {
            bl = this.m_asSerializationHandler.reset();
        }
        return bl;
    }

    @Override
    public void serialize(Node node) throws IOException {
        try {
            TreeWalker treeWalker = new TreeWalker(this.m_outputContentHandler, new DOM2Helper());
            treeWalker.traverse(node);
        }
        catch (SAXException sAXException) {
            throw new WrappedRuntimeException(sAXException);
        }
    }

    @Override
    public void setOutputLexicalHandler(LexicalHandler lexicalHandler) {
        this.m_outputLexicalHandler = lexicalHandler;
    }

    private void init() {
        switch (this.type_output) {
            case 4: {
                if (this.m_props != null) break;
                Properties properties = OutputPropertiesFactory.getDefaultMethodProperties("");
                this.setOutputFormat(properties);
                break;
            }
        }
    }
}

