/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.types;

import com.ibm.xtq.xml.types.AnyAtomicType;
import com.ibm.xtq.xml.types.CollectionType;
import com.ibm.xtq.xml.types.OccurrenceIndicator;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.TypeFactory;
import com.ibm.xtq.xml.types.XSequenceType;

public class AggregateType
extends CollectionType {
    private AnyAtomicType m_homogeneousAtomicType = null;
    private boolean m_allAtomicItemTypes = true;

    public AggregateType() {
    }

    public AggregateType(Type type) {
        this.addType(type);
    }

    public AggregateType(Type type, Type type2) {
        this.addType(type);
        this.addType(type2);
    }

    public AnyAtomicType getHomogeneousAtomicType() {
        return this.m_homogeneousAtomicType;
    }

    public boolean allAtomicItemTypes() {
        return this.m_allAtomicItemTypes;
    }

    @Override
    public void addType(Type type) {
        this.m_types.add(type);
        if (!this.m_hasNodeType && type.mayContainNodeType()) {
            this.m_hasNodeType = true;
            this.m_allAtomicItemTypes = false;
        }
        if (this.m_allAtomicItemTypes) {
            OccurrenceIndicator occurrenceIndicator = type.getQuantifier();
            if (occurrenceIndicator == OccurrenceIndicator.ONE || occurrenceIndicator == OccurrenceIndicator.ZERO_OR_ONE) {
                Type type2 = type.getPrimeType();
                if (type2 instanceof AnyAtomicType) {
                    if (this.m_types.size() == 1) {
                        this.m_homogeneousAtomicType = (AnyAtomicType)type2;
                    } else if (this.m_homogeneousAtomicType != null && this.m_homogeneousAtomicType != type2) {
                        this.m_homogeneousAtomicType = null;
                    }
                } else {
                    this.m_homogeneousAtomicType = null;
                }
            } else {
                this.m_allAtomicItemTypes = false;
            }
        }
    }

    @Override
    public OccurrenceIndicator getQuantifier() {
        int n = this.m_types.size();
        OccurrenceIndicator occurrenceIndicator = this.get(0).getQuantifier();
        for (int i = 1; i < n; ++i) {
            occurrenceIndicator = occurrenceIndicator.sum(this.get(i).getQuantifier());
        }
        if (this.canBeEmpty()) {
            return occurrenceIndicator.product(OccurrenceIndicator.ZERO_OR_ONE);
        }
        return occurrenceIndicator;
    }

    @Override
    public Type getApproximateType() {
        return TypeFactory.newType(this.getPrimeType(), this.getQuantifier());
    }

    @Override
    public Type getAtomizedType() {
        if (!this.m_hasNodeType) {
            return this;
        }
        int n = this.size();
        AggregateType aggregateType = new AggregateType(this.get(0).getAtomizedType());
        for (int i = 1; i < n; ++i) {
            aggregateType.addType(this.get(i).getAtomizedType());
        }
        return aggregateType;
    }

    @Override
    public String getRuntimeType() {
        return "com.ibm.xtq.xml.datamodel.XSequence";
    }

    @Override
    public int castableAs(AnyAtomicType anyAtomicType, boolean bl) {
        if (this.getQuantifier() == OccurrenceIndicator.TWO_OR_MORE) {
            return 0;
        }
        return 2;
    }

    @Override
    public int typeMatches(XSequenceType xSequenceType, boolean bl) {
        OccurrenceIndicator occurrenceIndicator;
        if (this.canBeEmpty()) {
            return 2;
        }
        OccurrenceIndicator occurrenceIndicator2 = this.getQuantifier();
        int n = occurrenceIndicator2.matches(occurrenceIndicator = xSequenceType.getQuantifier());
        if (n == 0) {
            return 0;
        }
        int n2 = this.size();
        boolean bl2 = false;
        boolean bl3 = false;
        if (occurrenceIndicator == OccurrenceIndicator.ONE) {
            xSequenceType = new XSequenceType(xSequenceType.getBaseType(), OccurrenceIndicator.ZERO_OR_ONE);
        } else if (occurrenceIndicator == OccurrenceIndicator.ONE_OR_MORE) {
            xSequenceType = new XSequenceType(xSequenceType.getBaseType(), OccurrenceIndicator.ZERO_OR_MORE);
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = this.get(i).typeMatches(xSequenceType, bl);
            if (n3 == 0) {
                return 0;
            }
            if (n3 == 2) {
                bl2 = true;
                continue;
            }
            if (n3 != 3) continue;
            bl3 = true;
        }
        return bl2 ? 2 : (bl3 ? 3 : 1);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.get(i).toString());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof AggregateType) {
            AggregateType aggregateType = (AggregateType)object;
            int n = this.size();
            if (n == aggregateType.size()) {
                for (int i = 0; i < n; ++i) {
                    if (this.get(i) == aggregateType.get(i)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

