/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.common.utils;

import java.util.Random;

public final class PerSessionHash {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2012. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String DISABLE_SECURE_HASH = "com.ibm.xtq.processor.disableSecureHash";
    private static final boolean useSecureHash;
    protected static int[] _substitute8;
    protected static int[] _substitute;

    protected static void shuffle(Random random, int[] nArray) {
        int n = nArray.length;
        for (int i = n - 1; i >= 0; --i) {
            int n2 = random.nextInt(n);
            int n3 = nArray[i];
            nArray[i] = nArray[n2];
            nArray[n2] = n3;
        }
    }

    public static int hash(String string) {
        if (!useSecureHash) {
            return string.hashCode();
        }
        int n = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            n = (n << 5) + n + _substitute8[c >> 8];
            n = (n << 5) + n + _substitute[c & 0xFF];
        }
        return n;
    }

    static {
        int n;
        boolean bl = false;
        try {
            String string = System.getProperty(DISABLE_SECURE_HASH);
            bl = "true".equalsIgnoreCase(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        useSecureHash = !bl;
        Random random = new Random();
        _substitute = new int[256];
        for (n = 255; n >= 0; --n) {
            PerSessionHash._substitute[n] = n;
        }
        PerSessionHash.shuffle(random, _substitute);
        _substitute8 = new int[256];
        for (n = 255; n >= 0; --n) {
            PerSessionHash._substitute8[n] = n;
        }
        PerSessionHash.shuffle(random, _substitute8);
    }
}

