/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.bcel.verifier.structurals;

import com.ibm.xtq.bcel.Repository;
import com.ibm.xtq.bcel.classfile.AccessFlags;
import com.ibm.xtq.bcel.classfile.Constant;
import com.ibm.xtq.bcel.classfile.ConstantClass;
import com.ibm.xtq.bcel.classfile.ConstantDouble;
import com.ibm.xtq.bcel.classfile.ConstantFieldref;
import com.ibm.xtq.bcel.classfile.ConstantFloat;
import com.ibm.xtq.bcel.classfile.ConstantInteger;
import com.ibm.xtq.bcel.classfile.ConstantLong;
import com.ibm.xtq.bcel.classfile.ConstantString;
import com.ibm.xtq.bcel.classfile.Field;
import com.ibm.xtq.bcel.classfile.FieldOrMethod;
import com.ibm.xtq.bcel.classfile.JavaClass;
import com.ibm.xtq.bcel.generic.AALOAD;
import com.ibm.xtq.bcel.generic.AASTORE;
import com.ibm.xtq.bcel.generic.ACONST_NULL;
import com.ibm.xtq.bcel.generic.ALOAD;
import com.ibm.xtq.bcel.generic.ANEWARRAY;
import com.ibm.xtq.bcel.generic.ARETURN;
import com.ibm.xtq.bcel.generic.ARRAYLENGTH;
import com.ibm.xtq.bcel.generic.ASTORE;
import com.ibm.xtq.bcel.generic.ATHROW;
import com.ibm.xtq.bcel.generic.ArrayType;
import com.ibm.xtq.bcel.generic.BALOAD;
import com.ibm.xtq.bcel.generic.BASTORE;
import com.ibm.xtq.bcel.generic.BIPUSH;
import com.ibm.xtq.bcel.generic.BREAKPOINT;
import com.ibm.xtq.bcel.generic.CALOAD;
import com.ibm.xtq.bcel.generic.CASTORE;
import com.ibm.xtq.bcel.generic.CHECKCAST;
import com.ibm.xtq.bcel.generic.CPInstruction;
import com.ibm.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xtq.bcel.generic.D2F;
import com.ibm.xtq.bcel.generic.D2I;
import com.ibm.xtq.bcel.generic.D2L;
import com.ibm.xtq.bcel.generic.DADD;
import com.ibm.xtq.bcel.generic.DALOAD;
import com.ibm.xtq.bcel.generic.DASTORE;
import com.ibm.xtq.bcel.generic.DCMPG;
import com.ibm.xtq.bcel.generic.DCMPL;
import com.ibm.xtq.bcel.generic.DCONST;
import com.ibm.xtq.bcel.generic.DDIV;
import com.ibm.xtq.bcel.generic.DLOAD;
import com.ibm.xtq.bcel.generic.DMUL;
import com.ibm.xtq.bcel.generic.DNEG;
import com.ibm.xtq.bcel.generic.DREM;
import com.ibm.xtq.bcel.generic.DRETURN;
import com.ibm.xtq.bcel.generic.DSTORE;
import com.ibm.xtq.bcel.generic.DSUB;
import com.ibm.xtq.bcel.generic.DUP;
import com.ibm.xtq.bcel.generic.DUP2;
import com.ibm.xtq.bcel.generic.DUP2_X1;
import com.ibm.xtq.bcel.generic.DUP2_X2;
import com.ibm.xtq.bcel.generic.DUP_X1;
import com.ibm.xtq.bcel.generic.DUP_X2;
import com.ibm.xtq.bcel.generic.EmptyVisitor;
import com.ibm.xtq.bcel.generic.F2D;
import com.ibm.xtq.bcel.generic.F2I;
import com.ibm.xtq.bcel.generic.F2L;
import com.ibm.xtq.bcel.generic.FADD;
import com.ibm.xtq.bcel.generic.FALOAD;
import com.ibm.xtq.bcel.generic.FASTORE;
import com.ibm.xtq.bcel.generic.FCMPG;
import com.ibm.xtq.bcel.generic.FCMPL;
import com.ibm.xtq.bcel.generic.FCONST;
import com.ibm.xtq.bcel.generic.FDIV;
import com.ibm.xtq.bcel.generic.FLOAD;
import com.ibm.xtq.bcel.generic.FMUL;
import com.ibm.xtq.bcel.generic.FNEG;
import com.ibm.xtq.bcel.generic.FREM;
import com.ibm.xtq.bcel.generic.FRETURN;
import com.ibm.xtq.bcel.generic.FSTORE;
import com.ibm.xtq.bcel.generic.FSUB;
import com.ibm.xtq.bcel.generic.FieldInstruction;
import com.ibm.xtq.bcel.generic.GETFIELD;
import com.ibm.xtq.bcel.generic.GETSTATIC;
import com.ibm.xtq.bcel.generic.GOTO;
import com.ibm.xtq.bcel.generic.GOTO_W;
import com.ibm.xtq.bcel.generic.I2B;
import com.ibm.xtq.bcel.generic.I2C;
import com.ibm.xtq.bcel.generic.I2D;
import com.ibm.xtq.bcel.generic.I2F;
import com.ibm.xtq.bcel.generic.I2L;
import com.ibm.xtq.bcel.generic.I2S;
import com.ibm.xtq.bcel.generic.IADD;
import com.ibm.xtq.bcel.generic.IALOAD;
import com.ibm.xtq.bcel.generic.IAND;
import com.ibm.xtq.bcel.generic.IASTORE;
import com.ibm.xtq.bcel.generic.ICONST;
import com.ibm.xtq.bcel.generic.IDIV;
import com.ibm.xtq.bcel.generic.IFEQ;
import com.ibm.xtq.bcel.generic.IFGE;
import com.ibm.xtq.bcel.generic.IFGT;
import com.ibm.xtq.bcel.generic.IFLE;
import com.ibm.xtq.bcel.generic.IFLT;
import com.ibm.xtq.bcel.generic.IFNE;
import com.ibm.xtq.bcel.generic.IFNONNULL;
import com.ibm.xtq.bcel.generic.IFNULL;
import com.ibm.xtq.bcel.generic.IF_ACMPEQ;
import com.ibm.xtq.bcel.generic.IF_ACMPNE;
import com.ibm.xtq.bcel.generic.IF_ICMPEQ;
import com.ibm.xtq.bcel.generic.IF_ICMPGE;
import com.ibm.xtq.bcel.generic.IF_ICMPGT;
import com.ibm.xtq.bcel.generic.IF_ICMPLE;
import com.ibm.xtq.bcel.generic.IF_ICMPLT;
import com.ibm.xtq.bcel.generic.IF_ICMPNE;
import com.ibm.xtq.bcel.generic.IINC;
import com.ibm.xtq.bcel.generic.ILOAD;
import com.ibm.xtq.bcel.generic.IMPDEP1;
import com.ibm.xtq.bcel.generic.IMPDEP2;
import com.ibm.xtq.bcel.generic.IMUL;
import com.ibm.xtq.bcel.generic.INEG;
import com.ibm.xtq.bcel.generic.INSTANCEOF;
import com.ibm.xtq.bcel.generic.INVOKEINTERFACE;
import com.ibm.xtq.bcel.generic.INVOKESPECIAL;
import com.ibm.xtq.bcel.generic.INVOKESTATIC;
import com.ibm.xtq.bcel.generic.INVOKEVIRTUAL;
import com.ibm.xtq.bcel.generic.IOR;
import com.ibm.xtq.bcel.generic.IREM;
import com.ibm.xtq.bcel.generic.IRETURN;
import com.ibm.xtq.bcel.generic.ISHL;
import com.ibm.xtq.bcel.generic.ISHR;
import com.ibm.xtq.bcel.generic.ISTORE;
import com.ibm.xtq.bcel.generic.ISUB;
import com.ibm.xtq.bcel.generic.IUSHR;
import com.ibm.xtq.bcel.generic.IXOR;
import com.ibm.xtq.bcel.generic.Instruction;
import com.ibm.xtq.bcel.generic.InvokeInstruction;
import com.ibm.xtq.bcel.generic.JSR;
import com.ibm.xtq.bcel.generic.JSR_W;
import com.ibm.xtq.bcel.generic.L2D;
import com.ibm.xtq.bcel.generic.L2F;
import com.ibm.xtq.bcel.generic.L2I;
import com.ibm.xtq.bcel.generic.LADD;
import com.ibm.xtq.bcel.generic.LALOAD;
import com.ibm.xtq.bcel.generic.LAND;
import com.ibm.xtq.bcel.generic.LASTORE;
import com.ibm.xtq.bcel.generic.LCMP;
import com.ibm.xtq.bcel.generic.LCONST;
import com.ibm.xtq.bcel.generic.LDC;
import com.ibm.xtq.bcel.generic.LDC2_W;
import com.ibm.xtq.bcel.generic.LDC_W;
import com.ibm.xtq.bcel.generic.LDIV;
import com.ibm.xtq.bcel.generic.LLOAD;
import com.ibm.xtq.bcel.generic.LMUL;
import com.ibm.xtq.bcel.generic.LNEG;
import com.ibm.xtq.bcel.generic.LOOKUPSWITCH;
import com.ibm.xtq.bcel.generic.LOR;
import com.ibm.xtq.bcel.generic.LREM;
import com.ibm.xtq.bcel.generic.LRETURN;
import com.ibm.xtq.bcel.generic.LSHL;
import com.ibm.xtq.bcel.generic.LSHR;
import com.ibm.xtq.bcel.generic.LSTORE;
import com.ibm.xtq.bcel.generic.LSUB;
import com.ibm.xtq.bcel.generic.LUSHR;
import com.ibm.xtq.bcel.generic.LXOR;
import com.ibm.xtq.bcel.generic.LoadClass;
import com.ibm.xtq.bcel.generic.LoadInstruction;
import com.ibm.xtq.bcel.generic.LocalVariableInstruction;
import com.ibm.xtq.bcel.generic.MONITORENTER;
import com.ibm.xtq.bcel.generic.MONITOREXIT;
import com.ibm.xtq.bcel.generic.MULTIANEWARRAY;
import com.ibm.xtq.bcel.generic.MethodGen;
import com.ibm.xtq.bcel.generic.NEW;
import com.ibm.xtq.bcel.generic.NEWARRAY;
import com.ibm.xtq.bcel.generic.NOP;
import com.ibm.xtq.bcel.generic.ObjectType;
import com.ibm.xtq.bcel.generic.POP;
import com.ibm.xtq.bcel.generic.POP2;
import com.ibm.xtq.bcel.generic.PUTFIELD;
import com.ibm.xtq.bcel.generic.PUTSTATIC;
import com.ibm.xtq.bcel.generic.RET;
import com.ibm.xtq.bcel.generic.RETURN;
import com.ibm.xtq.bcel.generic.ReferenceType;
import com.ibm.xtq.bcel.generic.ReturnInstruction;
import com.ibm.xtq.bcel.generic.ReturnaddressType;
import com.ibm.xtq.bcel.generic.SALOAD;
import com.ibm.xtq.bcel.generic.SASTORE;
import com.ibm.xtq.bcel.generic.SIPUSH;
import com.ibm.xtq.bcel.generic.SWAP;
import com.ibm.xtq.bcel.generic.StackConsumer;
import com.ibm.xtq.bcel.generic.StackInstruction;
import com.ibm.xtq.bcel.generic.StackProducer;
import com.ibm.xtq.bcel.generic.StoreInstruction;
import com.ibm.xtq.bcel.generic.TABLESWITCH;
import com.ibm.xtq.bcel.generic.Type;
import com.ibm.xtq.bcel.generic.TypeConstants;
import com.ibm.xtq.bcel.generic.Visitor;
import com.ibm.xtq.bcel.verifier.VerificationResult;
import com.ibm.xtq.bcel.verifier.Verifier;
import com.ibm.xtq.bcel.verifier.VerifierFactory;
import com.ibm.xtq.bcel.verifier.exc.AssertionViolatedException;
import com.ibm.xtq.bcel.verifier.exc.StructuralCodeConstraintException;
import com.ibm.xtq.bcel.verifier.structurals.Frame;
import com.ibm.xtq.bcel.verifier.structurals.LocalVariables;
import com.ibm.xtq.bcel.verifier.structurals.OperandStack;
import com.ibm.xtq.bcel.verifier.structurals.UninitializedObjectType;

public class InstConstraintVisitor
extends EmptyVisitor
implements Visitor {
    private static ObjectType GENERIC_ARRAY = new ObjectType("com.ibm.xtq.bcel.verifier.structurals.GenericArray");
    private Frame frame = null;
    private ConstantPoolGen cpg = null;
    private MethodGen mg = null;

    private OperandStack stack() {
        return this.frame.getStack();
    }

    private LocalVariables locals() {
        return this.frame.getLocals();
    }

    private void constraintViolated(Instruction violator, String description) {
        String fq_classname = violator.getClass().getName();
        throw new StructuralCodeConstraintException("Instruction " + fq_classname.substring(fq_classname.lastIndexOf(46) + 1) + " constraint violated: " + description);
    }

    public void setFrame(Frame f) {
        this.frame = f;
    }

    public void setConstantPoolGen(ConstantPoolGen cpg) {
        this.cpg = cpg;
    }

    public void setMethodGen(MethodGen mg) {
        this.mg = mg;
    }

    private void indexOfInt(Instruction o, Type index) {
        if (!index.equals(TypeConstants.INT)) {
            this.constraintViolated(o, "The 'index' is not of type int but of type " + index + ".");
        }
    }

    private void referenceTypeIsInitialized(Instruction o, ReferenceType r) {
        if (r instanceof UninitializedObjectType) {
            this.constraintViolated(o, "Working on an uninitialized object '" + r + "'.");
        }
    }

    private void valueOfInt(Instruction o, Type value) {
        if (!value.equals(TypeConstants.INT)) {
            this.constraintViolated(o, "The 'value' is not of type int but of type " + value + ".");
        }
    }

    private boolean arrayrefOfArrayType(Instruction o, Type arrayref) {
        if (!(arrayref instanceof ArrayType) && !arrayref.equals(TypeConstants.NULL)) {
            this.constraintViolated(o, "The 'arrayref' does not refer to an array but is of type " + arrayref + ".");
        }
        return arrayref instanceof ArrayType;
    }

    private void _visitStackAccessor(Instruction o) {
        int produce;
        int consume = o.consumeStack(this.cpg);
        if (consume > this.stack().slotsUsed()) {
            this.constraintViolated(o, "Cannot consume " + consume + " stack slots: only " + this.stack().slotsUsed() + " slot(s) left on stack!\nStack:\n" + this.stack());
        }
        if ((produce = o.produceStack(this.cpg) - o.consumeStack(this.cpg)) + this.stack().slotsUsed() > this.stack().maxStack()) {
            this.constraintViolated(o, "Cannot produce " + produce + " stack slots: only " + (this.stack().maxStack() - this.stack().slotsUsed()) + " free stack slot(s) left.\nStack:\n" + this.stack());
        }
    }

    public void visitLoadClass(LoadClass o) {
        Verifier v;
        VerificationResult vr;
        ObjectType t = o.getLoadClassType(this.cpg);
        if (t != null && (vr = (v = VerifierFactory.getVerifier(t.getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated((Instruction)((Object)o), "Class '" + o.getLoadClassType(this.cpg).getClassName() + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
    }

    public void visitStackConsumer(StackConsumer o) {
        this._visitStackAccessor((Instruction)((Object)o));
    }

    public void visitStackProducer(StackProducer o) {
        this._visitStackAccessor((Instruction)((Object)o));
    }

    public void visitCPInstruction(CPInstruction o) {
        int idx = o.getIndex();
        if (idx < 0 || idx >= this.cpg.getSize()) {
            throw new AssertionViolatedException("Huh?! Constant pool index of instruction '" + o + "' illegal? Pass 3a should have checked this!");
        }
    }

    public void visitFieldInstruction(FieldInstruction o) {
        String name;
        Verifier v;
        VerificationResult vr;
        Type t;
        Constant c = this.cpg.getConstant(o.getIndex());
        if (!(c instanceof ConstantFieldref)) {
            this.constraintViolated(o, "Index '" + o.getIndex() + "' should refer to a CONSTANT_Fieldref_info structure, but refers to '" + c + "'.");
        }
        if ((t = o.getType(this.cpg)) instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(name = ((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated(o, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
    }

    public void visitInvokeInstruction(InvokeInstruction o) {
    }

    public void visitStackInstruction(StackInstruction o) {
        this._visitStackAccessor(o);
    }

    public void visitLocalVariableInstruction(LocalVariableInstruction o) {
        if (this.locals().maxLocals() <= (o.getType(this.cpg).getSize() == 1 ? o.getIndex() : o.getIndex() + 1)) {
            this.constraintViolated(o, "The 'index' is not a valid index into the local variable array.");
        }
    }

    public void visitLoadInstruction(LoadInstruction o) {
        if (this.locals().get(o.getIndex()) == TypeConstants.UNKNOWN) {
            this.constraintViolated(o, "Read-Access on local variable " + o.getIndex() + " with unknown content.");
        }
        if (o.getType(this.cpg).getSize() == 2 && this.locals().get(o.getIndex() + 1) != TypeConstants.UNKNOWN) {
            this.constraintViolated(o, "Reading a two-locals value from local variables " + o.getIndex() + " and " + (o.getIndex() + 1) + " where the latter one is destroyed.");
        }
        if (!(o instanceof ALOAD)) {
            if (this.locals().get(o.getIndex()) != o.getType(this.cpg)) {
                this.constraintViolated(o, "Local Variable type and LOADing Instruction type mismatch: Local Variable: '" + this.locals().get(o.getIndex()) + "'; Instruction type: '" + o.getType(this.cpg) + "'.");
            }
        } else if (!(this.locals().get(o.getIndex()) instanceof ReferenceType)) {
            this.constraintViolated(o, "Local Variable type and LOADing Instruction type mismatch: Local Variable: '" + this.locals().get(o.getIndex()) + "'; Instruction expects a ReferenceType.");
        }
        if (this.stack().maxStack() - this.stack().slotsUsed() < o.getType(this.cpg).getSize()) {
            this.constraintViolated(o, "Not enough free stack slots to load a '" + o.getType(this.cpg) + "' onto the OperandStack.");
        }
    }

    public void visitStoreInstruction(StoreInstruction o) {
        if (this.stack().isEmpty()) {
            this.constraintViolated(o, "Cannot STORE: Stack to read from is empty.");
        }
        if (!(o instanceof ASTORE)) {
            if (this.stack().peek() != o.getType(this.cpg)) {
                this.constraintViolated(o, "Stack top type and STOREing Instruction type mismatch: Stack top: '" + this.stack().peek() + "'; Instruction type: '" + o.getType(this.cpg) + "'.");
            }
        } else {
            Type stacktop = this.stack().peek();
            if (!(stacktop instanceof ReferenceType) && !(stacktop instanceof ReturnaddressType)) {
                this.constraintViolated(o, "Stack top type and STOREing Instruction type mismatch: Stack top: '" + this.stack().peek() + "'; Instruction expects a ReferenceType or a ReturnadressType.");
            }
            if (stacktop instanceof ReferenceType) {
                this.referenceTypeIsInitialized(o, (ReferenceType)stacktop);
            }
        }
    }

    public void visitReturnInstruction(ReturnInstruction o) {
        if (o instanceof RETURN) {
            return;
        }
        if (o instanceof ARETURN) {
            if (this.stack().peek() == TypeConstants.NULL) {
                return;
            }
            if (!(this.stack().peek() instanceof ReferenceType)) {
                this.constraintViolated(o, "Reference type expected on top of stack, but is: '" + this.stack().peek() + "'.");
            }
            this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
        } else {
            Type method_type = this.mg.getType();
            if (method_type == TypeConstants.BOOLEAN || method_type == TypeConstants.BYTE || method_type == TypeConstants.SHORT || method_type == TypeConstants.CHAR) {
                method_type = TypeConstants.INT;
            }
            if (!method_type.equals(this.stack().peek())) {
                this.constraintViolated(o, "Current method has return type of '" + this.mg.getType() + "' expecting a '" + method_type + "' on top of the stack. But stack top is a '" + this.stack().peek() + "'.");
            }
        }
    }

    public void visitAALOAD(AALOAD o) {
        Type arrayref = this.stack().peek(1);
        Type index = this.stack().peek(0);
        this.indexOfInt(o, index);
        if (this.arrayrefOfArrayType(o, arrayref)) {
            if (!(((ArrayType)arrayref).getElementType() instanceof ReferenceType)) {
                this.constraintViolated(o, "The 'arrayref' does not refer to an array with elements of a ReferenceType but to an array of " + ((ArrayType)arrayref).getElementType() + ".");
            }
            this.referenceTypeIsInitialized(o, (ReferenceType)((ArrayType)arrayref).getElementType());
        }
    }

    public void visitAASTORE(AASTORE o) {
        Type arrayref = this.stack().peek(2);
        Type index = this.stack().peek(1);
        Type value = this.stack().peek(0);
        this.indexOfInt(o, index);
        if (!(value instanceof ReferenceType)) {
            this.constraintViolated(o, "The 'value' is not of a ReferenceType but of type " + value + ".");
        } else {
            this.referenceTypeIsInitialized(o, (ReferenceType)value);
        }
        if (this.arrayrefOfArrayType(o, arrayref)) {
            if (!(((ArrayType)arrayref).getElementType() instanceof ReferenceType)) {
                this.constraintViolated(o, "The 'arrayref' does not refer to an array with elements of a ReferenceType but to an array of " + ((ArrayType)arrayref).getElementType() + ".");
            }
            if (!((ReferenceType)value).isAssignmentCompatibleWith((ReferenceType)((ArrayType)arrayref).getElementType())) {
                this.constraintViolated(o, "The type of 'value' ('" + value + "') is not assignment compatible to the components of the array 'arrayref' refers to. ('" + ((ArrayType)arrayref).getElementType() + "')");
            }
        }
    }

    public void visitACONST_NULL(ACONST_NULL o) {
    }

    public void visitALOAD(ALOAD o) {
    }

    public void visitANEWARRAY(ANEWARRAY o) {
        if (!this.stack().peek().equals(TypeConstants.INT)) {
            this.constraintViolated(o, "The 'count' at the stack top is not of type '" + TypeConstants.INT + "' but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitARETURN(ARETURN o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The 'objectref' at the stack top is not of a ReferenceType but of type '" + this.stack().peek() + "'.");
        }
        ReferenceType objectref = (ReferenceType)this.stack().peek();
        this.referenceTypeIsInitialized(o, objectref);
    }

    public void visitARRAYLENGTH(ARRAYLENGTH o) {
        Type arrayref = this.stack().peek(0);
        this.arrayrefOfArrayType(o, arrayref);
    }

    public void visitASTORE(ASTORE o) {
        if (!(this.stack().peek() instanceof ReferenceType) && !(this.stack().peek() instanceof ReturnaddressType)) {
            this.constraintViolated(o, "The 'objectref' is not of a ReferenceType or of ReturnaddressType but of " + this.stack().peek() + ".");
        }
        if (this.stack().peek() instanceof ReferenceType) {
            this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
        }
    }

    public void visitATHROW(ATHROW o) {
        ObjectType throwable;
        if (!(this.stack().peek() instanceof ObjectType) && !this.stack().peek().equals(TypeConstants.NULL)) {
            this.constraintViolated(o, "The 'objectref' is not of an (initialized) ObjectType but of type " + this.stack().peek() + ".");
        }
        if (this.stack().peek().equals(TypeConstants.NULL)) {
            return;
        }
        ObjectType exc = (ObjectType)this.stack().peek();
        if (!exc.subclassOf(throwable = (ObjectType)Type.getType("Ljava/lang/Throwable;")) && !exc.equals(throwable)) {
            this.constraintViolated(o, "The 'objectref' is not of class Throwable or of a subclass of Throwable, but of '" + this.stack().peek() + "'.");
        }
    }

    public void visitBALOAD(BALOAD o) {
        Type arrayref = this.stack().peek(1);
        Type index = this.stack().peek(0);
        this.indexOfInt(o, index);
        if (this.arrayrefOfArrayType(o, arrayref) && !((ArrayType)arrayref).getElementType().equals(TypeConstants.BOOLEAN) && !((ArrayType)arrayref).getElementType().equals(TypeConstants.BYTE)) {
            this.constraintViolated(o, "The 'arrayref' does not refer to an array with elements of a Type.BYTE or Type.BOOLEAN but to an array of '" + ((ArrayType)arrayref).getElementType() + "'.");
        }
    }

    public void visitBASTORE(BASTORE o) {
        Type arrayref = this.stack().peek(2);
        Type index = this.stack().peek(1);
        Type value = this.stack().peek(0);
        this.indexOfInt(o, index);
        this.valueOfInt(o, value);
        if (this.arrayrefOfArrayType(o, arrayref) && !((ArrayType)arrayref).getElementType().equals(TypeConstants.BOOLEAN) && !((ArrayType)arrayref).getElementType().equals(TypeConstants.BYTE)) {
            this.constraintViolated(o, "The 'arrayref' does not refer to an array with elements of a Type.BYTE or Type.BOOLEAN but to an array of '" + ((ArrayType)arrayref).getElementType() + "'.");
        }
    }

    public void visitBIPUSH(BIPUSH o) {
    }

    public void visitBREAKPOINT(BREAKPOINT o) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as BREAKPOINT.");
    }

    public void visitCALOAD(CALOAD o) {
        Type arrayref = this.stack().peek(1);
        Type index = this.stack().peek(0);
        this.indexOfInt(o, index);
        this.arrayrefOfArrayType(o, arrayref);
    }

    public void visitCASTORE(CASTORE o) {
        Type arrayref = this.stack().peek(2);
        Type index = this.stack().peek(1);
        Type value = this.stack().peek(0);
        this.indexOfInt(o, index);
        this.valueOfInt(o, value);
        if (this.arrayrefOfArrayType(o, arrayref) && !((ArrayType)arrayref).getElementType().equals(TypeConstants.CHAR)) {
            this.constraintViolated(o, "The 'arrayref' does not refer to an array with elements of type char but to an array of type " + ((ArrayType)arrayref).getElementType() + ".");
        }
    }

    public void visitCHECKCAST(CHECKCAST o) {
        Type objectref = this.stack().peek(0);
        if (!(objectref instanceof ReferenceType)) {
            this.constraintViolated(o, "The 'objectref' is not of a ReferenceType but of type " + objectref + ".");
        } else {
            this.referenceTypeIsInitialized(o, (ReferenceType)objectref);
        }
        Constant c = this.cpg.getConstant(o.getIndex());
        if (!(c instanceof ConstantClass)) {
            this.constraintViolated(o, "The Constant at 'index' is not a ConstantClass, but '" + c + "'.");
        }
    }

    public void visitD2F(D2F o) {
        if (this.stack().peek() != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitD2I(D2I o) {
        if (this.stack().peek() != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitD2L(D2L o) {
        if (this.stack().peek() != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitDADD(DADD o) {
        if (this.stack().peek() != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDALOAD(DALOAD o) {
        Type t;
        this.indexOfInt(o, this.stack().peek());
        if (this.stack().peek(1) == TypeConstants.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-top must be of type double[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(1)).getBasicType()) != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "Stack next-to-top must be of type double[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDASTORE(DASTORE o) {
        Type t;
        if (this.stack().peek() != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o, this.stack().peek(1));
        if (this.stack().peek(2) == TypeConstants.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type double[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(2)).getBasicType()) != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type double[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    public void visitDCMPG(DCMPG o) {
        if (this.stack().peek() != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDCMPL(DCMPL o) {
        if (this.stack().peek() != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDCONST(DCONST o) {
    }

    public void visitDDIV(DDIV o) {
        if (this.stack().peek() != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDLOAD(DLOAD o) {
    }

    public void visitDMUL(DMUL o) {
        if (this.stack().peek() != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDNEG(DNEG o) {
        if (this.stack().peek() != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitDREM(DREM o) {
        if (this.stack().peek() != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDRETURN(DRETURN o) {
        if (this.stack().peek() != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitDSTORE(DSTORE o) {
    }

    public void visitDSUB(DSUB o) {
        if (this.stack().peek() != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDUP(DUP o) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o, "Won't DUP type on stack top '" + this.stack().peek() + "' because it must occupy exactly one slot, not '" + this.stack().peek().getSize() + "'.");
        }
    }

    public void visitDUP_X1(DUP_X1 o) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o, "Type on stack top '" + this.stack().peek() + "' should occupy exactly one slot, not '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(o, "Type on stack next-to-top '" + this.stack().peek(1) + "' should occupy exactly one slot, not '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    public void visitDUP_X2(DUP_X2 o) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o, "Stack top type must be of size 1, but is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() == 2) {
            return;
        }
        if (this.stack().peek(2).getSize() != 1) {
            this.constraintViolated(o, "If stack top's size is 1 and stack next-to-top's size is 1, stack next-to-next-to-top's size must also be 1, but is: '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        }
    }

    public void visitDUP2(DUP2 o) {
        if (this.stack().peek().getSize() == 2) {
            return;
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(o, "If stack top's size is 1, then stack next-to-top's size must also be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitDUP2_X1(DUP2_X1 o) {
        if (this.stack().peek().getSize() == 2) {
            if (this.stack().peek(1).getSize() == 1) return;
            this.constraintViolated(o, "If stack top's size is 2, then stack next-to-top's size must be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
            return;
        } else {
            if (this.stack().peek(1).getSize() != 1) {
                this.constraintViolated(o, "If stack top's size is 1, then stack next-to-top's size must also be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
            }
            if (this.stack().peek(2).getSize() == 1) return;
            this.constraintViolated(o, "If stack top's size is 1, then stack next-to-next-to-top's size must also be 1. But it is '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitDUP2_X2(DUP2_X2 o) {
        if (this.stack().peek(0).getSize() == 2) {
            if (this.stack().peek(1).getSize() == 2) {
                return;
            }
            if (this.stack().peek(2).getSize() == 1) return;
            this.constraintViolated(o, "If stack top's size is 2 and stack-next-to-top's size is 1, then stack next-to-next-to-top's size must also be 1. But it is '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        } else if (this.stack().peek(1).getSize() == 1) {
            if (this.stack().peek(2).getSize() == 2) {
                return;
            }
            if (this.stack().peek(3).getSize() == 1) {
                return;
            }
        }
        this.constraintViolated(o, "The operand sizes on the stack do not match any of the four forms of usage of this instruction.");
    }

    public void visitF2D(F2D o) {
        if (this.stack().peek() != TypeConstants.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitF2I(F2I o) {
        if (this.stack().peek() != TypeConstants.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitF2L(F2L o) {
        if (this.stack().peek() != TypeConstants.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitFADD(FADD o) {
        if (this.stack().peek() != TypeConstants.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFALOAD(FALOAD o) {
        Type t;
        this.indexOfInt(o, this.stack().peek());
        if (this.stack().peek(1) == TypeConstants.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-top must be of type float[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(1)).getBasicType()) != TypeConstants.FLOAT) {
            this.constraintViolated(o, "Stack next-to-top must be of type float[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFASTORE(FASTORE o) {
        Type t;
        if (this.stack().peek() != TypeConstants.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o, this.stack().peek(1));
        if (this.stack().peek(2) == TypeConstants.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type float[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(2)).getBasicType()) != TypeConstants.FLOAT) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type float[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    public void visitFCMPG(FCMPG o) {
        if (this.stack().peek() != TypeConstants.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFCMPL(FCMPL o) {
        if (this.stack().peek() != TypeConstants.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFCONST(FCONST o) {
    }

    public void visitFDIV(FDIV o) {
        if (this.stack().peek() != TypeConstants.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFLOAD(FLOAD o) {
    }

    public void visitFMUL(FMUL o) {
        if (this.stack().peek() != TypeConstants.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFNEG(FNEG o) {
        if (this.stack().peek() != TypeConstants.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitFREM(FREM o) {
        if (this.stack().peek() != TypeConstants.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFRETURN(FRETURN o) {
        if (this.stack().peek() != TypeConstants.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitFSTORE(FSTORE o) {
    }

    public void visitFSUB(FSUB o) {
        if (this.stack().peek() != TypeConstants.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitGETFIELD(GETFIELD o) {
        ObjectType curr;
        ObjectType classtype;
        Type objectref = this.stack().peek();
        if (!(objectref instanceof ObjectType) && objectref != TypeConstants.NULL) {
            this.constraintViolated(o, "Stack top should be an object reference that's not an array reference, but is '" + objectref + "'.");
        }
        String field_name = o.getFieldName(this.cpg);
        JavaClass jc = Repository.lookupClass(o.getClassType(this.cpg).getClassName());
        Field[] fields = jc.getFields();
        AccessFlags f = null;
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals(field_name)) continue;
            f = fields[i];
            break;
        }
        if (f == null) {
            throw new AssertionViolatedException("Field not found?!?");
        }
        if (f.isProtected() && ((classtype = o.getClassType(this.cpg)).equals(curr = new ObjectType(this.mg.getClassName())) || curr.subclassOf(classtype))) {
            ObjectType objreftype;
            Type t = this.stack().peek();
            if (t == TypeConstants.NULL) {
                return;
            }
            if (!(t instanceof ObjectType)) {
                this.constraintViolated(o, "The 'objectref' must refer to an object that's not an array. Found instead: '" + t + "'.");
            }
            if ((objreftype = (ObjectType)t).equals(curr) || !objreftype.subclassOf(curr)) {
                // empty if block
            }
        }
        if (f.isStatic()) {
            this.constraintViolated(o, "Referenced field '" + f + "' is static which it shouldn't be.");
        }
    }

    public void visitGETSTATIC(GETSTATIC o) {
    }

    public void visitGOTO(GOTO o) {
    }

    public void visitGOTO_W(GOTO_W o) {
    }

    public void visitI2B(I2B o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitI2C(I2C o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitI2D(I2D o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitI2F(I2F o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitI2L(I2L o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitI2S(I2S o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIADD(IADD o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIALOAD(IALOAD o) {
        Type t;
        this.indexOfInt(o, this.stack().peek());
        if (this.stack().peek(1) == TypeConstants.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-top must be of type int[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(1)).getBasicType()) != TypeConstants.INT) {
            this.constraintViolated(o, "Stack next-to-top must be of type int[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIAND(IAND o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIASTORE(IASTORE o) {
        Type t;
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o, this.stack().peek(1));
        if (this.stack().peek(2) == TypeConstants.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type int[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(2)).getBasicType()) != TypeConstants.INT) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type int[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    public void visitICONST(ICONST o) {
    }

    public void visitIDIV(IDIV o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ACMPEQ(IF_ACMPEQ o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
        if (!(this.stack().peek(1) instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of a ReferenceType, but of type '" + this.stack().peek(1) + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek(1));
    }

    public void visitIF_ACMPNE(IF_ACMPNE o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
            this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
        }
        if (!(this.stack().peek(1) instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of a ReferenceType, but of type '" + this.stack().peek(1) + "'.");
            this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek(1));
        }
    }

    public void visitIF_ICMPEQ(IF_ICMPEQ o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPGE(IF_ICMPGE o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPGT(IF_ICMPGT o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPLE(IF_ICMPLE o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPLT(IF_ICMPLT o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPNE(IF_ICMPNE o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIFEQ(IFEQ o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFGE(IFGE o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFGT(IFGT o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFLE(IFLE o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFLT(IFLT o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFNE(IFNE o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFNONNULL(IFNONNULL o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
    }

    public void visitIFNULL(IFNULL o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
    }

    public void visitIINC(IINC o) {
        if (this.locals().maxLocals() <= (o.getType(this.cpg).getSize() == 1 ? o.getIndex() : o.getIndex() + 1)) {
            this.constraintViolated(o, "The 'index' is not a valid index into the local variable array.");
        }
        this.indexOfInt(o, this.locals().get(o.getIndex()));
    }

    public void visitILOAD(ILOAD o) {
    }

    public void visitIMPDEP1(IMPDEP1 o) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as IMPDEP1.");
    }

    public void visitIMPDEP2(IMPDEP2 o) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as IMPDEP2.");
    }

    public void visitIMUL(IMUL o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitINEG(INEG o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitINSTANCEOF(INSTANCEOF o) {
        Type objectref = this.stack().peek(0);
        if (!(objectref instanceof ReferenceType)) {
            this.constraintViolated(o, "The 'objectref' is not of a ReferenceType but of type " + objectref + ".");
        } else {
            this.referenceTypeIsInitialized(o, (ReferenceType)objectref);
        }
        Constant c = this.cpg.getConstant(o.getIndex());
        if (!(c instanceof ConstantClass)) {
            this.constraintViolated(o, "The Constant at 'index' is not a ConstantClass, but '" + c + "'.");
        }
    }

    public void visitINVOKEINTERFACE(INVOKEINTERFACE o) {
        String name;
        Verifier v;
        VerificationResult vr;
        Type t;
        int count = o.getCount();
        if (count == 0) {
            this.constraintViolated(o, "The 'count' argument must not be 0.");
        }
        if ((t = o.getType(this.cpg)) instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(name = ((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated(o, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
        Type[] argtypes = o.getArgumentTypes(this.cpg);
        int nargs = argtypes.length;
        for (int i = nargs - 1; i >= 0; --i) {
            Type fromStack = this.stack().peek(nargs - 1 - i);
            Type fromDesc = argtypes[i];
            if (fromDesc == TypeConstants.BOOLEAN || fromDesc == TypeConstants.BYTE || fromDesc == TypeConstants.CHAR || fromDesc == TypeConstants.SHORT) {
                fromDesc = TypeConstants.INT;
            }
            if (fromStack.equals(fromDesc) || fromStack instanceof ReferenceType && fromDesc instanceof ReferenceType) continue;
            this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack.");
        }
        Type objref = this.stack().peek(nargs);
        if (objref == TypeConstants.NULL) {
            return;
        }
        if (!(objref instanceof ReferenceType)) {
            this.constraintViolated(o, "Expecting a reference type as 'objectref' on the stack, not a '" + objref + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)objref);
        if (!(objref instanceof ObjectType)) {
            if (!(objref instanceof ArrayType)) {
                this.constraintViolated(o, "Expecting an ObjectType as 'objectref' on the stack, not a '" + objref + "'.");
            } else {
                objref = GENERIC_ARRAY;
            }
        }
        int counted_count = 1;
        for (int i = 0; i < nargs; ++i) {
            counted_count += argtypes[i].getSize();
        }
        if (count != counted_count) {
            this.constraintViolated(o, "The 'count' argument should probably read '" + counted_count + "' but is '" + count + "'.");
        }
    }

    public void visitINVOKESPECIAL(INVOKESPECIAL o) {
        String name;
        Verifier v;
        VerificationResult vr;
        Type t;
        if (o.getMethodName(this.cpg).equals("<init>") && !(this.stack().peek(o.getArgumentTypes(this.cpg).length) instanceof UninitializedObjectType)) {
            this.constraintViolated(o, "Possibly initializing object twice. A valid instruction sequence must not have an uninitialized object on the operand stack or in a local variable during a backwards branch, or in a local variable in code protected by an exception handler. Please see The Java Virtual Machine Specification, Second Edition, 4.9.4 (pages 147 and 148) for details.");
        }
        if ((t = o.getType(this.cpg)) instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(name = ((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated(o, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
        Type[] argtypes = o.getArgumentTypes(this.cpg);
        int nargs = argtypes.length;
        for (int i = nargs - 1; i >= 0; --i) {
            Type fromStack = this.stack().peek(nargs - 1 - i);
            Type fromDesc = argtypes[i];
            if (fromDesc == TypeConstants.BOOLEAN || fromDesc == TypeConstants.BYTE || fromDesc == TypeConstants.CHAR || fromDesc == TypeConstants.SHORT) {
                fromDesc = TypeConstants.INT;
            }
            if (fromStack.equals(fromDesc)) continue;
            if (fromStack instanceof ReferenceType && fromDesc instanceof ReferenceType) {
                ReferenceType rFromStack = (ReferenceType)fromStack;
                ReferenceType rFromDesc = (ReferenceType)fromDesc;
                if (rFromStack.isAssignmentCompatibleWith(rFromDesc)) continue;
                this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack (which is not assignment compatible).");
                continue;
            }
            this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack.");
        }
        Type objref = this.stack().peek(nargs);
        if (objref == TypeConstants.NULL) {
            return;
        }
        if (!(objref instanceof ReferenceType)) {
            this.constraintViolated(o, "Expecting a reference type as 'objectref' on the stack, not a '" + objref + "'.");
        }
        String objref_classname = null;
        if (!o.getMethodName(this.cpg).equals("<init>")) {
            this.referenceTypeIsInitialized(o, (ReferenceType)objref);
            if (!(objref instanceof ObjectType)) {
                if (!(objref instanceof ArrayType)) {
                    this.constraintViolated(o, "Expecting an ObjectType as 'objectref' on the stack, not a '" + objref + "'.");
                } else {
                    objref = GENERIC_ARRAY;
                }
            }
            objref_classname = ((ObjectType)objref).getClassName();
        } else {
            if (!(objref instanceof UninitializedObjectType)) {
                this.constraintViolated(o, "Expecting an UninitializedObjectType as 'objectref' on the stack, not a '" + objref + "'. Otherwise, you couldn't invoke a method since an array has no methods (not to speak of a return address).");
            }
            objref_classname = ((UninitializedObjectType)objref).getInitialized().getClassName();
        }
        String theClass = o.getClassName(this.cpg);
        if (!Repository.instanceOf(objref_classname, theClass)) {
            this.constraintViolated(o, "The 'objref' item '" + objref + "' does not implement '" + theClass + "' as expected.");
        }
    }

    public void visitINVOKESTATIC(INVOKESTATIC o) {
        String name;
        Verifier v;
        VerificationResult vr;
        Type t = o.getType(this.cpg);
        if (t instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(name = ((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated(o, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
        Type[] argtypes = o.getArgumentTypes(this.cpg);
        int nargs = argtypes.length;
        for (int i = nargs - 1; i >= 0; --i) {
            Type fromStack = this.stack().peek(nargs - 1 - i);
            Type fromDesc = argtypes[i];
            if (fromDesc == TypeConstants.BOOLEAN || fromDesc == TypeConstants.BYTE || fromDesc == TypeConstants.CHAR || fromDesc == TypeConstants.SHORT) {
                fromDesc = TypeConstants.INT;
            }
            if (fromStack.equals(fromDesc)) continue;
            if (fromStack instanceof ReferenceType && fromDesc instanceof ReferenceType) {
                ReferenceType rFromStack = (ReferenceType)fromStack;
                ReferenceType rFromDesc = (ReferenceType)fromDesc;
                if (rFromStack.isAssignmentCompatibleWith(rFromDesc)) continue;
                this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack (which is not assignment compatible).");
                continue;
            }
            this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack.");
        }
    }

    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL o) {
        String theClass;
        String objref_classname;
        String name;
        Verifier v;
        VerificationResult vr;
        Type t = o.getType(this.cpg);
        if (t instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(name = ((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated(o, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
        Type[] argtypes = o.getArgumentTypes(this.cpg);
        int nargs = argtypes.length;
        for (int i = nargs - 1; i >= 0; --i) {
            Type fromStack = this.stack().peek(nargs - 1 - i);
            Type fromDesc = argtypes[i];
            if (fromDesc == TypeConstants.BOOLEAN || fromDesc == TypeConstants.BYTE || fromDesc == TypeConstants.CHAR || fromDesc == TypeConstants.SHORT) {
                fromDesc = TypeConstants.INT;
            }
            if (fromStack.equals(fromDesc)) continue;
            if (fromStack instanceof ReferenceType && fromDesc instanceof ReferenceType) {
                ReferenceType rFromStack = (ReferenceType)fromStack;
                ReferenceType rFromDesc = (ReferenceType)fromDesc;
                if (rFromStack.isAssignmentCompatibleWith(rFromDesc)) continue;
                this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack (which is not assignment compatible).");
                continue;
            }
            this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack.");
        }
        Type objref = this.stack().peek(nargs);
        if (objref == TypeConstants.NULL) {
            return;
        }
        if (!(objref instanceof ReferenceType)) {
            this.constraintViolated(o, "Expecting a reference type as 'objectref' on the stack, not a '" + objref + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)objref);
        if (!(objref instanceof ObjectType)) {
            if (!(objref instanceof ArrayType)) {
                this.constraintViolated(o, "Expecting an ObjectType as 'objectref' on the stack, not a '" + objref + "'.");
            } else {
                objref = GENERIC_ARRAY;
            }
        }
        if (!Repository.instanceOf(objref_classname = ((ObjectType)objref).getClassName(), theClass = o.getClassName(this.cpg))) {
            this.constraintViolated(o, "The 'objref' item '" + objref + "' does not implement '" + theClass + "' as expected.");
        }
    }

    public void visitIOR(IOR o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIREM(IREM o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIRETURN(IRETURN o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitISHL(ISHL o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitISHR(ISHR o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitISTORE(ISTORE o) {
    }

    public void visitISUB(ISUB o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIUSHR(IUSHR o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIXOR(IXOR o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitJSR(JSR o) {
    }

    public void visitJSR_W(JSR_W o) {
    }

    public void visitL2D(L2D o) {
        if (this.stack().peek() != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitL2F(L2F o) {
        if (this.stack().peek() != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitL2I(L2I o) {
        if (this.stack().peek() != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitLADD(LADD o) {
        if (this.stack().peek() != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLALOAD(LALOAD o) {
        Type t;
        this.indexOfInt(o, this.stack().peek());
        if (this.stack().peek(1) == TypeConstants.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-top must be of type long[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(1)).getBasicType()) != TypeConstants.LONG) {
            this.constraintViolated(o, "Stack next-to-top must be of type long[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLAND(LAND o) {
        if (this.stack().peek() != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLASTORE(LASTORE o) {
        Type t;
        if (this.stack().peek() != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o, this.stack().peek(1));
        if (this.stack().peek(2) == TypeConstants.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type long[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(2)).getBasicType()) != TypeConstants.LONG) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type long[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    public void visitLCMP(LCMP o) {
        if (this.stack().peek() != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLCONST(LCONST o) {
    }

    public void visitLDC(LDC o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (!(c instanceof ConstantInteger || c instanceof ConstantFloat || c instanceof ConstantString)) {
            this.constraintViolated(o, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float or a CONSTANT_String, but is '" + c + "'.");
        }
    }

    public void visitLDC_W(LDC_W o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (!(c instanceof ConstantInteger || c instanceof ConstantFloat || c instanceof ConstantString)) {
            this.constraintViolated(o, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float or a CONSTANT_String, but is '" + c + "'.");
        }
    }

    public void visitLDC2_W(LDC2_W o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (!(c instanceof ConstantLong) && !(c instanceof ConstantDouble)) {
            this.constraintViolated(o, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float or a CONSTANT_String, but is '" + c + "'.");
        }
    }

    public void visitLDIV(LDIV o) {
        if (this.stack().peek() != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLLOAD(LLOAD o) {
    }

    public void visitLMUL(LMUL o) {
        if (this.stack().peek() != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLNEG(LNEG o) {
        if (this.stack().peek() != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitLOOKUPSWITCH(LOOKUPSWITCH o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitLOR(LOR o) {
        if (this.stack().peek() != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLREM(LREM o) {
        if (this.stack().peek() != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLRETURN(LRETURN o) {
        if (this.stack().peek() != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitLSHL(LSHL o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLSHR(LSHR o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLSTORE(LSTORE o) {
    }

    public void visitLSUB(LSUB o) {
        if (this.stack().peek() != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLUSHR(LUSHR o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLXOR(LXOR o) {
        if (this.stack().peek() != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != TypeConstants.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitMONITORENTER(MONITORENTER o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The stack top should be of a ReferenceType, but is '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
    }

    public void visitMONITOREXIT(MONITOREXIT o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The stack top should be of a ReferenceType, but is '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
    }

    public void visitMULTIANEWARRAY(MULTIANEWARRAY o) {
        int dimensions = o.getDimensions();
        for (int i = 0; i < dimensions; ++i) {
            if (this.stack().peek(i) == TypeConstants.INT) continue;
            this.constraintViolated(o, "The '" + dimensions + "' upper stack types should be 'int' but aren't.");
        }
    }

    public void visitNEW(NEW o) {
        ObjectType obj;
        Type t = o.getType(this.cpg);
        if (!(t instanceof ReferenceType)) {
            throw new AssertionViolatedException("NEW.getType() returning a non-reference type?!");
        }
        if (!(t instanceof ObjectType)) {
            this.constraintViolated(o, "Expecting a class type (ObjectType) to work on. Found: '" + t + "'.");
        }
        if (!(obj = (ObjectType)t).referencesClass()) {
            this.constraintViolated(o, "Expecting a class type (ObjectType) to work on. Found: '" + obj + "'.");
        }
    }

    public void visitNEWARRAY(NEWARRAY o) {
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitNOP(NOP o) {
    }

    public void visitPOP(POP o) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o, "Stack top size should be 1 but stack top is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
    }

    public void visitPOP2(POP2 o) {
        if (this.stack().peek().getSize() != 2) {
            this.constraintViolated(o, "Stack top size should be 2 but stack top is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
    }

    public void visitPUTFIELD(PUTFIELD o) {
        ObjectType curr;
        ObjectType classtype;
        Type objectref = this.stack().peek(1);
        if (!(objectref instanceof ObjectType) && objectref != TypeConstants.NULL) {
            this.constraintViolated(o, "Stack next-to-top should be an object reference that's not an array reference, but is '" + objectref + "'.");
        }
        String field_name = o.getFieldName(this.cpg);
        JavaClass jc = Repository.lookupClass(o.getClassType(this.cpg).getClassName());
        Field[] fields = jc.getFields();
        FieldOrMethod f = null;
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals(field_name)) continue;
            f = fields[i];
            break;
        }
        if (f == null) {
            throw new AssertionViolatedException("Field not found?!?");
        }
        Type value = this.stack().peek();
        Type t = Type.getType(f.getSignature());
        Type shouldbe = t;
        if (shouldbe == TypeConstants.BOOLEAN || shouldbe == TypeConstants.BYTE || shouldbe == TypeConstants.CHAR || shouldbe == TypeConstants.SHORT) {
            shouldbe = TypeConstants.INT;
        }
        if (t instanceof ReferenceType) {
            ReferenceType rvalue = null;
            if (value instanceof ReferenceType) {
                rvalue = (ReferenceType)value;
                this.referenceTypeIsInitialized(o, rvalue);
            } else {
                this.constraintViolated(o, "The stack top type '" + value + "' is not of a reference type as expected.");
            }
            if (!rvalue.isAssignmentCompatibleWith(shouldbe)) {
                this.constraintViolated(o, "The stack top type '" + value + "' is not assignment compatible with '" + shouldbe + "'.");
            }
        } else if (shouldbe != value) {
            this.constraintViolated(o, "The stack top type '" + value + "' is not of type '" + shouldbe + "' as expected.");
        }
        if (f.isProtected() && ((classtype = o.getClassType(this.cpg)).equals(curr = new ObjectType(this.mg.getClassName())) || curr.subclassOf(classtype))) {
            ObjectType objreftype;
            Type tp = this.stack().peek(1);
            if (tp == TypeConstants.NULL) {
                return;
            }
            if (!(tp instanceof ObjectType)) {
                this.constraintViolated(o, "The 'objectref' must refer to an object that's not an array. Found instead: '" + tp + "'.");
            }
            if (!(objreftype = (ObjectType)tp).equals(curr) && !objreftype.subclassOf(curr)) {
                this.constraintViolated(o, "The referenced field has the ACC_PROTECTED modifier, and it's a member of the current class or a superclass of the current class. However, the referenced object type '" + this.stack().peek() + "' is not the current class or a subclass of the current class.");
            }
        }
        if (f.isStatic()) {
            this.constraintViolated(o, "Referenced field '" + f + "' is static which it shouldn't be.");
        }
    }

    public void visitPUTSTATIC(PUTSTATIC o) {
        String field_name = o.getFieldName(this.cpg);
        JavaClass jc = Repository.lookupClass(o.getClassType(this.cpg).getClassName());
        Field[] fields = jc.getFields();
        FieldOrMethod f = null;
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals(field_name)) continue;
            f = fields[i];
            break;
        }
        if (f == null) {
            throw new AssertionViolatedException("Field not found?!?");
        }
        Type value = this.stack().peek();
        Type t = Type.getType(f.getSignature());
        Type shouldbe = t;
        if (shouldbe == TypeConstants.BOOLEAN || shouldbe == TypeConstants.BYTE || shouldbe == TypeConstants.CHAR || shouldbe == TypeConstants.SHORT) {
            shouldbe = TypeConstants.INT;
        }
        if (t instanceof ReferenceType) {
            ReferenceType rvalue = null;
            if (value instanceof ReferenceType) {
                rvalue = (ReferenceType)value;
                this.referenceTypeIsInitialized(o, rvalue);
            } else {
                this.constraintViolated(o, "The stack top type '" + value + "' is not of a reference type as expected.");
            }
            if (!rvalue.isAssignmentCompatibleWith(shouldbe)) {
                this.constraintViolated(o, "The stack top type '" + value + "' is not assignment compatible with '" + shouldbe + "'.");
            }
        } else if (shouldbe != value) {
            this.constraintViolated(o, "The stack top type '" + value + "' is not of type '" + shouldbe + "' as expected.");
        }
    }

    public void visitRET(RET o) {
        if (!(this.locals().get(o.getIndex()) instanceof ReturnaddressType)) {
            this.constraintViolated(o, "Expecting a ReturnaddressType in local variable " + o.getIndex() + ".");
        }
        if (this.locals().get(o.getIndex()) == ReturnaddressType.NO_TARGET) {
            throw new AssertionViolatedException("Oops: RET expecting a target!");
        }
    }

    public void visitRETURN(RETURN o) {
        if (this.mg.getName().equals("<init>")) {
            if (Frame._this != null && !this.mg.getClassName().equals(TypeConstants.OBJECT.getClassName())) {
                this.constraintViolated(o, "Leaving a constructor that itself did not call a constructor.");
            }
        }
    }

    public void visitSALOAD(SALOAD o) {
        Type t;
        this.indexOfInt(o, this.stack().peek());
        if (this.stack().peek(1) == TypeConstants.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-top must be of type short[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(1)).getBasicType()) != TypeConstants.SHORT) {
            this.constraintViolated(o, "Stack next-to-top must be of type short[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitSASTORE(SASTORE o) {
        Type t;
        if (this.stack().peek() != TypeConstants.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o, this.stack().peek(1));
        if (this.stack().peek(2) == TypeConstants.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type short[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(2)).getBasicType()) != TypeConstants.SHORT) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type short[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    public void visitSIPUSH(SIPUSH o) {
    }

    public void visitSWAP(SWAP o) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o, "The value at the stack top is not of size '1', but of size '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of size '1', but of size '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    public void visitTABLESWITCH(TABLESWITCH o) {
        this.indexOfInt(o, this.stack().peek());
    }
}

