/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.ast;

import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.SimpleNode;
import com.ibm.xtq.ast.parsers.xpath.Test;
import com.ibm.xtq.ast.parsers.xpath.XPath;
import com.ibm.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xtq.utils.XPathError;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import org.xml.sax.InputSource;

public class Parser {
    Object _parser;
    InputSource _input;
    public static final String XPATH1_STRING = "XPath1";
    public static final String XPATH2_STRING = "XPath2";
    public static final String XQUERY1_STRING = "XQuery1";
    public static final String XSLT1_STRING = "XSLT1";
    public static final String XSLT2_STRING = "XSLT2";
    public static final short XPATH1 = 1;
    public static final short XPATH2 = 2;
    public static final short XQUERY1 = 3;
    public static final short XSLT1 = 4;
    public static final short XSLT2 = 5;
    private int _lang;

    public Parser(ASTBuildingContext aSTBuildingContext, String string, InputStream inputStream, String string2) {
        this._lang = Parser.langStringToEnum(string);
        switch (this._lang) {
            case 1: 
            case 2: 
            case 3: {
                XPath xPath = new XPath(aSTBuildingContext, inputStream);
                this._parser = xPath;
                SimpleNode.setLanguage(xPath.getExpressionFactory(), string);
                break;
            }
            case 4: 
            case 5: {
                this._lang = 5;
                this._input = new InputSource(inputStream);
                this._input.setSystemId(string2);
                XSLTParser xSLTParser = this.makeXSLTParser();
                this._parser = xSLTParser;
                xSLTParser.getExpressionFactory().setLanguage(string);
            }
        }
    }

    public Parser(ASTBuildingContext aSTBuildingContext, String string, Reader reader, String string2) {
        this._lang = Parser.langStringToEnum(string);
        switch (this._lang) {
            case 1: 
            case 2: {
                XPath xPath = new XPath(aSTBuildingContext, reader);
                this._parser = xPath;
                SimpleNode.setLanguage(xPath.getExpressionFactory(), string);
                break;
            }
            case 4: 
            case 5: {
                this._lang = 5;
                this._input = new InputSource(reader);
                this._input.setSystemId(string2);
                XSLTParser xSLTParser = this.makeXSLTParser();
                this._parser = xSLTParser;
                xSLTParser.getExpressionFactory().setLanguage(string);
            }
        }
    }

    public Parser(ASTBuildingContext aSTBuildingContext, String string, String string2) throws FileNotFoundException {
        this._lang = Parser.langStringToEnum(string);
        File file = new File(string2);
        FileInputStream fileInputStream = new FileInputStream(file);
        switch (this._lang) {
            case 1: 
            case 2: 
            case 3: {
                XPath xPath = new XPath(aSTBuildingContext, fileInputStream);
                this._parser = xPath;
                SimpleNode.setLanguage(xPath.getExpressionFactory(), string);
                break;
            }
            case 4: 
            case 5: {
                this._lang = 5;
                this._input = new InputSource(fileInputStream);
                this._input.setSystemId(string2);
                XSLTParser xSLTParser = this.makeXSLTParser();
                this._parser = xSLTParser;
                xSLTParser.getExpressionFactory().setLanguage(string);
            }
        }
    }

    private XSLTParser makeXSLTParser() {
        XSLTParser xSLTParser = new XSLTParser(this._lang == 5);
        xSLTParser.init();
        return xSLTParser;
    }

    private static int langStringToEnum(String string) {
        if (string.equals(XPATH1_STRING)) {
            return 1;
        }
        if (string.equals(XPATH2_STRING)) {
            return 2;
        }
        if (string.equals(XQUERY1_STRING)) {
            return 3;
        }
        if (string.equals(XSLT1_STRING)) {
            return 4;
        }
        if (string.equals(XSLT2_STRING)) {
            return 5;
        }
        throw new XPathError("ERR_LANGUAGE", string);
    }

    public static void main(String[] stringArray) throws Exception {
        String string = XPATH2_STRING;
        int n = 0;
        String string2 = null;
        boolean bl = false;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-lang")) {
                string = stringArray[++n];
                ++n;
                continue;
            }
            if (stringArray[n].equals("-file")) {
                string2 = stringArray[++n];
                ++n;
                continue;
            }
            if (stringArray[n].equals("-dumptree")) {
                bl = true;
                ++n;
                continue;
            }
            if (stringArray[n].equals("-match")) {
                ++n;
                continue;
            }
            if (stringArray[n].equals("-expr")) {
                ++n;
                ++n;
                continue;
            }
            if (stringArray[n].equals("-deepdir")) {
                ++n;
                ++n;
                continue;
            }
            if (n == stringArray.length - 1) {
                string2 = stringArray[n];
                ++n;
                continue;
            }
            ++n;
        }
        int n2 = Parser.langStringToEnum(string);
        switch (n2) {
            case 1: 
            case 2: 
            case 3: {
                Test.main(stringArray);
                break;
            }
            case 4: 
            case 5: {
                Parser parser = new Parser(null, string, string2);
                Expr expr = parser.parse();
                if (!bl) break;
                expr.dump("", System.out);
                break;
            }
        }
    }

    public Expr parse() throws Exception {
        switch (this._lang) {
            case 1: 
            case 2: 
            case 3: {
                XPath xPath = (XPath)this._parser;
                SimpleNode simpleNode = xPath.XPath2();
                return (Expr)simpleNode.jjtGetChild(0);
            }
            case 4: 
            case 5: {
                XSLTParser xSLTParser = (XSLTParser)this._parser;
                return xSLTParser.makeAST(this._input);
            }
        }
        return null;
    }

    public SimpleNode parseRaw() throws Exception {
        switch (this._lang) {
            case 1: 
            case 2: 
            case 3: {
                XPath xPath = (XPath)this._parser;
                return xPath.XPath2();
            }
            case 4: 
            case 5: {
                XSLTParser xSLTParser = (XSLTParser)this._parser;
                return xSLTParser.makeAST(this._input);
            }
        }
        return null;
    }

    public void ReInit(ASTBuildingContext aSTBuildingContext, InputStream inputStream, String string) {
        switch (this._lang) {
            case 1: 
            case 2: 
            case 3: {
                XPath xPath = (XPath)this._parser;
                xPath.ReInit(aSTBuildingContext, inputStream);
                break;
            }
            case 4: 
            case 5: {
                this._input.setSystemId(string);
                break;
            }
        }
    }

    public void ReInit(ASTBuildingContext aSTBuildingContext, Reader reader, String string) {
        switch (this._lang) {
            case 1: 
            case 2: 
            case 3: {
                XPath xPath = (XPath)this._parser;
                xPath.ReInit(aSTBuildingContext, reader);
                break;
            }
            case 4: 
            case 5: {
                this._input.setSystemId(string);
                break;
            }
        }
    }
}

