/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.stax;

import com.ibm.xml.xlxp.api.stax.msg.StAXMessageProvider;
import java.util.ArrayList;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.XMLEvent;

class XMLFilteredEventReaderImpl
implements XMLEventReader,
XMLStreamConstants {
    private XMLEventReader fSourceEventReader;
    private EventFilter fEventFilter;
    private XMLEvent fXMLEvent;
    private ArrayList fEventCache;

    XMLFilteredEventReaderImpl(XMLEventReader xMLEventReader, EventFilter eventFilter) throws XMLStreamException {
        this.fSourceEventReader = xMLEventReader;
        this.fEventFilter = eventFilter;
        this.fEventCache = new ArrayList();
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        XMLEvent xMLEvent;
        do {
            if (this.fEventCache.size() > 0) {
                xMLEvent = (XMLEvent)this.fEventCache.get(0);
                this.fEventCache.remove(0);
                continue;
            }
            xMLEvent = this.fSourceEventReader.nextEvent();
        } while (this.fEventFilter != null && !this.fEventFilter.accept(xMLEvent));
        this.fXMLEvent = xMLEvent;
        return this.fXMLEvent;
    }

    @Override
    public boolean hasNext() {
        if (this.fEventCache.size() > 0) {
            return true;
        }
        while (this.fSourceEventReader.hasNext()) {
            try {
                XMLEvent xMLEvent = this.fSourceEventReader.nextEvent();
                if (this.fEventFilter != null && !this.fEventFilter.accept(xMLEvent)) continue;
                this.fEventCache.add(xMLEvent);
                return true;
            }
            catch (XMLStreamException xMLStreamException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        XMLEvent xMLEvent;
        int n = 0;
        int n2 = this.fEventCache.size();
        do {
            if (n < n2) {
                xMLEvent = (XMLEvent)this.fEventCache.get(n++);
                continue;
            }
            if (!this.fSourceEventReader.hasNext()) {
                return null;
            }
            xMLEvent = this.fSourceEventReader.nextEvent();
            this.fEventCache.add(xMLEvent);
        } while (this.fEventFilter != null && !this.fEventFilter.accept(xMLEvent));
        return xMLEvent;
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (this.fXMLEvent == null || this.fXMLEvent.getEventType() != 1) {
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 14));
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            XMLEvent xMLEvent;
            if (this.fEventCache.size() > 0) {
                xMLEvent = (XMLEvent)this.fEventCache.get(0);
                this.fEventCache.remove(0);
            } else {
                xMLEvent = this.fSourceEventReader.nextEvent();
            }
            int n = xMLEvent.getEventType();
            if (n == 4 || n == 12 || n == 6) {
                stringBuffer.append(xMLEvent.asCharacters().getData());
                continue;
            }
            if (n == 9) {
                String string;
                EntityDeclaration entityDeclaration = ((EntityReference)xMLEvent).getDeclaration();
                if (entityDeclaration == null || (string = entityDeclaration.getReplacementText()) == null) continue;
                stringBuffer.append(string);
                continue;
            }
            if (n == 5 || n == 3) continue;
            this.fXMLEvent = xMLEvent;
            if (n == 2) {
                return stringBuffer.toString();
            }
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 15));
        }
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        XMLEvent xMLEvent;
        while (this.fEventCache.size() > 0) {
            xMLEvent = (XMLEvent)this.fEventCache.get(0);
            this.fEventCache.remove(0);
            int n = xMLEvent.getEventType();
            if (!(n != 1 && n != 2 || this.fEventFilter != null && !this.fEventFilter.accept(xMLEvent))) {
                this.fXMLEvent = xMLEvent;
                return this.fXMLEvent;
            }
            if (n == 5 || n == 3 || n == 6 || (n == 4 || n == 12) && xMLEvent.asCharacters().isWhiteSpace()) continue;
            StAXMessageProvider.throwXMLStreamException(StAXMessageProvider.createMessage(null, 16));
        }
        do {
            xMLEvent = this.fSourceEventReader.nextTag();
        } while (this.fEventFilter != null && !this.fEventFilter.accept(xMLEvent));
        this.fXMLEvent = xMLEvent;
        return this.fXMLEvent;
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        if (this.fXMLEvent != null && this.fXMLEvent.getEventType() == 11) {
            if ("javax.xml.stream.entities".equals(string)) {
                return ((DTD)this.fXMLEvent).getEntities();
            }
            if ("javax.xml.stream.notations".equals(string)) {
                return ((DTD)this.fXMLEvent).getNotations();
            }
        }
        return this.fSourceEventReader.getProperty(string);
    }

    @Override
    public void close() throws XMLStreamException {
        this.fSourceEventReader.close();
        this.fEventCache.clear();
        this.fXMLEvent = null;
    }

    @Override
    public void remove() {
        StAXMessageProvider.throwUnsupportedOperationException(StAXMessageProvider.createMessage(null, 34, "remove()"));
    }

    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException xMLStreamException) {
            StAXMessageProvider.throwNoSuchElementException(StAXMessageProvider.createMessage(null, 28));
            return null;
        }
    }
}

