/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.DOMCipherData;
import com.ibm.xml.enc.dom.DOMEncryptedData;
import com.ibm.xml.enc.dom.DOMEncryptedKey;
import com.ibm.xml.enc.dom.DOMEncryptionMethod;
import com.ibm.xml.enc.dom.DOMEncryptionProperties;
import com.ibm.xml.enc.dom.DOMKeyInfo;
import com.ibm.xml.enc.dom.DOMKeyInfoFactory;
import com.ibm.xml.enc.dom.DOMReferenceList;
import com.ibm.xml.enc.dom.DOMUtils;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.enc.EncryptedType;
import javax.xml.crypto.enc.XMLDecryptContext;
import javax.xml.crypto.enc.dom.DOMDecryptContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

class Unmarshalling {
    private DOMDecryptContext context;

    public Unmarshalling(DOMDecryptContext ct) {
        this.context = ct;
    }

    public static EncryptedType unmarshal(XMLDecryptContext context) throws MarshalException {
        if (!(context instanceof DOMDecryptContext)) {
            throw new MarshalException("context is not type of DOMDecryptContext");
        }
        DOMDecryptContext dcontext = (DOMDecryptContext)context;
        Element targetNode = dcontext.getEncryptedData();
        Unmarshalling ucontext = new Unmarshalling(dcontext);
        return ucontext.unmarshalEncryptedType(targetNode);
    }

    EncryptedType unmarshalEncryptedType(Element elem) throws MarshalException {
        String id = this.getIdAttribute(elem, "Id");
        String type = this.getIdAttribute(elem, "Type");
        String mimeType = this.getIdAttribute(elem, "MimeType");
        String encoding = this.getIdAttribute(elem, "Encoding");
        DOMEncryptionMethod em = null;
        KeyInfo ki = null;
        DOMCipherData cdata = null;
        DOMEncryptionProperties ep = null;
        boolean isEncryptedKey = false;
        DOMReferenceList rl = null;
        String carriedKeyName = null;
        String recipient = null;
        String name = elem.getLocalName();
        if (name == null) {
            throw new MarshalException("Document implementation must be namespace aware");
        }
        if (name.equals("EncryptedKey")) {
            isEncryptedKey = true;
            recipient = this.getIdAttribute(elem, "Recipient");
        } else if (!name.equals("EncryptedData")) {
            throw new MarshalException("unsupported EncryptedType");
        }
        Element child = DOMUtils.getFirstChildElement(elem);
        if (child != null) {
            String local = child.getLocalName();
            if (local != null && local.equals("EncryptionMethod")) {
                this.checkNamespace(child, "http://www.w3.org/2001/04/xmlenc#");
                em = (DOMEncryptionMethod)DOMEncryptionMethod.unmarshal(child);
                child = DOMUtils.getNextSiblingElement(child);
                if (child != null) {
                    local = child.getLocalName();
                }
            }
            if (local != null && local.equals("KeyInfo")) {
                this.checkNamespace(child, "http://www.w3.org/2000/09/xmldsig#");
                ki = this.unmarshalKeyInfo(child);
                child = DOMUtils.getNextSiblingElement(child);
                if (child != null) {
                    local = child.getLocalName();
                }
            }
            if (local != null && local.equals("CipherData")) {
                this.checkNamespace(child, "http://www.w3.org/2001/04/xmlenc#");
                cdata = DOMCipherData.getInstance(child, (XMLCryptoContext)this.context);
                child = DOMUtils.getNextSiblingElement(child);
                if (child != null) {
                    local = child.getLocalName();
                }
            }
            if (local != null && local.equals("EncryptionProperties")) {
                this.checkNamespace(child, "http://www.w3.org/2001/04/xmlenc#");
                ep = new DOMEncryptionProperties(child);
                child = DOMUtils.getNextSiblingElement(child);
                if (child != null) {
                    local = child.getLocalName();
                }
            }
            if (child != null) {
                if (isEncryptedKey) {
                    if (local != null && local.equals("ReferenceList")) {
                        this.checkNamespace(child, "http://www.w3.org/2001/04/xmlenc#");
                        rl = new DOMReferenceList(child);
                        child = DOMUtils.getNextSiblingElement(child);
                        if (child != null) {
                            local = child.getLocalName();
                        }
                    }
                    if (local != null && local.equals("CarriedKeyName")) {
                        this.checkNamespace(child, "http://www.w3.org/2001/04/xmlenc#");
                        carriedKeyName = DOMUtils.getTextContent(child);
                        child = DOMUtils.getNextSiblingElement(child);
                    }
                    if (child != null) {
                        throw new MarshalException("unexpected element in EncrytpedType");
                    }
                } else {
                    throw new MarshalException("unexpected element in EncrytpedType");
                }
            }
        }
        if (cdata == null) {
            throw new MarshalException("no CipherData in EncryptedType null");
        }
        if (isEncryptedKey) {
            return new DOMEncryptedKey(id, type, mimeType, encoding, recipient, em, (DOMKeyInfo)ki, cdata, ep, rl, carriedKeyName, elem);
        }
        return new DOMEncryptedData(id, type, mimeType, encoding, em, (DOMKeyInfo)ki, cdata, ep, elem);
    }

    private KeyInfo unmarshalKeyInfo(Element child) throws MarshalException {
        DOMKeyInfoFactory fac = new DOMKeyInfoFactory();
        DOMStructure dstr = new DOMStructure(child);
        return fac.unmarshalKeyInfo(dstr);
    }

    private void checkNamespace(Element child, String ns) throws MarshalException {
        String nsuri = child.getNamespaceURI();
        if (nsuri != null && !ns.equals(nsuri)) {
            throw new MarshalException("Unexpected element: " + child.getNodeName());
        }
    }

    private String getIdAttribute(Element elem, String key) {
        String id = this.getAttributeValue(elem, key);
        if (id != null && this.context != null) {
            this.context.setIdAttributeNS(elem, null, key);
        }
        return id;
    }

    private String getAttributeValue(Element elem, String key) {
        Attr a = elem.getAttributeNode(key);
        if (a == null) {
            return null;
        }
        return a.getNodeValue();
    }
}

