/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.DOMCanonicalizationMethod;
import com.ibm.xml.enc.dom.DOMCipherReference;
import com.ibm.xml.enc.dom.DOMDHKeyValue;
import com.ibm.xml.enc.dom.DOMDataReference;
import com.ibm.xml.enc.dom.DOMEncManager;
import com.ibm.xml.enc.dom.DOMEncryptedData;
import com.ibm.xml.enc.dom.DOMEncryptedKey;
import com.ibm.xml.enc.dom.DOMEncryptionMethod;
import com.ibm.xml.enc.dom.DOMEncryptionProperties;
import com.ibm.xml.enc.dom.DOMEncryptionProperty;
import com.ibm.xml.enc.dom.DOMKeyInfo;
import com.ibm.xml.enc.dom.DOMKeyReference;
import com.ibm.xml.enc.dom.DOMOriginatorKeyInfo;
import com.ibm.xml.enc.dom.DOMRecipientKeyInfo;
import com.ibm.xml.enc.dom.Unmarshalling;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.enc.CipherReference;
import javax.xml.crypto.enc.DataReference;
import javax.xml.crypto.enc.EncryptedData;
import javax.xml.crypto.enc.EncryptedType;
import javax.xml.crypto.enc.EncryptionMethod;
import javax.xml.crypto.enc.EncryptionProperties;
import javax.xml.crypto.enc.EncryptionProperty;
import javax.xml.crypto.enc.KeyReference;
import javax.xml.crypto.enc.ToBeEncrypted;
import javax.xml.crypto.enc.ToBeEncryptedKey;
import javax.xml.crypto.enc.XMLDecryptContext;
import javax.xml.crypto.enc.XMLEncryptionFactory;
import javax.xml.crypto.enc.dom.DOMDecryptContext;
import javax.xml.crypto.enc.keyinfo.AgreementMethod;
import javax.xml.crypto.enc.keyinfo.DHKeyValue;
import javax.xml.crypto.enc.keyinfo.EncryptedKey;
import javax.xml.crypto.enc.spec.AgreementMethodParameterSpec;
import javax.xml.crypto.enc.spec.EncryptionMethodParameterSpec;

public final class DOMXMLEncryptionFactory
extends XMLEncryptionFactory {
    public boolean isFeatureSupported(String feature) {
        if (feature == null) {
            throw new NullPointerException();
        }
        return false;
    }

    public AgreementMethod newAgreementMethod(String algorithm, byte[] kaNonce, KeyInfo originatorKeyInfo, KeyInfo recipientKeyInfo, AgreementMethodParameterSpec spec) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        throw new UnsupportedOperationException("AgreementMethod is not support in this release");
    }

    public CanonicalizationMethod newCanonicalizationMethod(String algorithm, C14NMethodParameterSpec params) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is null");
        }
        TransformService spi = TransformService.getInstance(algorithm, "DOM");
        spi.init(params);
        return new DOMCanonicalizationMethod(spi);
    }

    public CipherReference newCipherReference(String uri, List transforms) {
        return new DOMCipherReference(uri, transforms);
    }

    public DataReference newDataReference(String uri, List content) {
        return new DOMDataReference(uri, content);
    }

    public EncryptedData newEncryptedData(ToBeEncrypted toBeEncrypted, EncryptionMethod encMethod, KeyInfo keyInfo, EncryptionProperties properties, String id) {
        if (toBeEncrypted == null) {
            throw new NullPointerException("toBeEncrypted is null");
        }
        if (toBeEncrypted instanceof ToBeEncryptedKey) {
            throw new IllegalArgumentException("ToBeEncryptedKey is passed in as toBeEncrypted");
        }
        DOMEncryptionMethod dem = null;
        DOMKeyInfo dki = null;
        DOMEncryptionProperties deps = null;
        if (encMethod == null || encMethod instanceof DOMEncryptionMethod) {
            dem = (DOMEncryptionMethod)encMethod;
        } else {
            try {
                dem = (DOMEncryptionMethod)((Object)DOMEncManager.getEncryptionMethod(encMethod.getAlgorithm(), encMethod.getKeySize(), encMethod.getParameterSpec()));
            }
            catch (Exception ex) {
                throw (IllegalArgumentException)new IllegalArgumentException("Unsupported EncryptionMethod type").initCause(ex);
            }
        }
        dki = keyInfo == null || keyInfo instanceof DOMKeyInfo ? (DOMKeyInfo)keyInfo : new DOMKeyInfo(keyInfo.getContent(), keyInfo.getId());
        deps = properties == null || properties instanceof DOMEncryptionProperties ? (DOMEncryptionProperties)properties : new DOMEncryptionProperties(properties.getProperties(), properties.getId());
        return new DOMEncryptedData(toBeEncrypted, dem, dki, deps, id);
    }

    public EncryptedData newEncryptedData(ToBeEncrypted toBeEncrypted, EncryptionMethod encMethod, KeyInfo keyInfo, EncryptionProperties properties, String id, CipherReference cipherRef) {
        if (toBeEncrypted == null) {
            throw new NullPointerException("toBeEncrypted is null");
        }
        if (toBeEncrypted instanceof ToBeEncryptedKey) {
            throw new IllegalArgumentException("ToBeEncryptedKey is passed in as toBeEncrypted");
        }
        if (cipherRef == null) {
            throw new NullPointerException("cipherRef is null");
        }
        DOMEncryptionMethod dem = null;
        DOMKeyInfo dki = null;
        DOMEncryptionProperties deps = null;
        DOMCipherReference dcr = null;
        if (encMethod == null || encMethod instanceof DOMEncryptionMethod) {
            dem = (DOMEncryptionMethod)encMethod;
        } else {
            try {
                dem = (DOMEncryptionMethod)((Object)DOMEncManager.getEncryptionMethod(encMethod.getAlgorithm(), encMethod.getKeySize(), encMethod.getParameterSpec()));
            }
            catch (Exception ex) {
                throw (IllegalArgumentException)new IllegalArgumentException("Unsupported EncryptionMethod type").initCause(ex);
            }
        }
        dki = keyInfo == null || keyInfo instanceof DOMKeyInfo ? (DOMKeyInfo)keyInfo : new DOMKeyInfo(keyInfo.getContent(), keyInfo.getId());
        deps = properties == null || properties instanceof DOMEncryptionProperties ? (DOMEncryptionProperties)properties : new DOMEncryptionProperties(properties.getProperties(), properties.getId());
        dcr = cipherRef instanceof DOMCipherReference ? (DOMCipherReference)cipherRef : new DOMCipherReference(cipherRef.getURI(), cipherRef.getTransforms());
        return new DOMEncryptedData(toBeEncrypted, dem, dki, deps, id, dcr);
    }

    public EncryptedKey newEncryptedKey(ToBeEncryptedKey key, EncryptionMethod encMethod, KeyInfo keyInfo, EncryptionProperties properties, List references, String carriedKeyName, String recipient, String id) {
        if (key == null) {
            throw new NullPointerException("ToBeEncryptedKey is null");
        }
        DOMEncryptionMethod dem = null;
        DOMKeyInfo dki = null;
        DOMEncryptionProperties deps = null;
        if (encMethod == null || encMethod instanceof DOMEncryptionMethod) {
            dem = (DOMEncryptionMethod)encMethod;
        } else {
            try {
                dem = (DOMEncryptionMethod)((Object)DOMEncManager.getEncryptionMethod(encMethod.getAlgorithm(), encMethod.getKeySize(), encMethod.getParameterSpec()));
            }
            catch (Exception ex) {
                throw (ClassCastException)new ClassCastException("Unsupported EncryptionMethod type").initCause(ex);
            }
        }
        dki = keyInfo == null || keyInfo instanceof DOMKeyInfo ? (DOMKeyInfo)keyInfo : new DOMKeyInfo(keyInfo.getContent(), keyInfo.getId());
        deps = properties == null || properties instanceof DOMEncryptionProperties ? (DOMEncryptionProperties)properties : new DOMEncryptionProperties(properties.getProperties(), properties.getId());
        if (references != null && references.size() > 0) {
            for (Object obj : references) {
                if (obj instanceof DataReference || obj instanceof KeyReference) continue;
                throw new ClassCastException("References list contains entries that are not type of DataReference or KeyReference");
            }
        }
        return new DOMEncryptedKey(key, dem, dki, deps, references, carriedKeyName, recipient, id);
    }

    public EncryptedKey newEncryptedKey(ToBeEncryptedKey key, EncryptionMethod encMethod, KeyInfo keyInfo, EncryptionProperties properties, List references, String carriedKeyName, String recipient, String id, CipherReference cipherRef) {
        if (key == null) {
            throw new NullPointerException("ToBeEncryptedKey is null");
        }
        if (cipherRef == null) {
            throw new NullPointerException("CipherReference is null");
        }
        DOMEncryptionMethod dem = null;
        DOMKeyInfo dki = null;
        DOMEncryptionProperties deps = null;
        DOMCipherReference dcr = null;
        if (encMethod == null || encMethod instanceof DOMEncryptionMethod) {
            dem = (DOMEncryptionMethod)encMethod;
        } else {
            try {
                dem = (DOMEncryptionMethod)((Object)DOMEncManager.getEncryptionMethod(encMethod.getAlgorithm(), encMethod.getKeySize(), encMethod.getParameterSpec()));
            }
            catch (Exception ex) {
                throw (ClassCastException)new ClassCastException("Unsupported EncryptionMethod type").initCause(ex);
            }
        }
        dki = keyInfo == null || keyInfo instanceof DOMKeyInfo ? (DOMKeyInfo)keyInfo : new DOMKeyInfo(keyInfo.getContent(), keyInfo.getId());
        deps = properties == null || properties instanceof DOMEncryptionProperties ? (DOMEncryptionProperties)properties : new DOMEncryptionProperties(properties.getProperties(), properties.getId());
        dcr = cipherRef instanceof DOMCipherReference ? (DOMCipherReference)cipherRef : new DOMCipherReference(cipherRef.getURI(), cipherRef.getTransforms());
        if (references != null && references.size() > 0) {
            for (Object obj : references) {
                if (obj instanceof DataReference || obj instanceof KeyReference) continue;
                throw new ClassCastException("References list contains entries that are not type of DataReference or KeyReference");
            }
        }
        return new DOMEncryptedKey(key, dem, dki, deps, references, carriedKeyName, recipient, id, dcr);
    }

    public EncryptionMethod newEncryptionMethod(String algorithm, Integer keySize, EncryptionMethodParameterSpec params) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is null");
        }
        return (EncryptionMethod)DOMEncManager.getEncryptionMethod(algorithm, keySize, (AlgorithmParameterSpec)params);
    }

    public EncryptionProperties newEncryptionProperties(List properties, String id) {
        if (properties == null) {
            throw new NullPointerException("properties is null");
        }
        if (properties.isEmpty()) {
            throw new IllegalArgumentException("properties is empty");
        }
        List ppts = new ArrayList();
        for (Object obj : properties) {
            if (obj instanceof EncryptionProperty) {
                ppts.add(obj);
                continue;
            }
            throw new ClassCastException("properties contains an entry that is not of type EncryptionProperty");
        }
        ppts = Collections.unmodifiableList(ppts);
        return new DOMEncryptionProperties(ppts, id);
    }

    public EncryptionProperty newEncryptionProperty(List content, String target, String id, Map attributes) {
        return new DOMEncryptionProperty(content, target, id, attributes);
    }

    public KeyReference newKeyReference(String uri, List content) {
        return new DOMKeyReference(uri, content);
    }

    public EncryptedType unmarshalEncryptedType(XMLDecryptContext context) throws MarshalException {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (context instanceof DOMDecryptContext) {
            return Unmarshalling.unmarshal(context);
        }
        throw new ClassCastException("context type is inappropriate for this factory");
    }

    public KeyInfo newOriginatorKeyInfo(List content, String id) throws IllegalArgumentException {
        return new DOMOriginatorKeyInfo(content, id);
    }

    public KeyInfo newRecipientKeyInfo(List content, String id) throws IllegalArgumentException {
        return new DOMRecipientKeyInfo(content, id);
    }

    public DHKeyValue newDHKeyValue(PublicKey publicKey) throws KeyException {
        return new DOMDHKeyValue(publicKey);
    }
}

