/**
 * Copyright (C) 2002
 */

package org.objectweb.util.ant;

import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;

import java.io.File;

/**
 * This simple task permits to list a set of directories.
 * The result is print on the System.out output.
 *
 * @author Sebastien Chassande-Barrioz
 */
public class Ls extends MatchingTask {

	File dir =  null;

	public void setDir(File d) {
		dir = d;
	}

	public void execute() throws BuildException {
		DirectoryScanner ds = getDirectoryScanner(dir);
		String[] filenames = ds.getIncludedFiles();
		for (int i=0; i<filenames.length; i++) {
			System.out.println(filenames[i]);
		}
	}
}
