/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.ant;

import java.io.File;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class MultipleCopy
extends Copy {
    protected File basedir = null;
    protected String myFile = null;
    protected boolean notReplace = true;
    protected boolean useDefaultExcludes = true;
    protected FileSet fileset = new FileSet();

    public void execute() throws BuildException {
        DirectoryScanner ds = this.getDirectoryScanner(this.basedir);
        String[] dirs = ds.getIncludedDirectories();
        String fileName = null;
        for (int i = 0; i < dirs.length; ++i) {
            if (this.myFile == null) {
                fileName = this.basedir + "/" + dirs[i];
                super.setTodir(new File(fileName));
                super.setTofile(null);
            } else {
                super.setTodir(null);
                fileName = this.basedir + "/" + dirs[i] + "/" + this.myFile;
                super.setTofile(new File(fileName));
            }
            this.log("File name = " + fileName, 4);
            this.copy();
        }
    }

    public void copy() throws BuildException {
        boolean ant16 = false;
        String version = this.getProject().getProperty("ant.version");
        StringTokenizer st = new StringTokenizer(version, " ");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.length() <= 2 || !Character.isDigit(s.charAt(0)) || s.charAt(1) != '.') continue;
            if (s.charAt(0) - 48 > 1) {
                ant16 = true;
                break;
            }
            if (s.charAt(2) - 48 <= 5) break;
            ant16 = true;
            break;
        }
        this.validateAttributes();
        if (this.file != null) {
            if (this.file.exists()) {
                if (this.destFile == null) {
                    this.destFile = new File(this.destDir, this.file.getName());
                }
                if (!this.destFile.exists()) {
                    if (ant16) {
                        this.fileCopyMap.put(this.file.getAbsolutePath(), new String[]{this.destFile.getAbsolutePath()});
                    } else {
                        this.fileCopyMap.put(this.file.getAbsolutePath(), this.destFile.getAbsolutePath());
                    }
                } else if (!this.notReplace && (this.forceOverwrite || this.file.lastModified() > this.destFile.lastModified())) {
                    if (ant16) {
                        this.fileCopyMap.put(this.file.getAbsolutePath(), new String[]{this.destFile.getAbsolutePath()});
                    } else {
                        this.fileCopyMap.put(this.file.getAbsolutePath(), this.destFile.getAbsolutePath());
                    }
                } else {
                    this.log(this.file + " omitted as " + this.destFile + " is up to date.", 3);
                }
            } else {
                String message = "Could not find file " + this.file.getAbsolutePath() + " to copy.";
                this.log(message);
                throw new BuildException(message);
            }
        }
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            File fromDir = fs.getDir(this.project);
            String[] srcFiles = ds.getIncludedFiles();
            String[] srcDirs = ds.getIncludedDirectories();
            this.scan(fromDir, this.destDir, srcFiles, srcDirs);
        }
        this.doFileOperations();
        if (this.destFile != null) {
            this.destDir = null;
        }
    }

    public void setNotReplace(boolean nr) {
        this.notReplace = nr;
    }

    public void setTodir(File bd) {
        this.basedir = bd;
    }

    public void setTofile(String f) {
        this.myFile = f;
    }

    public PatternSet.NameEntry createInclude() {
        return this.fileset.createInclude();
    }

    public PatternSet.NameEntry createIncludesFile() {
        return this.fileset.createIncludesFile();
    }

    public PatternSet.NameEntry createExclude() {
        return this.fileset.createExclude();
    }

    public PatternSet.NameEntry createExcludesFile() {
        return this.fileset.createExcludesFile();
    }

    public PatternSet createPatternSet() {
        return this.fileset.createPatternSet();
    }

    public void setIncludes(String includes) {
        this.fileset.setIncludes(includes);
    }

    public void setExcludes(String excludes) {
        this.fileset.setExcludes(excludes);
    }

    public void setDefaultexcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }

    protected DirectoryScanner getDirectoryScanner(File baseDir) {
        this.fileset.setDir(baseDir);
        this.fileset.setDefaultexcludes(this.useDefaultExcludes);
        return this.fileset.getDirectoryScanner(this.project);
    }

    public void setIncludesfile(File includesfile) {
        this.fileset.setIncludesfile(includesfile);
    }

    public void setExcludesfile(File excludesfile) {
        this.fileset.setExcludesfile(excludesfile);
    }
}

