/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.ant;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class MultipleAnt
extends Ant
implements FilenameFilter {
    protected File directory = null;
    protected String antFile = null;
    protected String target = null;
    protected boolean useDefaultExcludes = true;
    protected FileSet fileset = new FileSet();

    public void execute() throws BuildException {
        String fileName = null;
        try {
            if (this.directory == null) {
                throw new BuildException("The Dir parameter is required !");
            }
            DirectoryScanner ds = this.getDirectoryScanner(this.directory);
            String[] dirs = ds.getIncludedDirectories();
            if (dirs == null || dirs.length == 0) {
                this.log("No directory found", 4);
                return;
            }
            for (int j = 0; j < dirs.length; ++j) {
                File dir = new File(this.directory.getAbsolutePath() + File.separator + dirs[j]);
                this.log("Directory=" + dir.getAbsolutePath(), 4);
                if (this.antFile != null) {
                    fileName = dir.getAbsolutePath() + File.separator + this.antFile;
                    if (!new File(fileName).exists()) continue;
                    this.log("execute=" + fileName, 4);
                    super.setAntfile(fileName);
                    if (this.target != null) {
                        super.setTarget(this.target);
                    }
                    super.execute();
                    continue;
                }
                String[] xmls = dir.list(this);
                if (xmls == null) {
                    this.log("No xml file found", 4);
                    continue;
                }
                for (int i = 0; i < xmls.length; ++i) {
                    fileName = this.directory.getAbsolutePath() + File.separator + xmls[i];
                    this.log("execute=" + fileName, 3);
                    super.setAntfile(fileName);
                    if (this.target != null) {
                        super.setTarget(this.target);
                    }
                    try {
                        super.execute();
                        continue;
                    }
                    catch (Exception e) {
                        this.log("Error in " + fileName + " file:\n\t" + e.getMessage(), 3);
                    }
                }
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            this.log("Error in " + fileName + " file:\n\t" + e.getMessage(), 0);
            throw new BuildException((Throwable)e);
        }
    }

    public void setDir(File d) {
        this.directory = d;
    }

    public void setAntFile(String f) {
        this.antFile = f;
    }

    public void setTarget(String t) {
        this.target = t;
    }

    public boolean accept(File dir, String name) {
        return name != null && dir != null && dir.equals(this.directory) && name.endsWith(".xml");
    }

    public PatternSet.NameEntry createInclude() {
        return this.fileset.createInclude();
    }

    public PatternSet.NameEntry createIncludesFile() {
        return this.fileset.createIncludesFile();
    }

    public PatternSet.NameEntry createExclude() {
        return this.fileset.createExclude();
    }

    public PatternSet.NameEntry createExcludesFile() {
        return this.fileset.createExcludesFile();
    }

    public PatternSet createPatternSet() {
        return this.fileset.createPatternSet();
    }

    public void setIncludes(String includes) {
        this.fileset.setIncludes(includes);
    }

    public void setExcludes(String excludes) {
        this.fileset.setExcludes(excludes);
    }

    public void setDefaultexcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }

    protected DirectoryScanner getDirectoryScanner(File baseDir) {
        this.fileset.setDir(baseDir);
        this.fileset.setDefaultexcludes(this.useDefaultExcludes);
        return this.fileset.getDirectoryScanner(this.project);
    }

    public void setIncludesfile(File includesfile) {
        this.fileset.setIncludesfile(includesfile);
    }

    public void setExcludesfile(File excludesfile) {
        this.fileset.setExcludesfile(excludesfile);
    }
}

