/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.UpToDate;
import org.apache.tools.ant.types.FileSet;

public class Jar2packageList
extends MatchingTask {
    File jarDir = null;
    File output = null;
    boolean flatten = false;
    boolean isolate = false;

    public void setJarDir(File d) {
        this.jarDir = d;
    }

    public void setOutput(File o) {
        this.output = o;
    }

    public void setFlatten(boolean b) {
        this.flatten = b;
    }

    public void setIsolate(boolean b) {
        this.isolate = b;
    }

    public void execute() throws BuildException {
        DirectoryScanner ds = this.getDirectoryScanner(this.jarDir);
        String[] filenames = ds.getIncludedFiles();
        boolean hasGenerate = false;
        for (int i = 0; i < filenames.length; ++i) {
            try {
                boolean generate;
                String pf;
                String path;
                TreeSet<String> packages = new TreeSet<String>();
                File jarfile = new File(this.jarDir, filenames[i]);
                if (jarfile.isDirectory()) {
                    this.log("Ignore '" + filenames[i] + "': is a directory.", 4);
                    continue;
                }
                ZipFile archive = null;
                try {
                    archive = new ZipFile(jarfile);
                }
                catch (IOException e) {
                    this.log("Ignore '" + filenames[i] + "': not an archive.", 4);
                    continue;
                }
                this.log("Manage the archive '" + filenames[i] + "'.", 4);
                String sn = jarfile.getName();
                int idx = sn.lastIndexOf(46);
                if (idx != -1) {
                    sn = sn.substring(0, idx);
                }
                String ext = "package-list";
                if (this.flatten) {
                    if (this.isolate) {
                        // empty if block
                    }
                } else {
                    path = filenames[i];
                    idx = path.lastIndexOf(46);
                    if (idx != -1) {
                        path = path.substring(0, idx);
                    }
                    if (this.isolate) {
                        // empty if block
                    }
                }
                if (this.isolate) {
                    if (this.flatten) {
                        pf = sn + File.separatorChar + "package-list";
                    } else {
                        path = filenames[i];
                        idx = path.lastIndexOf(46);
                        if (idx != -1) {
                            path = path.substring(0, idx);
                        }
                        pf = path + File.separatorChar + "package-list";
                    }
                } else {
                    pf = this.flatten ? "package-list" : filenames[i];
                }
                File packageList = new File(this.output, pf);
                FileSet fs = new FileSet();
                fs.setDir(jarfile.getParentFile());
                fs.setIncludes(jarfile.getName());
                UpToDate u = new UpToDate();
                u.setTaskName(this.getTaskName());
                u.setProject(this.project);
                u.addSrcfiles(fs);
                u.setTargetFile(packageList);
                boolean bl = generate = !u.eval();
                if (!generate) continue;
                File parent = packageList.getParentFile();
                if (!parent.exists() && !parent.mkdirs()) {
                    throw new BuildException("Impossible to create the directory " + parent.getAbsolutePath());
                }
                if (packageList.exists() && !packageList.delete()) {
                    throw new BuildException("Impossible to update the file " + packageList.getAbsolutePath());
                }
                if (!packageList.createNewFile()) {
                    throw new BuildException("Impossible to create the file " + packageList.getAbsolutePath());
                }
                if (!hasGenerate) {
                    hasGenerate = true;
                    this.log("Create package-list file into the directory: '" + this.output.getAbsolutePath() + "'", 2);
                }
                this.log("\t- " + pf, 2);
                Enumeration<? extends ZipEntry> en = archive.entries();
                while (en.hasMoreElements()) {
                    ZipEntry je = en.nextElement();
                    if (!je.getName().endsWith("/") || je.getName().startsWith("META-INF")) continue;
                    String packName = je.getName().substring(0, je.getName().length() - 1);
                    packName = packName.replace(File.separatorChar, '.');
                    packages.add(packName);
                }
                FileWriter fw = new FileWriter(packageList);
                Iterator it = packages.iterator();
                while (it.hasNext()) {
                    String packName = (String)it.next();
                    this.log("\t-package: " + packName, 4);
                    fw.write(packName + "\n");
                }
                fw.close();
                continue;
            }
            catch (BuildException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                throw new BuildException("Impossible to manage the file " + filenames[i]);
            }
        }
    }
}

