/*
 * Copyright (c) 2016, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package org.graalvm.compiler.nodes.spi;

import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;

/**
 * A provider that enables overriding and customization of the {@link NodeCycles} and
 * {@link NodeSize} values for a {@linkplain Node node}.
 */
public interface NodeCostProvider {

    /**
     * Gets the estimated size of machine code generated for {@code n}.
     */
    int getEstimatedCodeSize(Node n);

    /**
     * Gets the estimated execution cost for {@code n} in terms of CPU cycles.
     */
    int getEstimatedCPUCycles(Node n);

    /**
     * @see NodeInfo#size()
     */
    NodeSize size(Node n);

    /**
     * @see NodeInfo#cycles()
     */
    NodeCycles cycles(Node n);

}
