#ifndef _LIVEPATCH_BSC1203994_H
#define _LIVEPATCH_BSC1203994_H

#if IS_ENABLED(CONFIG_CFG80211)

int livepatch_bsc1203994_init(void);
void livepatch_bsc1203994_cleanup(void);


#include <linux/types.h>

struct wiphy;
struct cfg80211_inform_bss;
struct ieee80211_mgmt;
enum cfg80211_bss_frame_type;
struct cfg80211_non_tx_bss;
struct ieee80211_channel;
enum ieee80211_bss_type;
enum ieee80211_privacy;
struct cfg80211_registered_device;
struct cfg80211_internal_bss;
struct cfg80211_non_tx_bss;
struct ieee80211_sub_if_data;
struct sk_buff;
struct ieee80211_local;
struct sta_info;
struct ieee80211_rx_status;

struct cfg80211_bss *
klpp_cfg80211_inform_bss_frame_data(struct wiphy *wiphy,
			       struct cfg80211_inform_bss *data,
			       struct ieee80211_mgmt *mgmt, size_t len,
			       gfp_t gfp);

void klpp_cfg80211_parse_mbssid_data(struct wiphy *wiphy,
				       struct cfg80211_inform_bss *data,
				       enum cfg80211_bss_frame_type ftype,
				       const u8 *bssid, u64 tsf,
				       u16 beacon_interval, const u8 *ie,
				       size_t ielen,
				       struct cfg80211_non_tx_bss *non_tx_data,
				       gfp_t gfp);

void klpp_cfg80211_ref_bss(struct wiphy *wiphy, struct cfg80211_bss *bss);

struct cfg80211_bss *klpp_cfg80211_get_bss(struct wiphy *wiphy,
				      struct ieee80211_channel *channel,
				      const u8 *bssid,
				      const u8 *ssid, size_t ssid_len,
				      enum ieee80211_bss_type bss_type,
				      enum ieee80211_privacy privacy);

struct cfg80211_internal_bss *
klpp_cfg80211_bss_update(struct cfg80211_registered_device *rdev,
		    struct cfg80211_internal_bss *tmp,
		    bool signal_valid, unsigned long ts);

struct cfg80211_bss *
klpp_cfg80211_inform_single_bss_data(struct wiphy *wiphy,
				struct cfg80211_inform_bss *data,
				enum cfg80211_bss_frame_type ftype,
				const u8 *bssid, u64 tsf, u16 capability,
				u16 beacon_interval, const u8 *ie, size_t ielen,
				struct cfg80211_non_tx_bss *non_tx_data,
				gfp_t gfp);


void klpp_ieee80211_sta_rx_queued_mgmt(struct ieee80211_sub_if_data *sdata,
				  struct sk_buff *skb);


void klpp_ieee80211_process_addba_request(struct ieee80211_local *local,
				     struct sta_info *sta,
				     struct ieee80211_mgmt *mgmt,
				     size_t len);


void klpp_ieee80211_ibss_rx_queued_mgmt(struct ieee80211_sub_if_data *sdata,
				   struct sk_buff *skb);


void
klpp_ieee80211_mesh_rx_probe_req(struct ieee80211_sub_if_data *sdata,
			    struct ieee80211_mgmt *mgmt, size_t len);

void klpp_ieee80211_mesh_rx_bcn_presp(struct ieee80211_sub_if_data *sdata,
					u16 stype,
					struct ieee80211_mgmt *mgmt,
					size_t len,
					struct ieee80211_rx_status *rx_status);

void klpp_mesh_rx_csa_frame(struct ieee80211_sub_if_data *sdata,
			      struct ieee80211_mgmt *mgmt, size_t len);


void klpp_mesh_rx_path_sel_frame(struct ieee80211_sub_if_data *sdata,
			    struct ieee80211_mgmt *mgmt, size_t len);


void klpp_mesh_rx_plink_frame(struct ieee80211_sub_if_data *sdata,
			 struct ieee80211_mgmt *mgmt, size_t len,
			 struct ieee80211_rx_status *rx_status);


struct ieee80211_bss *
klpp_ieee80211_bss_info_update(struct ieee80211_local *local,
			  struct ieee80211_rx_status *rx_status,
			  struct ieee80211_mgmt *mgmt,
			  size_t len,
			  struct ieee80211_channel *channel);


int
klpp_ieee80211_process_tdls_channel_switch_resp(struct ieee80211_sub_if_data *sdata,
					   struct sk_buff *skb);

int
klpp_ieee80211_process_tdls_channel_switch_req(struct ieee80211_sub_if_data *sdata,
					  struct sk_buff *skb);

#else /* !IS_ENABLED(CONFIG_CFG80211) */

static inline int livepatch_bsc1203994_init(void) { return 0; }

static inline void livepatch_bsc1203994_cleanup(void) {}

#endif /* IS_ENABLED(CONFIG_CFG80211) */
#endif /* _LIVEPATCH_BSC1203994_H */
