/*
 * livepatch_bsc1203994
 *
 * Fix for CVE-2022-41674, CVE-2022-42719, CVE-2022-42720 and CVE-2022-42721,
 * bsc#1203994
 *
 *  Upstream commits:
 *  none yet, embargoed
 *
 *  SLE12-SP4, SLE12-SP5, SLE15 and SLE15-SP1 commit:
 *  not affected
 *
 *  SLE15-SP2 and -SP3 commits:
 *  30119045d35eeaeb561821192e2a0be8c1f4dea7
 *  6dca1236024b1224959a992a88954514876edf44
 *  a878ee763f3d3b555ac8dbd62129579073e66898
 *  7c818bd4d9a5a0962120f1fdd06d10f565ecfff3
 *  242ae2d4d4804d94f5e4e67ee626fbd64f4830db
 *  03c3aab05d493a717205a097c88acdfa954c8722
 *  84fc5c8efff04872d0238db1ee603570e2d23936
 *  d00612a01f149ee40939f04e3d27499bc5620f28
 *  1d0e42c6dc389ae5c5b9397e55ebb0fcacd8b5b4
 *  7b3171e58a28ea6f47c88b47bf819904e1bfac5e
 *  561b313a9474ce294f953c6375c8b4f8761821f6
 *  36cb3f6a407aaec0cf6ce7dc5556c7de0864dffd
 *  ad43041ebcdcae579607732b115d1091e0a0e932
 *
 *  SLE15-SP4 commits:
 *  3e5796194e6f6006c633182d2edd4a5ac6dd689d
 *  9d06bac5bf1cb3081eb75173ff166c7352bfd49f
 *  79b409a4702c62635f9370cafac0ca026431349d
 *  89a7514cdf79c07ac96a2afadf96a05de96bf793
 *  c22c5bd0a6722f6db2f59a0ed9a4061367624795
 *  1f81fb30ad2819159802911121a1df942ee65075
 *  8eb9669934861352335b6a3471c966f957e0531b
 *  f9a2be2ba68cea18bae05c251a48cec4d9d66d3f
 *  b28a982f4dcace339754d964c5f585c0f907940f
 *  bab6e583a8cbde5be70a7ee94b1b0bb41fdb5231
 *  ab97d8c344d1c4a4389c12ebdc7181e0089d0bb4
 *  82311e448a947db7aafa6de85ea0d4ebb922935c
 *
 *
 *  Copyright (c) 2022 SUSE
 *  Author: Nicolai Stange <nstange@suse.de>
 *
 *  Based on the original Linux kernel code. Other copyrights apply.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#if IS_ENABLED(CONFIG_CFG80211)

#if !IS_MODULE(CONFIG_CFG80211)
#error "Live patch supports only CONFIG_CFG80211=m"
#endif

#include <linux/kernel.h>
#include <linux/module.h>
#include "livepatch_bsc1203994.h"
#include "bsc1203994_common.h"

int livepatch_bsc1203994_init(void)
{
	int ret;

	ret = bsc1203994_cfg80211_scan_init();
	if (ret)
		return ret;

	ret = bsc1203994_mac80211_mlme_init();
	if (ret) {
		bsc1203994_cfg80211_scan_cleanup();
		return ret;
	}

	ret = bsc1203994_mac80211_util_init();
	if (ret) {
		bsc1203994_mac80211_mlme_cleanup();
		bsc1203994_cfg80211_scan_cleanup();
		return ret;
	}

	ret = bsc1203994_mac80211_agg_rx_init();
	if (ret) {
		bsc1203994_mac80211_util_cleanup();
		bsc1203994_mac80211_mlme_cleanup();
		bsc1203994_cfg80211_scan_cleanup();
		return ret;
	}

	ret = bsc1203994_mac80211_ibss_init();
	if (ret) {
		bsc1203994_mac80211_agg_rx_cleanup();
		bsc1203994_mac80211_util_cleanup();
		bsc1203994_mac80211_mlme_cleanup();
		bsc1203994_cfg80211_scan_cleanup();
		return ret;
	}

	ret = bsc1203994_mac80211_mesh_init();
	if (ret) {
		bsc1203994_mac80211_ibss_cleanup();
		bsc1203994_mac80211_agg_rx_cleanup();
		bsc1203994_mac80211_util_cleanup();
		bsc1203994_mac80211_mlme_cleanup();
		bsc1203994_cfg80211_scan_cleanup();
		return ret;
	}

	ret = bsc1203994_mac80211_mesh_hwmp_init();
	if (ret) {
		bsc1203994_mac80211_mesh_cleanup();
		bsc1203994_mac80211_ibss_cleanup();
		bsc1203994_mac80211_agg_rx_cleanup();
		bsc1203994_mac80211_util_cleanup();
		bsc1203994_mac80211_mlme_cleanup();
		bsc1203994_cfg80211_scan_cleanup();
		return ret;
	}

	ret = bsc1203994_mac80211_mesh_plink_init();
	if (ret) {
		bsc1203994_mac80211_mesh_hwmp_cleanup();
		bsc1203994_mac80211_mesh_cleanup();
		bsc1203994_mac80211_ibss_cleanup();
		bsc1203994_mac80211_agg_rx_cleanup();
		bsc1203994_mac80211_util_cleanup();
		bsc1203994_mac80211_mlme_cleanup();
		bsc1203994_cfg80211_scan_cleanup();
		return ret;
	}

	ret = bsc1203994_mac80211_scan_init();
	if (ret) {
		bsc1203994_mac80211_mesh_plink_cleanup();
		bsc1203994_mac80211_mesh_hwmp_cleanup();
		bsc1203994_mac80211_mesh_cleanup();
		bsc1203994_mac80211_ibss_cleanup();
		bsc1203994_mac80211_agg_rx_cleanup();
		bsc1203994_mac80211_util_cleanup();
		bsc1203994_mac80211_mlme_cleanup();
		bsc1203994_cfg80211_scan_cleanup();
		return ret;
	}

	ret = bsc1203994_mac80211_tdls_init();
	if (ret) {
		bsc1203994_mac80211_scan_cleanup();
		bsc1203994_mac80211_mesh_plink_cleanup();
		bsc1203994_mac80211_mesh_hwmp_cleanup();
		bsc1203994_mac80211_mesh_cleanup();
		bsc1203994_mac80211_ibss_cleanup();
		bsc1203994_mac80211_agg_rx_cleanup();
		bsc1203994_mac80211_util_cleanup();
		bsc1203994_mac80211_mlme_cleanup();
		bsc1203994_cfg80211_scan_cleanup();
		return ret;
	}

	return 0;
}

void livepatch_bsc1203994_cleanup(void)
{
	bsc1203994_mac80211_tdls_cleanup();
	bsc1203994_mac80211_scan_cleanup();
	bsc1203994_mac80211_mesh_plink_cleanup();
	bsc1203994_mac80211_mesh_hwmp_cleanup();
	bsc1203994_mac80211_mesh_cleanup();
	bsc1203994_mac80211_ibss_cleanup();
	bsc1203994_mac80211_agg_rx_cleanup();
	bsc1203994_mac80211_util_cleanup();
	bsc1203994_mac80211_mlme_cleanup();
	bsc1203994_cfg80211_scan_cleanup();
}

#endif /* IS_ENABLED(CONFIG_CFG80211) */
