/*
 * livepatch_bsc1200059
 *
 * Fix for CVE-2022-21499, bsc#1200059
 *
 *  Upstream commit:
 *  eadb2f47a3ce ("lockdown: also lock down previous kgdb use")
 *
 *  SLE12-SP4 commit:
 *  0b6608d35aa3f0087f2370ab6bde40070dfdacba
 *
 *  SLE12-SP5, SLE15 and SLE15-SP1 commit:
 *  1cd17a0e830009531fc4a55f185b4d5cb14e9557
 *
 *  SLE15-SP2 and -SP3 commit:
 *  090b59efc25d5edb0c8e2468964c264c3c0debb2
 *
 *  SLE15-SP4 commit:
 *  251570ddfff55a5a7ed492de51156e299430c39e
 *
 *
 *  Copyright (c) 2022 SUSE
 *  Author: Nicolai Stange <nstange@suse.de>
 *
 *  Based on the original Linux kernel code. Other copyrights apply.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#if IS_ENABLED(CONFIG_KGDB)

#include <linux/kernel.h>
#include "livepatch_bsc1200059.h"
#include "bsc1200059_common.h"

int livepatch_bsc1200059_init(void)
{
	int r;

	r = livepatch_bsc1200059_debug_core_init();
	if (r)
		return r;

	r = livepatch_bsc1200059_kdb_main_init();
	if (r) {
		livepatch_bsc1200059_debug_core_cleanup();
		return r;
	}

	return 0;
}

void livepatch_bsc1200059_cleanup(void)
{
	livepatch_bsc1200059_kdb_main_cleanup();
	livepatch_bsc1200059_debug_core_cleanup();
}

#endif /* IS_ENABLED(CONFIG_KGDB) */
