#ifndef _LIVEPATCH_BSC1198133_H
#define _LIVEPATCH_BSC1198133_H

#if IS_ENABLED(CONFIG_X86_64)

int livepatch_bsc1198133_init(void);
void livepatch_bsc1198133_cleanup(void);


#include <linux/kvm_types.h>

struct guest_walkerEPT;
struct guest_walker64;
struct guest_walker32;
struct kvm_mmu;

int klpp_ept_walk_addr_generic(struct guest_walkerEPT *walker,
				    struct kvm_vcpu *vcpu, struct kvm_mmu *mmu,
				    gva_t addr, u32 access);

int klpp_paging64_walk_addr_generic(struct guest_walker64 *walker,
				    struct kvm_vcpu *vcpu, struct kvm_mmu *mmu,
				    gva_t addr, u32 access);

int klpp_paging32_walk_addr_generic(struct guest_walker32 *walker,
				    struct kvm_vcpu *vcpu, struct kvm_mmu *mmu,
				    gva_t addr, u32 access);

#else /* !IS_ENABLED(CONFIG_X86_64) */

static inline int livepatch_bsc1198133_init(void) { return 0; }
static inline void livepatch_bsc1198133_cleanup(void) {}

#endif /* IS_ENABLED(CONFIG_X86_64) */

#endif /* _LIVEPATCH_BSC1198133_H */
