// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vedbm

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeDBInstanceDetailCommon = "DescribeDBInstanceDetail"

// DescribeDBInstanceDetailCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeDBInstanceDetailCommon operation. The "output" return
// value will be populated with the DescribeDBInstanceDetailCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeDBInstanceDetailCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeDBInstanceDetailCommon Send returns without error.
//
// See DescribeDBInstanceDetailCommon for more information on using the DescribeDBInstanceDetailCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeDBInstanceDetailCommonRequest method.
//    req, resp := client.DescribeDBInstanceDetailCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEDBM) DescribeDBInstanceDetailCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeDBInstanceDetailCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeDBInstanceDetailCommon API operation for VEDBM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEDBM's
// API operation DescribeDBInstanceDetailCommon for usage and error information.
func (c *VEDBM) DescribeDBInstanceDetailCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeDBInstanceDetailCommonRequest(input)
	return out, req.Send()
}

// DescribeDBInstanceDetailCommonWithContext is the same as DescribeDBInstanceDetailCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBInstanceDetailCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEDBM) DescribeDBInstanceDetailCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeDBInstanceDetailCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBInstanceDetail = "DescribeDBInstanceDetail"

// DescribeDBInstanceDetailRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeDBInstanceDetail operation. The "output" return
// value will be populated with the DescribeDBInstanceDetailCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeDBInstanceDetailCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeDBInstanceDetailCommon Send returns without error.
//
// See DescribeDBInstanceDetail for more information on using the DescribeDBInstanceDetail
// API call, and error handling.
//
//    // Example sending a request using the DescribeDBInstanceDetailRequest method.
//    req, resp := client.DescribeDBInstanceDetailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEDBM) DescribeDBInstanceDetailRequest(input *DescribeDBInstanceDetailInput) (req *request.Request, output *DescribeDBInstanceDetailOutput) {
	op := &request.Operation{
		Name:       opDescribeDBInstanceDetail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBInstanceDetailInput{}
	}

	output = &DescribeDBInstanceDetailOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeDBInstanceDetail API operation for VEDBM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEDBM's
// API operation DescribeDBInstanceDetail for usage and error information.
func (c *VEDBM) DescribeDBInstanceDetail(input *DescribeDBInstanceDetailInput) (*DescribeDBInstanceDetailOutput, error) {
	req, out := c.DescribeDBInstanceDetailRequest(input)
	return out, req.Send()
}

// DescribeDBInstanceDetailWithContext is the same as DescribeDBInstanceDetail with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBInstanceDetail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEDBM) DescribeDBInstanceDetailWithContext(ctx volcengine.Context, input *DescribeDBInstanceDetailInput, opts ...request.Option) (*DescribeDBInstanceDetailOutput, error) {
	req, out := c.DescribeDBInstanceDetailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddressForDescribeDBInstanceDetailOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DNSVisibility *bool `type:"boolean" json:",omitempty"`

	Domain *string `type:"string" json:",omitempty"`

	EipId *string `type:"string" json:",omitempty"`

	IPAddress *string `type:"string" json:",omitempty"`

	NetworkType *string `type:"string" json:",omitempty" enum:"EnumOfNetworkTypeForDescribeDBInstanceDetailOutput"`

	Port *string `type:"string" json:",omitempty"`

	SubnetId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AddressForDescribeDBInstanceDetailOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AddressForDescribeDBInstanceDetailOutput) GoString() string {
	return s.String()
}

// SetDNSVisibility sets the DNSVisibility field's value.
func (s *AddressForDescribeDBInstanceDetailOutput) SetDNSVisibility(v bool) *AddressForDescribeDBInstanceDetailOutput {
	s.DNSVisibility = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *AddressForDescribeDBInstanceDetailOutput) SetDomain(v string) *AddressForDescribeDBInstanceDetailOutput {
	s.Domain = &v
	return s
}

// SetEipId sets the EipId field's value.
func (s *AddressForDescribeDBInstanceDetailOutput) SetEipId(v string) *AddressForDescribeDBInstanceDetailOutput {
	s.EipId = &v
	return s
}

// SetIPAddress sets the IPAddress field's value.
func (s *AddressForDescribeDBInstanceDetailOutput) SetIPAddress(v string) *AddressForDescribeDBInstanceDetailOutput {
	s.IPAddress = &v
	return s
}

// SetNetworkType sets the NetworkType field's value.
func (s *AddressForDescribeDBInstanceDetailOutput) SetNetworkType(v string) *AddressForDescribeDBInstanceDetailOutput {
	s.NetworkType = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AddressForDescribeDBInstanceDetailOutput) SetPort(v string) *AddressForDescribeDBInstanceDetailOutput {
	s.Port = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *AddressForDescribeDBInstanceDetailOutput) SetSubnetId(v string) *AddressForDescribeDBInstanceDetailOutput {
	s.SubnetId = &v
	return s
}

type ChargeDetailForDescribeDBInstanceDetailOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AutoRenew *bool `type:"boolean" json:",omitempty"`

	ChargeEndTime *string `type:"string" json:",omitempty"`

	ChargeStartTime *string `type:"string" json:",omitempty"`

	ChargeStatus *string `type:"string" json:",omitempty" enum:"EnumOfChargeStatusForDescribeDBInstanceDetailOutput"`

	ChargeType *string `type:"string" json:",omitempty" enum:"EnumOfChargeTypeForDescribeDBInstanceDetailOutput"`

	OverdueReclaimTime *string `type:"string" json:",omitempty"`

	OverdueTime *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ChargeDetailForDescribeDBInstanceDetailOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ChargeDetailForDescribeDBInstanceDetailOutput) GoString() string {
	return s.String()
}

// SetAutoRenew sets the AutoRenew field's value.
func (s *ChargeDetailForDescribeDBInstanceDetailOutput) SetAutoRenew(v bool) *ChargeDetailForDescribeDBInstanceDetailOutput {
	s.AutoRenew = &v
	return s
}

// SetChargeEndTime sets the ChargeEndTime field's value.
func (s *ChargeDetailForDescribeDBInstanceDetailOutput) SetChargeEndTime(v string) *ChargeDetailForDescribeDBInstanceDetailOutput {
	s.ChargeEndTime = &v
	return s
}

// SetChargeStartTime sets the ChargeStartTime field's value.
func (s *ChargeDetailForDescribeDBInstanceDetailOutput) SetChargeStartTime(v string) *ChargeDetailForDescribeDBInstanceDetailOutput {
	s.ChargeStartTime = &v
	return s
}

// SetChargeStatus sets the ChargeStatus field's value.
func (s *ChargeDetailForDescribeDBInstanceDetailOutput) SetChargeStatus(v string) *ChargeDetailForDescribeDBInstanceDetailOutput {
	s.ChargeStatus = &v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *ChargeDetailForDescribeDBInstanceDetailOutput) SetChargeType(v string) *ChargeDetailForDescribeDBInstanceDetailOutput {
	s.ChargeType = &v
	return s
}

// SetOverdueReclaimTime sets the OverdueReclaimTime field's value.
func (s *ChargeDetailForDescribeDBInstanceDetailOutput) SetOverdueReclaimTime(v string) *ChargeDetailForDescribeDBInstanceDetailOutput {
	s.OverdueReclaimTime = &v
	return s
}

// SetOverdueTime sets the OverdueTime field's value.
func (s *ChargeDetailForDescribeDBInstanceDetailOutput) SetOverdueTime(v string) *ChargeDetailForDescribeDBInstanceDetailOutput {
	s.OverdueTime = &v
	return s
}

type DescribeDBInstanceDetailInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s DescribeDBInstanceDetailInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBInstanceDetailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBInstanceDetailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBInstanceDetailInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeDBInstanceDetailInput) SetInstanceId(v string) *DescribeDBInstanceDetailInput {
	s.InstanceId = &v
	return s
}

type DescribeDBInstanceDetailOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	ChargeDetail *ChargeDetailForDescribeDBInstanceDetailOutput `type:"structure" json:",omitempty"`

	Endpoints []*EndpointForDescribeDBInstanceDetailOutput `type:"list" json:",omitempty"`

	InstanceDetail *InstanceDetailForDescribeDBInstanceDetailOutput `type:"structure" json:",omitempty"`

	Nodes []*NodeForDescribeDBInstanceDetailOutput `type:"list" json:",omitempty"`

	Tags []*TagForDescribeDBInstanceDetailOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s DescribeDBInstanceDetailOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBInstanceDetailOutput) GoString() string {
	return s.String()
}

// SetChargeDetail sets the ChargeDetail field's value.
func (s *DescribeDBInstanceDetailOutput) SetChargeDetail(v *ChargeDetailForDescribeDBInstanceDetailOutput) *DescribeDBInstanceDetailOutput {
	s.ChargeDetail = v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *DescribeDBInstanceDetailOutput) SetEndpoints(v []*EndpointForDescribeDBInstanceDetailOutput) *DescribeDBInstanceDetailOutput {
	s.Endpoints = v
	return s
}

// SetInstanceDetail sets the InstanceDetail field's value.
func (s *DescribeDBInstanceDetailOutput) SetInstanceDetail(v *InstanceDetailForDescribeDBInstanceDetailOutput) *DescribeDBInstanceDetailOutput {
	s.InstanceDetail = v
	return s
}

// SetNodes sets the Nodes field's value.
func (s *DescribeDBInstanceDetailOutput) SetNodes(v []*NodeForDescribeDBInstanceDetailOutput) *DescribeDBInstanceDetailOutput {
	s.Nodes = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeDBInstanceDetailOutput) SetTags(v []*TagForDescribeDBInstanceDetailOutput) *DescribeDBInstanceDetailOutput {
	s.Tags = v
	return s
}

type EndpointForDescribeDBInstanceDetailOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Addresses []*AddressForDescribeDBInstanceDetailOutput `type:"list" json:",omitempty"`

	AutoAddNewNodes *bool `type:"boolean" json:",omitempty"`

	ConsistLevel *string `type:"string" json:",omitempty" enum:"EnumOfConsistLevelForDescribeDBInstanceDetailOutput"`

	ConsistTimeout *int32 `type:"int32" json:",omitempty"`

	ConsistTimeoutAction *string `type:"string" json:",omitempty" enum:"EnumOfConsistTimeoutActionForDescribeDBInstanceDetailOutput"`

	Description *string `type:"string" json:",omitempty"`

	DistributedTransaction *bool `type:"boolean" json:",omitempty"`

	EndpointId *string `type:"string" json:",omitempty"`

	EndpointName *string `type:"string" json:",omitempty"`

	EndpointType *string `type:"string" json:",omitempty" enum:"EnumOfEndpointTypeForDescribeDBInstanceDetailOutput"`

	MasterAcceptReadRequests *bool `type:"boolean" json:",omitempty"`

	NodeIds []*string `type:"list" json:",omitempty"`

	ReadWriteMode *string `type:"string" json:",omitempty" enum:"EnumOfReadWriteModeForDescribeDBInstanceDetailOutput"`
}

// String returns the string representation
func (s EndpointForDescribeDBInstanceDetailOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointForDescribeDBInstanceDetailOutput) GoString() string {
	return s.String()
}

// SetAddresses sets the Addresses field's value.
func (s *EndpointForDescribeDBInstanceDetailOutput) SetAddresses(v []*AddressForDescribeDBInstanceDetailOutput) *EndpointForDescribeDBInstanceDetailOutput {
	s.Addresses = v
	return s
}

// SetAutoAddNewNodes sets the AutoAddNewNodes field's value.
func (s *EndpointForDescribeDBInstanceDetailOutput) SetAutoAddNewNodes(v bool) *EndpointForDescribeDBInstanceDetailOutput {
	s.AutoAddNewNodes = &v
	return s
}

// SetConsistLevel sets the ConsistLevel field's value.
func (s *EndpointForDescribeDBInstanceDetailOutput) SetConsistLevel(v string) *EndpointForDescribeDBInstanceDetailOutput {
	s.ConsistLevel = &v
	return s
}

// SetConsistTimeout sets the ConsistTimeout field's value.
func (s *EndpointForDescribeDBInstanceDetailOutput) SetConsistTimeout(v int32) *EndpointForDescribeDBInstanceDetailOutput {
	s.ConsistTimeout = &v
	return s
}

// SetConsistTimeoutAction sets the ConsistTimeoutAction field's value.
func (s *EndpointForDescribeDBInstanceDetailOutput) SetConsistTimeoutAction(v string) *EndpointForDescribeDBInstanceDetailOutput {
	s.ConsistTimeoutAction = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *EndpointForDescribeDBInstanceDetailOutput) SetDescription(v string) *EndpointForDescribeDBInstanceDetailOutput {
	s.Description = &v
	return s
}

// SetDistributedTransaction sets the DistributedTransaction field's value.
func (s *EndpointForDescribeDBInstanceDetailOutput) SetDistributedTransaction(v bool) *EndpointForDescribeDBInstanceDetailOutput {
	s.DistributedTransaction = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *EndpointForDescribeDBInstanceDetailOutput) SetEndpointId(v string) *EndpointForDescribeDBInstanceDetailOutput {
	s.EndpointId = &v
	return s
}

// SetEndpointName sets the EndpointName field's value.
func (s *EndpointForDescribeDBInstanceDetailOutput) SetEndpointName(v string) *EndpointForDescribeDBInstanceDetailOutput {
	s.EndpointName = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *EndpointForDescribeDBInstanceDetailOutput) SetEndpointType(v string) *EndpointForDescribeDBInstanceDetailOutput {
	s.EndpointType = &v
	return s
}

// SetMasterAcceptReadRequests sets the MasterAcceptReadRequests field's value.
func (s *EndpointForDescribeDBInstanceDetailOutput) SetMasterAcceptReadRequests(v bool) *EndpointForDescribeDBInstanceDetailOutput {
	s.MasterAcceptReadRequests = &v
	return s
}

// SetNodeIds sets the NodeIds field's value.
func (s *EndpointForDescribeDBInstanceDetailOutput) SetNodeIds(v []*string) *EndpointForDescribeDBInstanceDetailOutput {
	s.NodeIds = v
	return s
}

// SetReadWriteMode sets the ReadWriteMode field's value.
func (s *EndpointForDescribeDBInstanceDetailOutput) SetReadWriteMode(v string) *EndpointForDescribeDBInstanceDetailOutput {
	s.ReadWriteMode = &v
	return s
}

type InstanceDetailForDescribeDBInstanceDetailOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	DBEngineVersion *string `type:"string" json:",omitempty" enum:"EnumOfDBEngineVersionForDescribeDBInstanceDetailOutput"`

	DeletionProtection *string `type:"string" json:",omitempty" enum:"EnumOfDeletionProtectionForDescribeDBInstanceDetailOutput"`

	InstanceId *string `type:"string" json:",omitempty"`

	InstanceName *string `type:"string" json:",omitempty"`

	InstanceStatus *string `type:"string" json:",omitempty" enum:"EnumOfInstanceStatusForDescribeDBInstanceDetailOutput"`

	InstanceStructures []*InstanceStructureForDescribeDBInstanceDetailOutput `type:"list" json:",omitempty"`

	LowerCaseTableNames *string `type:"string" json:",omitempty"`

	MaintenanceWindow *MaintenanceWindowForDescribeDBInstanceDetailOutput `type:"structure" json:",omitempty"`

	PrePaidStorageInGB *int32 `type:"int32" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	RegionId *string `type:"string" json:",omitempty"`

	SpecFamily *string `type:"string" json:",omitempty" enum:"EnumOfSpecFamilyForDescribeDBInstanceDetailOutput"`

	StorageChargeType *string `type:"string" json:",omitempty" enum:"EnumOfStorageChargeTypeForDescribeDBInstanceDetailOutput"`

	StorageUsedGiB *float64 `type:"double" json:",omitempty"`

	SubnetId *string `type:"string" json:",omitempty"`

	TimeZone *string `type:"string" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`

	ZoneIds *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s InstanceDetailForDescribeDBInstanceDetailOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceDetailForDescribeDBInstanceDetailOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *InstanceDetailForDescribeDBInstanceDetailOutput) SetCreateTime(v string) *InstanceDetailForDescribeDBInstanceDetailOutput {
	s.CreateTime = &v
	return s
}

// SetDBEngineVersion sets the DBEngineVersion field's value.
func (s *InstanceDetailForDescribeDBInstanceDetailOutput) SetDBEngineVersion(v string) *InstanceDetailForDescribeDBInstanceDetailOutput {
	s.DBEngineVersion = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *InstanceDetailForDescribeDBInstanceDetailOutput) SetDeletionProtection(v string) *InstanceDetailForDescribeDBInstanceDetailOutput {
	s.DeletionProtection = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *InstanceDetailForDescribeDBInstanceDetailOutput) SetInstanceId(v string) *InstanceDetailForDescribeDBInstanceDetailOutput {
	s.InstanceId = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *InstanceDetailForDescribeDBInstanceDetailOutput) SetInstanceName(v string) *InstanceDetailForDescribeDBInstanceDetailOutput {
	s.InstanceName = &v
	return s
}

// SetInstanceStatus sets the InstanceStatus field's value.
func (s *InstanceDetailForDescribeDBInstanceDetailOutput) SetInstanceStatus(v string) *InstanceDetailForDescribeDBInstanceDetailOutput {
	s.InstanceStatus = &v
	return s
}

// SetInstanceStructures sets the InstanceStructures field's value.
func (s *InstanceDetailForDescribeDBInstanceDetailOutput) SetInstanceStructures(v []*InstanceStructureForDescribeDBInstanceDetailOutput) *InstanceDetailForDescribeDBInstanceDetailOutput {
	s.InstanceStructures = v
	return s
}

// SetLowerCaseTableNames sets the LowerCaseTableNames field's value.
func (s *InstanceDetailForDescribeDBInstanceDetailOutput) SetLowerCaseTableNames(v string) *InstanceDetailForDescribeDBInstanceDetailOutput {
	s.LowerCaseTableNames = &v
	return s
}

// SetMaintenanceWindow sets the MaintenanceWindow field's value.
func (s *InstanceDetailForDescribeDBInstanceDetailOutput) SetMaintenanceWindow(v *MaintenanceWindowForDescribeDBInstanceDetailOutput) *InstanceDetailForDescribeDBInstanceDetailOutput {
	s.MaintenanceWindow = v
	return s
}

// SetPrePaidStorageInGB sets the PrePaidStorageInGB field's value.
func (s *InstanceDetailForDescribeDBInstanceDetailOutput) SetPrePaidStorageInGB(v int32) *InstanceDetailForDescribeDBInstanceDetailOutput {
	s.PrePaidStorageInGB = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *InstanceDetailForDescribeDBInstanceDetailOutput) SetProjectName(v string) *InstanceDetailForDescribeDBInstanceDetailOutput {
	s.ProjectName = &v
	return s
}

// SetRegionId sets the RegionId field's value.
func (s *InstanceDetailForDescribeDBInstanceDetailOutput) SetRegionId(v string) *InstanceDetailForDescribeDBInstanceDetailOutput {
	s.RegionId = &v
	return s
}

// SetSpecFamily sets the SpecFamily field's value.
func (s *InstanceDetailForDescribeDBInstanceDetailOutput) SetSpecFamily(v string) *InstanceDetailForDescribeDBInstanceDetailOutput {
	s.SpecFamily = &v
	return s
}

// SetStorageChargeType sets the StorageChargeType field's value.
func (s *InstanceDetailForDescribeDBInstanceDetailOutput) SetStorageChargeType(v string) *InstanceDetailForDescribeDBInstanceDetailOutput {
	s.StorageChargeType = &v
	return s
}

// SetStorageUsedGiB sets the StorageUsedGiB field's value.
func (s *InstanceDetailForDescribeDBInstanceDetailOutput) SetStorageUsedGiB(v float64) *InstanceDetailForDescribeDBInstanceDetailOutput {
	s.StorageUsedGiB = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *InstanceDetailForDescribeDBInstanceDetailOutput) SetSubnetId(v string) *InstanceDetailForDescribeDBInstanceDetailOutput {
	s.SubnetId = &v
	return s
}

// SetTimeZone sets the TimeZone field's value.
func (s *InstanceDetailForDescribeDBInstanceDetailOutput) SetTimeZone(v string) *InstanceDetailForDescribeDBInstanceDetailOutput {
	s.TimeZone = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *InstanceDetailForDescribeDBInstanceDetailOutput) SetVpcId(v string) *InstanceDetailForDescribeDBInstanceDetailOutput {
	s.VpcId = &v
	return s
}

// SetZoneIds sets the ZoneIds field's value.
func (s *InstanceDetailForDescribeDBInstanceDetailOutput) SetZoneIds(v string) *InstanceDetailForDescribeDBInstanceDetailOutput {
	s.ZoneIds = &v
	return s
}

type InstanceStructureForDescribeDBInstanceDetailOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Nodes []*NodeForDescribeDBInstanceDetailOutput `type:"list" json:",omitempty"`

	SubInstanceType *string `type:"string" json:",omitempty" enum:"EnumOfSubInstanceTypeForDescribeDBInstanceDetailOutput"`

	ZoneIds *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s InstanceStructureForDescribeDBInstanceDetailOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceStructureForDescribeDBInstanceDetailOutput) GoString() string {
	return s.String()
}

// SetNodes sets the Nodes field's value.
func (s *InstanceStructureForDescribeDBInstanceDetailOutput) SetNodes(v []*NodeForDescribeDBInstanceDetailOutput) *InstanceStructureForDescribeDBInstanceDetailOutput {
	s.Nodes = v
	return s
}

// SetSubInstanceType sets the SubInstanceType field's value.
func (s *InstanceStructureForDescribeDBInstanceDetailOutput) SetSubInstanceType(v string) *InstanceStructureForDescribeDBInstanceDetailOutput {
	s.SubInstanceType = &v
	return s
}

// SetZoneIds sets the ZoneIds field's value.
func (s *InstanceStructureForDescribeDBInstanceDetailOutput) SetZoneIds(v string) *InstanceStructureForDescribeDBInstanceDetailOutput {
	s.ZoneIds = &v
	return s
}

type MaintenanceWindowForDescribeDBInstanceDetailOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DayKind *string `type:"string" json:",omitempty" enum:"EnumOfDayKindForDescribeDBInstanceDetailOutput"`

	DayOfMonth []*int32 `type:"list" json:",omitempty"`

	DayOfWeek []*string `type:"list" json:",omitempty"`

	MaintenanceTime *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s MaintenanceWindowForDescribeDBInstanceDetailOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MaintenanceWindowForDescribeDBInstanceDetailOutput) GoString() string {
	return s.String()
}

// SetDayKind sets the DayKind field's value.
func (s *MaintenanceWindowForDescribeDBInstanceDetailOutput) SetDayKind(v string) *MaintenanceWindowForDescribeDBInstanceDetailOutput {
	s.DayKind = &v
	return s
}

// SetDayOfMonth sets the DayOfMonth field's value.
func (s *MaintenanceWindowForDescribeDBInstanceDetailOutput) SetDayOfMonth(v []*int32) *MaintenanceWindowForDescribeDBInstanceDetailOutput {
	s.DayOfMonth = v
	return s
}

// SetDayOfWeek sets the DayOfWeek field's value.
func (s *MaintenanceWindowForDescribeDBInstanceDetailOutput) SetDayOfWeek(v []*string) *MaintenanceWindowForDescribeDBInstanceDetailOutput {
	s.DayOfWeek = v
	return s
}

// SetMaintenanceTime sets the MaintenanceTime field's value.
func (s *MaintenanceWindowForDescribeDBInstanceDetailOutput) SetMaintenanceTime(v string) *MaintenanceWindowForDescribeDBInstanceDetailOutput {
	s.MaintenanceTime = &v
	return s
}

type NodeForDescribeDBInstanceDetailOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Memory *int32 `type:"int32" json:",omitempty"`

	NodeId *string `type:"string" json:",omitempty"`

	NodeSpec *string `type:"string" json:",omitempty" enum:"EnumOfNodeSpecForDescribeDBInstanceDetailOutput"`

	NodeType *string `type:"string" json:",omitempty" enum:"EnumOfNodeTypeForDescribeDBInstanceDetailOutput"`

	VCPU *int32 `type:"int32" json:"vCPU,omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NodeForDescribeDBInstanceDetailOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeForDescribeDBInstanceDetailOutput) GoString() string {
	return s.String()
}

// SetMemory sets the Memory field's value.
func (s *NodeForDescribeDBInstanceDetailOutput) SetMemory(v int32) *NodeForDescribeDBInstanceDetailOutput {
	s.Memory = &v
	return s
}

// SetNodeId sets the NodeId field's value.
func (s *NodeForDescribeDBInstanceDetailOutput) SetNodeId(v string) *NodeForDescribeDBInstanceDetailOutput {
	s.NodeId = &v
	return s
}

// SetNodeSpec sets the NodeSpec field's value.
func (s *NodeForDescribeDBInstanceDetailOutput) SetNodeSpec(v string) *NodeForDescribeDBInstanceDetailOutput {
	s.NodeSpec = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *NodeForDescribeDBInstanceDetailOutput) SetNodeType(v string) *NodeForDescribeDBInstanceDetailOutput {
	s.NodeType = &v
	return s
}

// SetVCPU sets the VCPU field's value.
func (s *NodeForDescribeDBInstanceDetailOutput) SetVCPU(v int32) *NodeForDescribeDBInstanceDetailOutput {
	s.VCPU = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *NodeForDescribeDBInstanceDetailOutput) SetZoneId(v string) *NodeForDescribeDBInstanceDetailOutput {
	s.ZoneId = &v
	return s
}

type TagForDescribeDBInstanceDetailOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForDescribeDBInstanceDetailOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForDescribeDBInstanceDetailOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForDescribeDBInstanceDetailOutput) SetKey(v string) *TagForDescribeDBInstanceDetailOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForDescribeDBInstanceDetailOutput) SetValue(v string) *TagForDescribeDBInstanceDetailOutput {
	s.Value = &v
	return s
}

const (
	// EnumOfChargeStatusForDescribeDBInstanceDetailOutputNormal is a EnumOfChargeStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfChargeStatusForDescribeDBInstanceDetailOutputNormal = "Normal"

	// EnumOfChargeStatusForDescribeDBInstanceDetailOutputOverdue is a EnumOfChargeStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfChargeStatusForDescribeDBInstanceDetailOutputOverdue = "Overdue"

	// EnumOfChargeStatusForDescribeDBInstanceDetailOutputShutdown is a EnumOfChargeStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfChargeStatusForDescribeDBInstanceDetailOutputShutdown = "Shutdown"
)

const (
	// EnumOfChargeTypeForDescribeDBInstanceDetailOutputPostPaid is a EnumOfChargeTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfChargeTypeForDescribeDBInstanceDetailOutputPostPaid = "PostPaid"

	// EnumOfChargeTypeForDescribeDBInstanceDetailOutputPrePaid is a EnumOfChargeTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfChargeTypeForDescribeDBInstanceDetailOutputPrePaid = "PrePaid"
)

const (
	// EnumOfConsistLevelForDescribeDBInstanceDetailOutputEventual is a EnumOfConsistLevelForDescribeDBInstanceDetailOutput enum value
	EnumOfConsistLevelForDescribeDBInstanceDetailOutputEventual = "Eventual"

	// EnumOfConsistLevelForDescribeDBInstanceDetailOutputSession is a EnumOfConsistLevelForDescribeDBInstanceDetailOutput enum value
	EnumOfConsistLevelForDescribeDBInstanceDetailOutputSession = "Session"

	// EnumOfConsistLevelForDescribeDBInstanceDetailOutputGlobal is a EnumOfConsistLevelForDescribeDBInstanceDetailOutput enum value
	EnumOfConsistLevelForDescribeDBInstanceDetailOutputGlobal = "Global"
)

const (
	// EnumOfConsistTimeoutActionForDescribeDBInstanceDetailOutputReturnError is a EnumOfConsistTimeoutActionForDescribeDBInstanceDetailOutput enum value
	EnumOfConsistTimeoutActionForDescribeDBInstanceDetailOutputReturnError = "ReturnError"

	// EnumOfConsistTimeoutActionForDescribeDBInstanceDetailOutputReadMaster is a EnumOfConsistTimeoutActionForDescribeDBInstanceDetailOutput enum value
	EnumOfConsistTimeoutActionForDescribeDBInstanceDetailOutputReadMaster = "ReadMaster"
)

const (
	// EnumOfDBEngineVersionForDescribeDBInstanceDetailOutputMySql80 is a EnumOfDBEngineVersionForDescribeDBInstanceDetailOutput enum value
	EnumOfDBEngineVersionForDescribeDBInstanceDetailOutputMySql80 = "MySQL_8_0"

	// EnumOfDBEngineVersionForDescribeDBInstanceDetailOutputMySql57 is a EnumOfDBEngineVersionForDescribeDBInstanceDetailOutput enum value
	EnumOfDBEngineVersionForDescribeDBInstanceDetailOutputMySql57 = "MySQL_5_7"
)

const (
	// EnumOfDayKindForDescribeDBInstanceDetailOutputWeek is a EnumOfDayKindForDescribeDBInstanceDetailOutput enum value
	EnumOfDayKindForDescribeDBInstanceDetailOutputWeek = "Week"

	// EnumOfDayKindForDescribeDBInstanceDetailOutputMonth is a EnumOfDayKindForDescribeDBInstanceDetailOutput enum value
	EnumOfDayKindForDescribeDBInstanceDetailOutputMonth = "Month"
)

const (
	// EnumOfDayOfWeekListForDescribeDBInstanceDetailOutputSunday is a EnumOfDayOfWeekListForDescribeDBInstanceDetailOutput enum value
	EnumOfDayOfWeekListForDescribeDBInstanceDetailOutputSunday = "Sunday"

	// EnumOfDayOfWeekListForDescribeDBInstanceDetailOutputMonday is a EnumOfDayOfWeekListForDescribeDBInstanceDetailOutput enum value
	EnumOfDayOfWeekListForDescribeDBInstanceDetailOutputMonday = "Monday"

	// EnumOfDayOfWeekListForDescribeDBInstanceDetailOutputTuesday is a EnumOfDayOfWeekListForDescribeDBInstanceDetailOutput enum value
	EnumOfDayOfWeekListForDescribeDBInstanceDetailOutputTuesday = "Tuesday"

	// EnumOfDayOfWeekListForDescribeDBInstanceDetailOutputWednesday is a EnumOfDayOfWeekListForDescribeDBInstanceDetailOutput enum value
	EnumOfDayOfWeekListForDescribeDBInstanceDetailOutputWednesday = "Wednesday"

	// EnumOfDayOfWeekListForDescribeDBInstanceDetailOutputThursday is a EnumOfDayOfWeekListForDescribeDBInstanceDetailOutput enum value
	EnumOfDayOfWeekListForDescribeDBInstanceDetailOutputThursday = "Thursday"

	// EnumOfDayOfWeekListForDescribeDBInstanceDetailOutputFriday is a EnumOfDayOfWeekListForDescribeDBInstanceDetailOutput enum value
	EnumOfDayOfWeekListForDescribeDBInstanceDetailOutputFriday = "Friday"

	// EnumOfDayOfWeekListForDescribeDBInstanceDetailOutputSaturday is a EnumOfDayOfWeekListForDescribeDBInstanceDetailOutput enum value
	EnumOfDayOfWeekListForDescribeDBInstanceDetailOutputSaturday = "Saturday"
)

const (
	// EnumOfDeletionProtectionForDescribeDBInstanceDetailOutputDisabled is a EnumOfDeletionProtectionForDescribeDBInstanceDetailOutput enum value
	EnumOfDeletionProtectionForDescribeDBInstanceDetailOutputDisabled = "disabled"

	// EnumOfDeletionProtectionForDescribeDBInstanceDetailOutputEnabled is a EnumOfDeletionProtectionForDescribeDBInstanceDetailOutput enum value
	EnumOfDeletionProtectionForDescribeDBInstanceDetailOutputEnabled = "enabled"
)

const (
	// EnumOfEndpointTypeForDescribeDBInstanceDetailOutputCluster is a EnumOfEndpointTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfEndpointTypeForDescribeDBInstanceDetailOutputCluster = "Cluster"

	// EnumOfEndpointTypeForDescribeDBInstanceDetailOutputPrimary is a EnumOfEndpointTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfEndpointTypeForDescribeDBInstanceDetailOutputPrimary = "Primary"

	// EnumOfEndpointTypeForDescribeDBInstanceDetailOutputCustom is a EnumOfEndpointTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfEndpointTypeForDescribeDBInstanceDetailOutputCustom = "Custom"
)

const (
	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputWaitingPaid is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputWaitingPaid = "WaitingPaid"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputRunning is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputRunning = "Running"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputCreating is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputCreating = "Creating"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputScaling is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputScaling = "Scaling"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputRestarting is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputRestarting = "Restarting"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputRestoring is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputRestoring = "Restoring"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputUpgrading is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputUpgrading = "Upgrading"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputPrimaryChanging is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputPrimaryChanging = "PrimaryChanging"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputUnavailable is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputUnavailable = "Unavailable"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputDeleting is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputDeleting = "Deleting"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputDeleted is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputDeleted = "Deleted"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputCreateFailed is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputCreateFailed = "CreateFailed"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputClosing is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputClosing = "Closing"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputExpired is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputExpired = "Expired"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputOwing is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputOwing = "Owing"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputResuming is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputResuming = "Resuming"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputAllowListMaintaining is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputAllowListMaintaining = "AllowListMaintaining"
)

const (
	// EnumOfNetworkTypeForDescribeDBInstanceDetailOutputPrivate is a EnumOfNetworkTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfNetworkTypeForDescribeDBInstanceDetailOutputPrivate = "Private"

	// EnumOfNetworkTypeForDescribeDBInstanceDetailOutputPublic is a EnumOfNetworkTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfNetworkTypeForDescribeDBInstanceDetailOutputPublic = "Public"
)

const (
	// EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX4Large is a EnumOfNodeSpecForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX4Large = "vedb.mysql.x4.large"

	// EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX8Large is a EnumOfNodeSpecForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX8Large = "vedb.mysql.x8.large"

	// EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX4Xlarge is a EnumOfNodeSpecForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX4Xlarge = "vedb.mysql.x4.xlarge"

	// EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX8Xlarge is a EnumOfNodeSpecForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX8Xlarge = "vedb.mysql.x8.xlarge"

	// EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX42xlarge is a EnumOfNodeSpecForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX42xlarge = "vedb.mysql.x4.2xlarge"

	// EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX82xlarge is a EnumOfNodeSpecForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX82xlarge = "vedb.mysql.x8.2xlarge"

	// EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX44xlarge is a EnumOfNodeSpecForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX44xlarge = "vedb.mysql.x4.4xlarge"

	// EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX84xlarge is a EnumOfNodeSpecForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX84xlarge = "vedb.mysql.x8.4xlarge"

	// EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX86xlarge is a EnumOfNodeSpecForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX86xlarge = "vedb.mysql.x8.6xlarge"

	// EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX48xlarge is a EnumOfNodeSpecForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX48xlarge = "vedb.mysql.x4.8xlarge"

	// EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX88xlarge is a EnumOfNodeSpecForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlX88xlarge = "vedb.mysql.x8.8xlarge"

	// EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlG4Large is a EnumOfNodeSpecForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlG4Large = "vedb.mysql.g4.large"

	// EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlG4Xlarge is a EnumOfNodeSpecForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlG4Xlarge = "vedb.mysql.g4.xlarge"

	// EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlG42xlarge is a EnumOfNodeSpecForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlG42xlarge = "vedb.mysql.g4.2xlarge"

	// EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlG82xlarge is a EnumOfNodeSpecForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlG82xlarge = "vedb.mysql.g8.2xlarge"

	// EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlG44xlarge is a EnumOfNodeSpecForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeSpecForDescribeDBInstanceDetailOutputVedbMysqlG44xlarge = "vedb.mysql.g4.4xlarge"
)

const (
	// EnumOfNodeTypeForDescribeDBInstanceDetailOutputPrimary is a EnumOfNodeTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeTypeForDescribeDBInstanceDetailOutputPrimary = "Primary"

	// EnumOfNodeTypeForDescribeDBInstanceDetailOutputReadOnly is a EnumOfNodeTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeTypeForDescribeDBInstanceDetailOutputReadOnly = "ReadOnly"
)

const (
	// EnumOfReadWriteModeForDescribeDBInstanceDetailOutputReadWrite is a EnumOfReadWriteModeForDescribeDBInstanceDetailOutput enum value
	EnumOfReadWriteModeForDescribeDBInstanceDetailOutputReadWrite = "ReadWrite"

	// EnumOfReadWriteModeForDescribeDBInstanceDetailOutputReadOnly is a EnumOfReadWriteModeForDescribeDBInstanceDetailOutput enum value
	EnumOfReadWriteModeForDescribeDBInstanceDetailOutputReadOnly = "ReadOnly"
)

const (
	// EnumOfSpecFamilyForDescribeDBInstanceDetailOutputGeneral is a EnumOfSpecFamilyForDescribeDBInstanceDetailOutput enum value
	EnumOfSpecFamilyForDescribeDBInstanceDetailOutputGeneral = "General"

	// EnumOfSpecFamilyForDescribeDBInstanceDetailOutputExclusive is a EnumOfSpecFamilyForDescribeDBInstanceDetailOutput enum value
	EnumOfSpecFamilyForDescribeDBInstanceDetailOutputExclusive = "Exclusive"
)

const (
	// EnumOfStorageChargeTypeForDescribeDBInstanceDetailOutputPostPaid is a EnumOfStorageChargeTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfStorageChargeTypeForDescribeDBInstanceDetailOutputPostPaid = "PostPaid"

	// EnumOfStorageChargeTypeForDescribeDBInstanceDetailOutputPrePaid is a EnumOfStorageChargeTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfStorageChargeTypeForDescribeDBInstanceDetailOutputPrePaid = "PrePaid"
)

const (
	// EnumOfSubInstanceTypeForDescribeDBInstanceDetailOutputPrimary is a EnumOfSubInstanceTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfSubInstanceTypeForDescribeDBInstanceDetailOutputPrimary = "Primary"
)
